/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.URI;

public class JMSURLHelper {
    private Vector appProperties;
    private String destination;
    private HashMap properties = new HashMap();
    private Vector requiredProperties;

    public JMSURLHelper(String url) throws Exception {
        this(new URI(url), null);
    }

    public JMSURLHelper(URI url) throws MalformedURLException {
        this(url, null);
    }

    public JMSURLHelper(URI url, String[] requiredProperties) throws MalformedURLException {
        this.appProperties = new Vector();
        this.destination = url.getEscapedPath();
        if (this.destination.startsWith("/")) {
            this.destination = this.destination.substring(1);
        }
        if (this.destination == null || this.destination.trim().length() < 1) {
            throw new MalformedURLException("Missing destination in URL");
        }
        String query = url.getEscapedQuery();
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, "&;");
            while (st.hasMoreTokens()) {
                String keyValue = st.nextToken();
                int eqIndex = keyValue.indexOf("=");
                if (eqIndex <= 0) continue;
                String key = keyValue.substring(0, eqIndex);
                String value = keyValue.substring(eqIndex + 1);
                if (key.startsWith("msgProp.")) {
                    key = key.substring("msgProp.".length());
                    this.addApplicationProperty(key);
                }
                this.properties.put(key, value);
            }
        }
        this.addRequiredProperties(requiredProperties);
        this.validateURL();
    }

    public void addApplicationProperty(String property) {
        if (property == null) {
            return;
        }
        if (this.appProperties == null) {
            this.appProperties = new Vector();
        }
        this.appProperties.addElement(property);
    }

    public void addApplicationProperty(String property, String value) {
        if (property == null) {
            return;
        }
        if (this.appProperties == null) {
            this.appProperties = new Vector();
        }
        this.properties.put(property, value);
        this.appProperties.addElement(property);
    }

    public void addRequiredProperties(String[] properties) {
        if (properties == null) {
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            this.addRequiredProperty(properties[i]);
        }
    }

    public void addRequiredProperty(String property) {
        if (property == null) {
            return;
        }
        if (this.requiredProperties == null) {
            this.requiredProperties = new Vector();
        }
        this.requiredProperties.addElement(property);
    }

    public String toString() {
        return this.getURLString();
    }

    private void validateURL() throws MalformedURLException {
        Vector required = this.getRequiredProperties();
        if (required == null) {
            return;
        }
        for (int i = 0; i < required.size(); ++i) {
            String key = (String)required.elementAt(i);
            if (this.properties.get(key) != null) continue;
            throw new MalformedURLException();
        }
    }

    public Vector getApplicationProperties() {
        return this.appProperties;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getDomain() {
        return this.getPropertyValue("domain");
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public String getPropertyValue(String property) {
        return (String)this.properties.get(property);
    }

    public Vector getRequiredProperties() {
        return this.requiredProperties;
    }

    public String getURLString() {
        StringBuffer text = new StringBuffer("jms:/");
        text.append(this.getDestination());
        text.append("?");
        Map props = (Map)this.properties.clone();
        boolean firstEntry = true;
        Iterator itr = this.properties.keySet().iterator();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            if (!firstEntry) {
                text.append("&");
            }
            if (this.appProperties.contains(key)) {
                text.append("msgProp.");
            }
            text.append(key);
            text.append("=");
            text.append(props.get(key));
            firstEntry = false;
        }
        return text.toString();
    }

    public String getVendor() {
        return this.getPropertyValue("vendor");
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

