/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.jms;

import java.util.HashMap;
import java.util.Hashtable;
import javax.jms.ConnectionFactory;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSession;
import javax.jms.Topic;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicSession;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.apache.axis2.transport.jms.JMSURLHelper;
import org.apache.axis2.transport.jms.JMSVendorAdapter;

public class JNDIVendorAdapter
extends JMSVendorAdapter {
    public static final String CONTEXT_FACTORY = "java.naming.factory.initial";
    public static final String PROVIDER_URL = "java.naming.provider.url";
    public static final String _CONNECTION_FACTORY_JNDI_NAME = "ConnectionFactoryJNDIName";
    public static final String CONNECTION_FACTORY_JNDI_VALUE = "ConnectionFactory";
    public static final String CONNECTION_FACTORY_JNDI_NAME = "transport.jms.ConnectionFactoryJNDIName";
    public static final String _DESTINATION = "Destination";
    public static final String DESTINATION = "transport.jms.Destination";
    public static final String _USER = "User";
    public static final String _PASSWORD = "Password";
    public static final String USER = "transport.jms.User";
    public static final String PASSWORD = "transport.jms.Password";
    private Context context;

    public void addVendorConnectionFactoryProperties(JMSURLHelper jmsurl, HashMap cfConfig) {
        String providerURL;
        String ctxFactory;
        String cfJNDIName = jmsurl.getPropertyValue(_CONNECTION_FACTORY_JNDI_NAME);
        if (cfJNDIName != null) {
            cfConfig.put(CONNECTION_FACTORY_JNDI_NAME, cfJNDIName);
        }
        if ((ctxFactory = jmsurl.getPropertyValue(CONTEXT_FACTORY)) != null) {
            cfConfig.put(CONTEXT_FACTORY, ctxFactory);
        }
        if ((providerURL = jmsurl.getPropertyValue(PROVIDER_URL)) != null) {
            cfConfig.put(PROVIDER_URL, providerURL);
        }
    }

    private ConnectionFactory getConnectionFactory(HashMap cfProps) throws Exception {
        String providerURL;
        if (cfProps == null) {
            throw new IllegalArgumentException("noCFProps");
        }
        String jndiName = (String)cfProps.get(CONNECTION_FACTORY_JNDI_NAME);
        if (jndiName == null || jndiName.trim().length() == 0) {
            jndiName = CONNECTION_FACTORY_JNDI_VALUE;
        }
        Hashtable<String, String> environment = new Hashtable<String, String>(cfProps);
        String ctxFactory = (String)cfProps.get(CONTEXT_FACTORY);
        if (ctxFactory != null) {
            environment.put(CONTEXT_FACTORY, ctxFactory);
        }
        if ((providerURL = (String)cfProps.get(PROVIDER_URL)) != null) {
            environment.put(PROVIDER_URL, providerURL);
        }
        this.context = new InitialContext(environment);
        return (ConnectionFactory)this.context.lookup(jndiName);
    }

    public Queue getQueue(QueueSession session, String name) throws Exception {
        return (Queue)this.context.lookup(name);
    }

    public QueueConnectionFactory getQueueConnectionFactory(HashMap cfConfig) throws Exception {
        return (QueueConnectionFactory)this.getConnectionFactory(cfConfig);
    }

    public Topic getTopic(TopicSession session, String name) throws Exception {
        return (Topic)this.context.lookup(name);
    }

    public TopicConnectionFactory getTopicConnectionFactory(HashMap cfConfig) throws Exception {
        return (TopicConnectionFactory)this.getConnectionFactory(cfConfig);
    }

    public boolean isMatchingConnectionFactory(ConnectionFactory cf, JMSURLHelper originalJMSURL, HashMap cfProps) {
        String originalCfJndiName;
        JMSURLHelper jmsurl = (JMSURLHelper)cfProps.get("transport.jms.EndpointAddress");
        String cfJndiName = jmsurl.getPropertyValue(_CONNECTION_FACTORY_JNDI_NAME);
        return cfJndiName.equalsIgnoreCase(originalCfJndiName = originalJMSURL.getPropertyValue(_CONNECTION_FACTORY_JNDI_NAME));
    }
}

