/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaUtil {
    public static SOAPEnvelope handleMediaTypeURLEncoded(MessageContext msgCtxt, HttpServletRequest request, XmlSchemaElement xmlSchemaElement, SOAPFactory soapFactory) throws AxisFault {
        Map requestParameterMap = request.getParameterMap();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        SOAPBody body = soapEnvelope.getBody();
        if (xmlSchemaElement == null) {
            OMElement bodyFirstChild = soapFactory.createOMElement(msgCtxt.getAxisOperation().getName(), (OMContainer)body);
            if (requestParameterMap != null) {
                Iterator requestParamMapIter = requestParameterMap.keySet().iterator();
                while (requestParamMapIter.hasNext()) {
                    String key = (String)requestParamMapIter.next();
                    String value = (String)((Object[])requestParameterMap.get(key))[0];
                    soapFactory.createOMElement(key, null, (OMContainer)bodyFirstChild).setText(value);
                }
            }
        } else {
            String targetNamespace = xmlSchemaElement.getQName().getNamespaceURI();
            QName bodyFirstChildQName = targetNamespace != null && !"".equals(targetNamespace) ? new QName(targetNamespace, xmlSchemaElement.getName()) : new QName(xmlSchemaElement.getName());
            OMElement bodyFirstChild = soapFactory.createOMElement(bodyFirstChildQName, (OMContainer)body);
            if ("POST".equals(request.getMethod()) || "GET".equals(request.getMethod())) {
                XmlSchemaComplexType complexType;
                XmlSchemaParticle particle;
                XmlSchemaType schemaType = xmlSchemaElement.getSchemaType();
                if (schemaType instanceof XmlSchemaComplexType && (particle = (complexType = (XmlSchemaComplexType)schemaType).getParticle()) instanceof XmlSchemaSequence) {
                    XmlSchemaSequence xmlSchemaSequence = (XmlSchemaSequence)particle;
                    Iterator iterator = xmlSchemaSequence.getItems().getIterator();
                    Map parameterMap = request.getParameterMap();
                    while (iterator.hasNext()) {
                        XmlSchemaElement innerElement = (XmlSchemaElement)iterator.next();
                        String name = innerElement.getName();
                        String[] parameterValuesArray = (String[])parameterMap.get(name);
                        if (parameterValuesArray.length > 0 && !"".equals(parameterValuesArray[0]) && parameterValuesArray[0] != null) {
                            soapFactory.createOMElement(name, null, (OMContainer)bodyFirstChild).setText(parameterValuesArray[0]);
                            continue;
                        }
                        throw new AxisFault("Required element " + name + " defined in the schema can not be found in the request");
                    }
                }
            } else {
                throw new AxisFault("According to WSDL 2.0 rules, we support complex types only");
            }
        }
        return soapEnvelope;
    }
}

