/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.ws.java2wsdl.Java2WSDLBuilder;
import org.apache.ws.java2wsdl.Java2WSDLConstants;
import org.apache.ws.java2wsdl.Java2WSDLUtils;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;

public class Java2WSDLCodegenEngine
implements Java2WSDLConstants {
    private Java2WSDLBuilder java2WsdlBuilder;
    public static final String WSDL_FILENAME_SUFFIX = ".wsdl";

    public Java2WSDLCodegenEngine(Map optionsMap) throws Exception {
        ClassLoader classLoader;
        FileOutputStream out;
        String outputFileName;
        String className;
        Java2WSDLCommandLineOption option = this.loadOption("o", "output", optionsMap);
        String outputFolderName = option == null ? System.getProperty("user.dir") : option.getOptionValue();
        File outputFolder = new File(outputFolderName);
        if (!outputFolder.exists()) {
            outputFolder.mkdirs();
        } else if (!outputFolder.isDirectory()) {
            throw new Exception("The specivied location " + outputFolderName + "is not a folder");
        }
        option = this.loadOption("cn", "className", optionsMap);
        String string = className = option == null ? null : option.getOptionValue();
        if (className == null || className.equals("")) {
            throw new Exception("class name must be present!");
        }
        option = this.loadOption("of", "outputFilename", optionsMap);
        String string2 = outputFileName = option == null ? null : option.getOptionValue();
        if (outputFileName == null) {
            outputFileName = Java2WSDLUtils.getSimpleClassName(className) + WSDL_FILENAME_SUFFIX;
        }
        File outputFile = new File(outputFolder, outputFileName);
        try {
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
            out = new FileOutputStream(outputFile);
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        option = this.loadOption("cp", "classPath", optionsMap);
        if (option != null) {
            ArrayList optionValues = option.getOptionValues();
            URL[] urls = new URL[optionValues.size()];
            String[] classPathEntries = optionValues.toArray(new String[optionValues.size()]);
            try {
                for (int i = 0; i < classPathEntries.length; ++i) {
                    String classPathEntry = classPathEntries[i];
                    urls[i] = Java2WSDLUtils.isURL(classPathEntry) ? new URL(classPathEntry) : new File(classPathEntry).toURL();
                }
            }
            catch (MalformedURLException e) {
                throw new Exception(e);
            }
            classLoader = new URLClassLoader(urls, Thread.currentThread().getContextClassLoader());
        } else {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.java2WsdlBuilder = new Java2WSDLBuilder(out, className, classLoader);
        option = this.loadOption("stn", "schemaTargetnamespace", optionsMap);
        this.java2WsdlBuilder.setSchemaTargetNamespace(option == null ? null : option.getOptionValue());
        option = this.loadOption("stp", "schemaTargetnamespacePrefix", optionsMap);
        this.java2WsdlBuilder.setSchemaTargetNamespacePrefix(option == null ? null : option.getOptionValue());
        option = this.loadOption("tn", "targetNamespace", optionsMap);
        this.java2WsdlBuilder.setTargetNamespace(option == null ? null : option.getOptionValue());
        option = this.loadOption("tp", "targetNamespacePrefix", optionsMap);
        this.java2WsdlBuilder.setTargetNamespacePrefix(option == null ? null : option.getOptionValue());
        option = this.loadOption("sn", "serviceName", optionsMap);
        this.java2WsdlBuilder.setServiceName(option == null ? Java2WSDLUtils.getSimpleClassName(className) : option.getOptionValue());
        option = this.loadOption("st", "st", optionsMap);
        if (option != null) {
            this.java2WsdlBuilder.setStyle(option.getOptionValue());
        }
        if ((option = this.loadOption("l", "l", optionsMap)) != null) {
            this.java2WsdlBuilder.setLocationUri(option.getOptionValue());
        }
        if ((option = this.loadOption("u", "u", optionsMap)) != null) {
            this.java2WsdlBuilder.setUse(option.getOptionValue());
        }
    }

    public void generate() throws Exception {
        try {
            this.java2WsdlBuilder.generateWSDL();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private Java2WSDLCommandLineOption loadOption(String shortOption, String longOption, Map options) {
        Java2WSDLCommandLineOption option = null;
        if (longOption != null && (option = (Java2WSDLCommandLineOption)options.get(longOption)) != null) {
            return option;
        }
        if (shortOption != null) {
            option = (Java2WSDLCommandLineOption)options.get(shortOption);
        }
        return option;
    }
}

