/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl;

import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;

public class WSDLUtil {
    public static boolean isInputPresentForMEP(String mep) {
        return "http://www.w3.org/2006/01/wsdl/in-opt-out".equals(mep) || "http://www.w3.org/ns/wsdl/in-only".equals(mep) || "http://www.w3.org/ns/wsdl/in-out".equals(mep) || "http://www.w3.org/ns/wsdl/out-in".equals(mep) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(mep) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(mep);
    }

    public static boolean isOutputPresentForMEP(String MEP) {
        return "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-in".equals(MEP) || "http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP);
    }

    public static QName getPartQName(String opName, String suffix, String partName) {
        return new QName(opName + suffix, partName);
    }

    public static String getConstantFromHTTPLocation(String httpLocation, String httpMethod) {
        int index;
        if (httpLocation.charAt(0) != '?') {
            httpLocation = "/" + httpLocation;
        }
        if ((index = httpLocation.indexOf("{")) > -1) {
            httpLocation = httpLocation.substring(0, index);
        }
        return httpMethod + httpLocation;
    }

    public static Pattern getConstantFromHTTPLocationForResource(String httpLocation, String httpMethod) {
        httpLocation = WSDLUtil.getRegexForLocation(httpLocation);
        String location = httpMethod + httpLocation;
        return Pattern.compile(location);
    }

    private static String getRegexForLocation(String httpLocation) {
        StringTokenizer tokenizer = new StringTokenizer(httpLocation, "/");
        StringBuilder regex = new StringBuilder("");
        while (tokenizer.hasMoreElements()) {
            String param = tokenizer.nextElement().toString();
            if (param.startsWith("{")) {
                regex = regex.append("/.*");
                continue;
            }
            regex = regex.append("/").append(param);
        }
        return regex.append("/").toString();
    }
}

