/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.util.ArrayList;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.description.ParameterIncludeImpl;
import org.apache.axis2.description.PhaseRule;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.i18n.Messages;

public class HandlerDescription
implements ParameterInclude {
    private String className;
    private Handler handler;
    private String name;
    private final ParameterInclude parameterInclude = new ParameterIncludeImpl();
    private ParameterInclude parent;
    private PhaseRule rules = new PhaseRule();

    public HandlerDescription() {
    }

    public HandlerDescription(String name) {
        this();
        this.name = name;
    }

    @Override
    public void addParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameterInclude.addParameter(param);
    }

    @Override
    public void removeParameter(Parameter param) throws AxisFault {
        if (this.isParameterLocked(param.getName())) {
            throw new AxisFault(Messages.getMessage("paramterlockedbyparent", param.getName()));
        }
        this.parameterInclude.removeParameter(param);
    }

    @Override
    public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        this.parameterInclude.deserializeParameters(parameterElement);
    }

    public String getClassName() {
        return this.className;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Parameter getParameter(String name) {
        Parameter parameter = this.parameterInclude.getParameter(name);
        if (parameter == null && this.parent != null) {
            return this.parent.getParameter(name);
        }
        return parameter;
    }

    @Override
    public ArrayList<Parameter> getParameters() {
        return this.parameterInclude.getParameters();
    }

    public ParameterInclude getParent() {
        return this.parent;
    }

    public PhaseRule getRules() {
        return this.rules;
    }

    @Override
    public boolean isParameterLocked(String parameterName) {
        if (this.parent != null && this.parent.isParameterLocked(parameterName)) {
            return true;
        }
        return this.parameterInclude.isParameterLocked(parameterName);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
        this.className = handler.getClass().getName();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(ParameterInclude parent) {
        this.parent = parent;
    }

    public void setRules(PhaseRule rules) {
        this.rules = rules;
    }
}

