/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.AddressingConstants;
import org.apache.axis2.addressing.AddressingHelper;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.PolicyInclude;
import org.apache.axis2.description.PolicySubject;
import org.apache.axis2.description.java2wsdl.Java2WSDLConstants;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.ExternalPolicySerializer;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyLocator;
import org.apache.axis2.util.PolicyUtil;
import org.apache.axis2.util.Utils;
import org.apache.axis2.util.WSDLSerializationUtil;
import org.apache.axis2.util.XMLUtils;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyReference;
import org.apache.neethi.PolicyRegistry;
import org.apache.ws.commons.schema.XmlSchema;

public class AxisService2WSDL11
implements Java2WSDLConstants {
    private AxisService axisService;
    private String serviceName;
    private String targetNamespace;
    private OMElement definition;
    private OMNamespace soap;
    private OMNamespace soap12;
    private OMNamespace http;
    private OMNamespace mime;
    private OMNamespace tns;
    private OMNamespace wsdl;
    private OMNamespace wsaw;
    private String style = "document";
    private String use = "literal";
    private HashMap policiesInDefinitions;
    private ExternalPolicySerializer serializer;
    private HashMap messagesMap;

    public AxisService2WSDL11(AxisService service) throws Exception {
        this.axisService = service;
        this.serviceName = service.getName();
        this.init();
    }

    private void init() throws AxisFault {
        this.targetNamespace = this.axisService.getTargetNamespace();
        this.serializer = new ExternalPolicySerializer();
        AxisConfiguration configuration = this.axisService.getAxisConfiguration();
        if (configuration != null) {
            this.serializer.setAssertionsToFilter(configuration.getLocalPolicyAssertions());
        }
    }

    public AxisService2WSDL11(AxisService service, String serviceName) throws Exception {
        this.axisService = service;
        this.serviceName = serviceName;
        this.init();
    }

    public OMElement generateOM() throws Exception {
        OMFactory fac = OMAbstractFactory.getOMFactory();
        this.wsdl = fac.createOMNamespace("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        OMElement ele = fac.createOMElement("definitions", this.wsdl);
        this.setDefinitionElement(ele);
        this.policiesInDefinitions = new HashMap();
        HashMap<String, String> namespaceMap = this.axisService.getNamespaceMap();
        if (namespaceMap == null) {
            namespaceMap = new HashMap<String, String>();
        }
        WSDLSerializationUtil.populateNamespaces(ele, namespaceMap);
        this.soap = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        this.soap12 = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/soap12/", "soap12");
        this.http = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/http/", "http");
        this.mime = ele.declareNamespace("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        this.wsaw = ele.declareNamespace("http://www.w3.org/2006/05/addressing/wsdl", "wsaw");
        String prefix = WSDLSerializationUtil.getPrefix(this.axisService.getTargetNamespace(), namespaceMap);
        if (prefix == null || "".equals(prefix)) {
            prefix = this.axisService.getTargetNamespacePrefix() != null ? this.axisService.getTargetNamespacePrefix() : "axis2";
        }
        namespaceMap.put(prefix, this.axisService.getTargetNamespace());
        this.tns = ele.declareNamespace(this.axisService.getTargetNamespace(), prefix);
        boolean disableREST = false;
        Parameter disableRESTParameter = this.axisService.getParameter("disableREST");
        if (disableRESTParameter != null && JavaUtils.isTrueExplicitly(disableRESTParameter.getValue())) {
            disableREST = true;
        }
        boolean disableSOAP11 = false;
        Parameter disableSOAP11Parameter = this.axisService.getParameter("disableSOAP11");
        if (disableSOAP11Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP11Parameter.getValue())) {
            disableSOAP11 = true;
        }
        boolean disableSOAP12 = false;
        Parameter disableSOAP12Parameter = this.axisService.getParameter("disableSOAP12");
        if (disableSOAP12Parameter != null && JavaUtils.isTrueExplicitly(disableSOAP12Parameter.getValue())) {
            disableSOAP12 = true;
        }
        WSDLSerializationUtil.addWSDLDocumentationElement(this.axisService, ele, fac, this.wsdl);
        ele.addAttribute("targetNamespace", this.axisService.getTargetNamespace(), null);
        OMElement wsdlTypes = fac.createOMElement("types", this.wsdl);
        ele.addChild((OMNode)wsdlTypes);
        this.axisService.populateSchemaMappings();
        ArrayList<XmlSchema> schemas = this.axisService.getSchema();
        for (int i = 0; i < schemas.size(); ++i) {
            StringWriter writer = new StringWriter();
            XmlSchema schema = this.axisService.getSchema(i);
            String targetNamespace = schema.getTargetNamespace();
            if ("http://www.w3.org/XML/1998/namespace".equals(targetNamespace)) continue;
            schema.write((Writer)writer);
            String schemaString = writer.toString();
            if ("".equals(schemaString)) continue;
            wsdlTypes.addChild(XMLUtils.toOM(new StringReader(schemaString)));
        }
        this.generateMessages(fac, ele);
        this.generatePortType(fac, ele);
        this.generateService(fac, ele, disableREST, disableSOAP12, disableSOAP11);
        this.addPoliciesToDefinitionElement(this.policiesInDefinitions.values().iterator(), this.definition);
        return ele;
    }

    private void generateMessages(OMFactory fac, OMElement defintions) {
        HashSet<String> faultMessageNames = new HashSet<String>();
        this.messagesMap = new HashMap();
        Iterator<AxisOperation> operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList<AxisMessage> faultyMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = operations.next();
            if (axisOperation.isControlOperation()) continue;
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                this.writeMessage(inaxisMessage, fac, defintions);
                this.generateHeaderMessages(inaxisMessage, fac, defintions);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                this.writeMessage(outAxisMessage, fac, defintions);
                this.generateHeaderMessages(outAxisMessage, fac, defintions);
            }
            if ((faultyMessages = axisOperation.getFaultMessages()) == null) continue;
            for (AxisMessage faultyMessage : faultyMessages) {
                AxisMessage axisMessage = faultyMessage;
                String name = axisMessage.getName();
                if (!faultMessageNames.add(name)) continue;
                this.writeMessage(axisMessage, fac, defintions);
                this.generateHeaderMessages(axisMessage, fac, defintions);
            }
        }
    }

    private void generateHeaderMessages(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        ArrayList extList = axismessage.getSoapHeaders();
        for (Object anExtList : extList) {
            SOAPHeaderMessage header = (SOAPHeaderMessage)anExtList;
            if (header.getMessage() == null || this.messagesMap.get(header.getMessage().getLocalPart()) != null) continue;
            this.messagesMap.put(header.getMessage().getLocalPart(), header);
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", header.getMessage().getLocalPart(), null);
            defintions.addChild((OMNode)messageElement);
            OMElement messagePart = fac.createOMElement("part", this.wsdl);
            messageElement.addChild((OMNode)messagePart);
            messagePart.addAttribute("name", header.part(), null);
            if (header.getElement() == null) {
                throw new RuntimeException("element is null for " + header.getMessage());
            }
            messagePart.addAttribute("element", WSDLSerializationUtil.getPrefix(header.getElement().getNamespaceURI(), this.axisService.getNamespaceMap()) + ":" + header.getElement().getLocalPart(), null);
        }
    }

    private void writeMessage(AxisMessage axismessage, OMFactory fac, OMElement defintions) {
        if (axismessage.getName() != null && this.messagesMap.get(axismessage.getName()) == null) {
            this.messagesMap.put(axismessage.getName(), axismessage);
            QName schemaElementName = axismessage.getElementQName();
            OMElement messageElement = fac.createOMElement("message", this.wsdl);
            messageElement.addAttribute("name", axismessage.getName(), null);
            defintions.addChild((OMNode)messageElement);
            if (schemaElementName != null) {
                OMElement messagePart = fac.createOMElement("part", this.wsdl);
                messageElement.addChild((OMNode)messagePart);
                if (axismessage.getMessagePartName() != null) {
                    messagePart.addAttribute("name", axismessage.getMessagePartName(), null);
                } else {
                    messagePart.addAttribute("name", axismessage.getPartName(), null);
                }
                String namespacePrefix = WSDLSerializationUtil.getPrefix(schemaElementName.getNamespaceURI(), this.axisService.getNamespaceMap());
                namespacePrefix = namespacePrefix != null ? namespacePrefix + ":" : "";
                messagePart.addAttribute("element", namespacePrefix + schemaElementName.getLocalPart(), null);
            }
        }
    }

    private void generatePortType(OMFactory fac, OMElement defintions) throws Exception {
        OMElement portType = fac.createOMElement("portType", this.wsdl);
        defintions.addChild((OMNode)portType);
        String portTypeName = this.serviceName + "PortType";
        Parameter param = this.axisService.getParameter("portTypeName");
        if (param != null) {
            portTypeName = (String)param.getValue();
        }
        portType.addAttribute("name", portTypeName, null);
        this.addPolicyAsExtAttribute(this.axisService, portType, fac);
        Iterator<AxisOperation> operations = this.axisService.getOperations();
        while (operations.hasNext()) {
            ArrayList<AxisMessage> faultMessages;
            AxisMessage outAxisMessage;
            AxisMessage inaxisMessage;
            AxisOperation axisOperation = operations.next();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String operationName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            WSDLSerializationUtil.addWSDLDocumentationElement(axisOperation, operation, fac, this.wsdl);
            portType.addChild((OMNode)operation);
            operation.addAttribute("name", operationName, null);
            this.addPolicyAsExtAttribute(axisOperation, operation, fac);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (inaxisMessage = axisOperation.getMessage("In")) != null) {
                OMElement input = fac.createOMElement("input", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement(inaxisMessage, input, fac, this.wsdl);
                input.addAttribute("message", this.tns.getPrefix() + ":" + inaxisMessage.getName(), null);
                this.addPolicyAsExtAttribute(inaxisMessage, input, fac);
                WSDLSerializationUtil.addWSAWActionAttribute(input, axisOperation.getInputAction(), this.wsaw);
                operation.addChild((OMNode)input);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (outAxisMessage = axisOperation.getMessage("Out")) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement(outAxisMessage, output, fac, this.wsdl);
                output.addAttribute("message", this.tns.getPrefix() + ":" + outAxisMessage.getName(), null);
                this.addPolicyAsExtAttribute(outAxisMessage, output, fac);
                WSDLSerializationUtil.addWSAWActionAttribute(output, axisOperation.getOutputAction(), this.wsaw);
                operation.addChild((OMNode)output);
            }
            if ((faultMessages = axisOperation.getFaultMessages()) == null) continue;
            Iterator<AxisMessage> iterator = faultMessages.iterator();
            while (iterator.hasNext()) {
                AxisMessage faultMessage;
                AxisMessage faultyMessage = faultMessage = iterator.next();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                WSDLSerializationUtil.addWSDLDocumentationElement(faultyMessage, fault, fac, this.wsdl);
                fault.addAttribute("message", this.tns.getPrefix() + ":" + faultyMessage.getName(), null);
                fault.addAttribute("name", faultyMessage.getName(), null);
                WSDLSerializationUtil.addWSAWActionAttribute(fault, axisOperation.getFaultAction(faultyMessage.getName()), this.wsaw);
                operation.addChild((OMNode)fault);
            }
        }
    }

    public void generateService(OMFactory fac, OMElement defintions, boolean disableREST, boolean disableSOAP12, boolean disableSOAP11) throws Exception {
        OMElement service = fac.createOMElement("service", this.wsdl);
        defintions.addChild((OMNode)service);
        service.addAttribute("name", this.serviceName, null);
        if (!disableSOAP11) {
            this.generateSoap11Port(fac, defintions, service);
        }
        if (!disableSOAP12) {
            this.generateSoap12Port(fac, defintions, service);
        }
        this.addPolicyAsExtElement(6, this.axisService.getPolicyInclude(), service);
        if (!disableREST) {
            this.generateHttpPort(fac, this.definition, service);
        }
    }

    private void writeSoapHeaders(AxisMessage inaxisMessage, OMFactory fac, OMElement input, OMNamespace soapNameSpace) throws Exception {
        ArrayList extElementList = inaxisMessage.getSoapHeaders();
        if (extElementList != null) {
            for (SOAPHeaderMessage soapheader : extElementList) {
                this.addSOAPHeader(fac, input, soapheader, soapNameSpace);
            }
        }
    }

    private void addExtensionElement(OMFactory fac, OMElement element, String name, String att1Name, String att1Value, String att2Name, String att2Value, OMNamespace soapNameSpace) {
        OMElement soapbinding = fac.createOMElement(name, soapNameSpace);
        element.addChild((OMNode)soapbinding);
        soapbinding.addAttribute(att1Name, att1Value, null);
        if (att2Name != null) {
            soapbinding.addAttribute(att2Name, att2Value, null);
        }
    }

    private void setDefinitionElement(OMElement defintion) {
        this.definition = defintion;
    }

    private void addSOAPHeader(OMFactory fac, OMElement element, SOAPHeaderMessage header, OMNamespace soapNameSpace) {
        OMElement extElement = fac.createOMElement("header", soapNameSpace);
        element.addChild((OMNode)extElement);
        String use = header.getUse();
        if (use != null) {
            extElement.addAttribute("use", use, null);
        }
        if (header.part() != null) {
            extElement.addAttribute("part", header.part(), null);
        }
        if (header.getMessage() != null) {
            extElement.addAttribute("message", WSDLSerializationUtil.getPrefix(this.targetNamespace, this.axisService.getNamespaceMap()) + ":" + header.getMessage().getLocalPart(), null);
        }
    }

    private void addPolicyAsExtElement(int type, PolicyInclude policyInclude, OMElement parentElement) throws Exception {
        ArrayList elementList = policyInclude.getPolicyElements(type);
        for (Object policyElement : elementList) {
            Policy p;
            OMElement child;
            if (policyElement instanceof Policy) {
                child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyElement, this.serializer);
                parentElement.addChild((OMNode)child);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            child = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyElement);
            OMElement firstChildElem = parentElement.getFirstElement();
            if (firstChildElem == null) {
                parentElement.addChild((OMNode)child);
            } else {
                firstChildElem.insertSiblingBefore((OMNode)child);
            }
            PolicyRegistry reg = policyInclude.getPolicyRegistry();
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = reg.lookup(key)) == null) {
                throw new Exception("Policy not found for uri : " + key);
            }
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    private void addPoliciesToDefinitionElement(Iterator iterator, OMElement definitionElement) throws Exception {
        while (iterator.hasNext()) {
            Policy policy = (Policy)iterator.next();
            OMElement policyElement = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policy, this.serializer);
            OMNode firstChild = this.definition.getFirstOMChild();
            if (firstChild != null) {
                firstChild.insertSiblingBefore((OMNode)policyElement);
                continue;
            }
            definitionElement.addChild((OMNode)policyElement);
        }
    }

    private void addPolicyToDefinitionElement(String key, Policy policy) {
        this.policiesInDefinitions.put(key, policy);
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    private void generateSoap11Port(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            String version;
            String type;
            if (!axisEndpoint.isActive()) continue;
            AxisBinding axisBinding = axisEndpoint.getBinding();
            if (axisEndpoint.getEndpointURL() == null || axisEndpoint.getEndpointURL().startsWith("local://") || !"http://schemas.xmlsoap.org/soap/http".equals(type = axisBinding.getType()) && !"http://www.w3.org/ns/wsdl/soap".equals(type) || !"http://schemas.xmlsoap.org/soap/envelope/".equals(version = (String)axisBinding.getProperty("wsoap:version"))) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            WSDLSerializationUtil.addExtensionElement(fac, port, "address", "location", endpointURL == null ? "" : endpointURL, this.soap);
            this.generateEPRElement(fac, port, endpointURL);
            this.addPolicyAsExtElement(axisEndpoint, port);
            this.generateSoap11Binding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateSoap12Port(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            String version;
            AxisBinding axisBinding;
            String type;
            if (!axisEndpoint.isActive() || axisEndpoint.getEndpointURL() == null || axisEndpoint.getEndpointURL().startsWith("local://") || !"http://schemas.xmlsoap.org/soap/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType()) && !"http://www.w3.org/ns/wsdl/soap".equals(type) || !"http://www.w3.org/2003/05/soap-envelope".equals(version = (String)axisBinding.getProperty("wsoap:version"))) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            WSDLSerializationUtil.addExtensionElement(fac, port, "address", "location", endpointURL == null ? "" : endpointURL, this.soap12);
            this.generateEPRElement(fac, port, endpointURL);
            this.addPolicyAsExtElement(axisEndpoint, port);
            this.generateSoap12Binding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateHttpPort(OMFactory fac, OMElement definition, OMElement service) throws Exception {
        for (AxisEndpoint axisEndpoint : this.axisService.getEndpoints().values()) {
            AxisBinding axisBinding;
            String type;
            if (!axisEndpoint.isActive() || !"http://www.w3.org/ns/wsdl/http".equals(type = (axisBinding = axisEndpoint.getBinding()).getType())) continue;
            OMElement port = fac.createOMElement("port", this.wsdl);
            service.addChild((OMNode)port);
            port.addAttribute("name", axisEndpoint.getName(), null);
            QName qname = axisBinding.getName();
            port.addAttribute("binding", this.tns.getPrefix() + ":" + qname.getLocalPart(), null);
            OMElement extElement = fac.createOMElement("address", this.http);
            String endpointURL = this.getEndpointURL(axisEndpoint);
            extElement.addAttribute("location", endpointURL == null ? "" : endpointURL, null);
            port.addChild((OMNode)extElement);
            this.addPolicyAsExtElement(axisEndpoint, port);
            this.generateHttpBinding(fac, definition, axisEndpoint.getBinding());
        }
    }

    private void generateSoap11Binding(OMFactory fac, OMElement defintions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, defintions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = defintions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore((OMNode)binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        String portTypeName = this.serviceName + "PortType";
        Parameter param = this.axisService.getParameter("portTypeName");
        if (param != null) {
            portTypeName = (String)param.getValue();
        }
        binding.addAttribute("type", this.tns.getPrefix() + ":" + portTypeName, null);
        this.addPolicyAsExtElement(axisBinding, binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap);
        if (AddressingHelper.getAddressingRequirementParemeterValue(this.axisService).equals("optional")) {
            WSDLSerializationUtil.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "false", this.wsaw);
        } else if (AddressingHelper.getAddressingRequirementParemeterValue(this.axisService).equals("required")) {
            WSDLSerializationUtil.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", this.wsaw);
        }
        Iterator<AxisBindingOperation> axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList<AxisBindingMessage> faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addPolicyAsExtElement(axisBindingOperation, operation);
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild("In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addPolicyAsExtElement(axisBindingInMessage, input);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild("Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addPolicyAsExtElement(axisBindingOutMessage, output);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisBindingOperation.getFaults()) == null) continue;
            for (AxisBindingMessage faultyMessage1 : faultyMessages) {
                AxisBindingMessage bindingFaultyMessage = faultyMessage1;
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addPolicyAsExtElement(bindingFaultyMessage, fault);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap);
            }
        }
    }

    private void generateSoap12Binding(OMFactory fac, OMElement definitions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, definitions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = definitions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore((OMNode)binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        String portTypeName = this.serviceName + "PortType";
        Parameter param = this.axisService.getParameter("portTypeName");
        if (param != null) {
            portTypeName = (String)param.getValue();
        }
        binding.addAttribute("type", this.tns.getPrefix() + ":" + portTypeName, null);
        this.addPolicyAsExtElement(axisBinding, binding);
        this.addExtensionElement(fac, binding, "binding", "transport", "http://schemas.xmlsoap.org/soap/http", "style", this.style, this.soap12);
        if (AddressingHelper.getAddressingRequirementParemeterValue(this.axisService).equals("optional")) {
            WSDLSerializationUtil.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "false", this.wsaw);
        } else if (AddressingHelper.getAddressingRequirementParemeterValue(this.axisService).equals("required")) {
            WSDLSerializationUtil.addExtensionElement(fac, binding, "UsingAddressing", "wsdl:required", "true", this.wsaw);
        }
        Iterator<AxisBindingOperation> axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            ArrayList<AxisBindingMessage> faultyMessages;
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            String soapAction = axisOperation.getSoapAction();
            if (soapAction == null) {
                soapAction = "";
            }
            this.addPolicyAsExtElement(axisBindingOperation, operation);
            this.addExtensionElement(fac, operation, "operation", "soapAction", soapAction, "style", this.style, this.soap12);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild("In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                this.addPolicyAsExtElement(axisBindingInMessage, input);
                this.addExtensionElement(fac, input, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                operation.addChild((OMNode)input);
                this.writeSoapHeaders(inaxisMessage, fac, input, this.soap12);
            }
            if (("http://www.w3.org/ns/wsdl/out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild("Out")) != null && (outAxisMessage = axisBindingOutMessage.getAxisMessage()) != null) {
                OMElement output = fac.createOMElement("output", this.wsdl);
                this.addPolicyAsExtElement(axisBindingOutMessage, output);
                this.addExtensionElement(fac, output, "body", "use", this.use, null, this.targetNamespace, this.soap12);
                operation.addChild((OMNode)output);
                this.writeSoapHeaders(outAxisMessage, fac, output, this.soap12);
            }
            if ((faultyMessages = axisBindingOperation.getFaults()) == null) continue;
            for (AxisBindingMessage faultyMessage1 : faultyMessages) {
                AxisBindingMessage bindingFaultyMessage = faultyMessage1;
                if (bindingFaultyMessage == null) continue;
                AxisMessage faultyMessage = bindingFaultyMessage.getAxisMessage();
                OMElement fault = fac.createOMElement("fault", this.wsdl);
                this.addPolicyAsExtElement(bindingFaultyMessage, fault);
                this.addExtensionElement(fac, fault, "fault", "use", this.use, "name", faultyMessage.getName(), this.soap12);
                fault.addAttribute("name", faultyMessage.getName(), null);
                operation.addChild((OMNode)fault);
                this.writeSoapHeaders(faultyMessage, fac, fault, this.soap12);
            }
        }
    }

    private void generateHttpBinding(OMFactory fac, OMElement definitions, AxisBinding axisBinding) throws Exception {
        if (this.isAlreadyAdded(axisBinding, definitions)) {
            return;
        }
        OMElement binding = fac.createOMElement("binding", this.wsdl);
        OMElement serviceElement = definitions.getFirstChildWithName(new QName(this.wsdl.getNamespaceURI(), "service"));
        serviceElement.insertSiblingBefore((OMNode)binding);
        QName qname = axisBinding.getName();
        binding.addAttribute("name", qname.getLocalPart(), null);
        String portTypeName = this.serviceName + "PortType";
        Parameter param = this.axisService.getParameter("portTypeName");
        if (param != null) {
            portTypeName = (String)param.getValue();
        }
        binding.addAttribute("type", this.tns.getPrefix() + ":" + portTypeName, null);
        OMElement httpBinding = fac.createOMElement("binding", this.http);
        binding.addChild((OMNode)httpBinding);
        httpBinding.addAttribute("verb", "POST", null);
        Iterator<AxisBindingOperation> axisBindingOperations = axisBinding.getChildren();
        while (axisBindingOperations.hasNext()) {
            AxisMessage outAxisMessage;
            AxisBindingMessage axisBindingOutMessage;
            AxisMessage inaxisMessage;
            AxisBindingMessage axisBindingInMessage;
            AxisBindingOperation axisBindingOperation = axisBindingOperations.next();
            AxisOperation axisOperation = axisBindingOperation.getAxisOperation();
            if (axisOperation.isControlOperation() || axisOperation.getName() == null) continue;
            String opeartionName = axisOperation.getName().getLocalPart();
            OMElement operation = fac.createOMElement("operation", this.wsdl);
            binding.addChild((OMNode)operation);
            OMElement httpOperation = fac.createOMElement("operation", this.http);
            operation.addChild((OMNode)httpOperation);
            String location = (String)axisBindingOperation.getProperty("whttp:location");
            location = location.replace('{', '(');
            location = location.replace('}', ')');
            httpOperation.addAttribute("location", location, null);
            String MEP = axisOperation.getMessageExchangePattern();
            if (("http://www.w3.org/ns/wsdl/in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) || "http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) || "http://www.w3.org/ns/wsdl/robust-in-only".equals(MEP) || "http://www.w3.org/ns/wsdl/in-out".equals(MEP)) && (axisBindingInMessage = (AxisBindingMessage)axisBindingOperation.getChild("In")) != null && (inaxisMessage = axisBindingInMessage.getAxisMessage()) != null) {
                operation.addAttribute("name", opeartionName, null);
                OMElement input = fac.createOMElement("input", this.wsdl);
                OMElement inputelement = fac.createOMElement("content", this.mime);
                input.addChild((OMNode)inputelement);
                String inputType = (String)axisBindingOperation.getProperty("whttp:inputSerialization");
                inputelement.addAttribute("type", inputType != null ? inputType : "text/xml", null);
                inputelement.addAttribute("part", inaxisMessage.getPartName(), null);
                operation.addChild((OMNode)input);
            }
            if (!"http://www.w3.org/ns/wsdl/out-only".equals(MEP) && !"http://www.w3.org/ns/wsdl/out-opt-in".equals(MEP) && !"http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP) && !"http://www.w3.org/ns/wsdl/robust-out-only".equals(MEP) && !"http://www.w3.org/ns/wsdl/in-out".equals(MEP) || (axisBindingOutMessage = (AxisBindingMessage)axisBindingOperation.getChild("Out")) == null || (outAxisMessage = axisBindingOutMessage.getAxisMessage()) == null) continue;
            OMElement output = fac.createOMElement("output", this.wsdl);
            OMElement outElement = fac.createOMElement("content", this.mime);
            outElement.addChild((OMNode)outElement);
            String outputType = (String)axisBindingOperation.getProperty("whttp:outputSerialization");
            outElement.addAttribute("type", outputType != null ? outputType : "text/xml", null);
            outElement.addAttribute("part", outAxisMessage.getPartName(), null);
            output.addChild((OMNode)outElement);
            operation.addChild((OMNode)output);
        }
    }

    private void addPolicyAsExtElement(AxisDescription axisDescription, OMElement wsdlElement) throws Exception {
        PolicySubject policySubject = axisDescription.getPolicySubject();
        Collection<PolicyComponent> attachPolicyComponents = policySubject.getAttachedPolicyComponents();
        for (PolicyComponent policyElement : attachPolicyComponents) {
            PolicyLocator locator;
            Policy p;
            if (policyElement instanceof Policy) {
                PolicyReference policyReference = PolicyUtil.createPolicyReference((Policy)policyElement);
                OMElement policyRefElement = PolicyUtil.getPolicyComponentAsOMElement((PolicyComponent)policyReference, this.serializer);
                OMElement firstChildElem = wsdlElement.getFirstElement();
                if (firstChildElem == null) {
                    wsdlElement.addChild((OMNode)policyRefElement);
                } else {
                    firstChildElem.insertSiblingBefore((OMNode)policyRefElement);
                }
                String key = policyReference.getURI();
                if (key.startsWith("#")) {
                    key = key.substring(key.indexOf("#") + 1);
                }
                this.addPolicyToDefinitionElement(key, (Policy)policyElement);
                continue;
            }
            if (!(policyElement instanceof PolicyReference)) continue;
            OMElement child = PolicyUtil.getPolicyComponentAsOMElement(policyElement, this.serializer);
            OMElement firstChildElem = wsdlElement.getFirstElement();
            if (firstChildElem == null) {
                wsdlElement.addChild((OMNode)child);
            } else {
                firstChildElem.insertSiblingBefore((OMNode)child);
            }
            String key = ((PolicyReference)policyElement).getURI();
            if (key.startsWith("#")) {
                key = key.substring(key.indexOf("#") + 1);
            }
            if ((p = (locator = new PolicyLocator(this.axisService)).lookup(key)) == null) continue;
            this.addPolicyToDefinitionElement(key, p);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addPolicyAsExtAttribute(AxisDescription axisDescription, OMElement element, OMFactory factory) throws Exception {
        String uri;
        PolicySubject policySubject = axisDescription.getPolicySubject();
        ArrayList<Object> policyURIs = new ArrayList<Object>();
        for (PolicyComponent policyComponent : policySubject.getAttachedPolicyComponents()) {
            void var8_16;
            if (policyComponent instanceof Policy) {
                void var8_13;
                Policy p = (Policy)policyComponent;
                if (p.getId() != null) {
                    String string = "#" + p.getId();
                } else if (p.getName() != null) {
                    String string = p.getName();
                } else {
                    throw new RuntimeException("Can't add the Policy as an extensibility attribute since it doesn't have a id or a name attribute");
                }
                policyURIs.add(var8_13);
                this.addPolicyToDefinitionElement((String)var8_13, p);
                continue;
            }
            uri = ((PolicyReference)policyComponent).getURI();
            PolicyLocator locator = new PolicyLocator(this.axisService);
            if (uri.startsWith("#")) {
                String string = uri.substring(uri.indexOf(35) + 1);
            } else {
                String string = uri;
            }
            Policy p = locator.lookup((String)var8_16);
            if (p == null) {
                throw new RuntimeException("Cannot resolve " + uri + " to a Policy");
            }
            policyURIs.add(uri);
            this.addPolicyToDefinitionElement((String)var8_16, p);
        }
        if (!policyURIs.isEmpty()) {
            String value = null;
            for (Object e : policyURIs) {
                uri = (String)e;
                value = value == null ? uri : value + " " + uri;
            }
            OMNamespace oMNamespace = factory.createOMNamespace("http://schemas.xmlsoap.org/ws/2004/09/policy", "wsp");
            OMAttribute oMAttribute = factory.createOMAttribute("PolicyURIs", oMNamespace, value);
            element.addAttribute(oMAttribute);
        }
    }

    private boolean isAlreadyAdded(AxisBinding axisBinding, OMElement definitionElement) {
        QName bindingName = axisBinding.getName();
        QName name = new QName("name");
        Iterator iterator = definitionElement.getChildrenWithName(new QName(this.wsdl.getNamespaceURI(), "binding"));
        while (iterator.hasNext()) {
            OMElement element = (OMElement)iterator.next();
            String value = element.getAttributeValue(name);
            if (!bindingName.getLocalPart().equals(value)) continue;
            return true;
        }
        return false;
    }

    private String getEndpointURL(AxisEndpoint axisEndpoint) {
        Parameter modifyAddressParam = this.axisService.getParameter("modifyUserWSDLPortAddress");
        String endpointURL = axisEndpoint.getEndpointURL();
        if (modifyAddressParam != null && !Boolean.parseBoolean((String)modifyAddressParam.getValue())) {
            return endpointURL;
        }
        String hostIP = Utils.getHostname(this.axisService.getAxisConfiguration());
        if (hostIP == null) {
            hostIP = WSDLSerializationUtil.extractHostIP(this.axisService.getEndpointURL());
        }
        if (hostIP != null) {
            return axisEndpoint.calculateEndpointURL(hostIP);
        }
        return endpointURL;
    }

    private void generateIdentityElement(OMFactory fac, OMElement epr, Parameter wsaIdParam) {
        OMElement identity = fac.createOMElement(AddressingConstants.QNAME_IDENTITY);
        OMElement keyInfo = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_KEY_INFO);
        OMElement x509Data = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_X509_DATA);
        OMElement x509cert = fac.createOMElement(AddressingConstants.QNAME_IDENTITY_X509_CERT);
        x509cert.setText((String)wsaIdParam.getValue());
        x509Data.addChild((OMNode)x509cert);
        keyInfo.addChild((OMNode)x509Data);
        identity.addChild((OMNode)keyInfo);
        epr.addChild((OMNode)identity);
    }

    private void generateEPRElement(OMFactory fac, OMElement port, String endpointURL) {
        Parameter parameter = this.axisService.getParameter("WSAddressingAndIdentity");
        if (parameter == null || parameter.getValue() == null) {
            return;
        }
        OMElement wsaEpr = fac.createOMElement(AddressingConstants.Final.WSA_ENDPOINT_REFERENCE);
        OMElement address = fac.createOMElement(AddressingConstants.Final.WSA_ADDRESS);
        address.setText(endpointURL == null ? "" : endpointURL);
        wsaEpr.addChild((OMNode)address);
        this.generateIdentityElement(fac, wsaEpr, parameter);
        port.addChild((OMNode)wsaEpr);
    }
}

