/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.util.DefaultEntityResolver;
import org.apache.axis2.util.Loader;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class XMLUtils {
    public static final String charEncoding = "ISO-8859-1";
    private static final String saxParserFactoryProperty = "javax.xml.parsers.SAXParserFactory";
    private static DocumentBuilderFactory dbf = XMLUtils.getDOMFactory();
    private static SAXParserFactory saxFactory;
    private static Stack saxParsers;
    private static String empty;
    private static ByteArrayInputStream bais;
    private static boolean tryReset;

    public static void initSAXFactory(String factoryClassName, boolean namespaceAware, boolean validating) {
        if (factoryClassName != null) {
            try {
                saxFactory = (SAXParserFactory)Loader.loadClass(factoryClassName).newInstance();
                if (System.getProperty(saxParserFactoryProperty) == null) {
                    System.setProperty(saxParserFactoryProperty, factoryClassName);
                }
            }
            catch (Exception e) {
                saxFactory = SAXParserFactory.newInstance();
            }
        } else {
            saxFactory = SAXParserFactory.newInstance();
        }
        saxFactory.setNamespaceAware(namespaceAware);
        saxFactory.setValidating(validating);
        saxParsers.clear();
    }

    private static DocumentBuilderFactory getDOMFactory() {
        DocumentBuilderFactory dbf;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
        }
        catch (Exception e) {
            dbf = null;
        }
        return dbf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void releaseSAXParser(SAXParser parser) {
        if (!tryReset) {
            return;
        }
        try {
            XMLReader xmlReader = parser.getXMLReader();
            if (null != xmlReader) {
                Class<XMLUtils> clazz = XMLUtils.class;
                synchronized (XMLUtils.class) {
                    saxParsers.push(parser);
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                    return;
                }
            }
            tryReset = false;
            return;
        }
        catch (SAXException e) {
            tryReset = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            return dbf.newDocumentBuilder().newDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document newDocument(InputSource inp) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder db;
        DocumentBuilderFactory documentBuilderFactory = dbf;
        synchronized (documentBuilderFactory) {
            try {
                db = dbf.newDocumentBuilder();
            }
            catch (Exception e) {
                dbf = XMLUtils.getDOMFactory();
                db = dbf.newDocumentBuilder();
            }
        }
        db.setEntityResolver(new DefaultEntityResolver());
        db.setErrorHandler(new ParserErrorHandler());
        return db.parse(inp);
    }

    public static Document newDocument(InputStream inp) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocument(new InputSource(inp));
    }

    public static Document newDocument(String uri) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtils.newDocument(uri, null, null);
    }

    public static Document newDocument(String uri, String username, String password) throws ParserConfigurationException, SAXException, IOException {
        InputSource ins = XMLUtils.getInputSourceFromURI(uri, username, password);
        Document doc = XMLUtils.newDocument(ins);
        if (ins.getByteStream() != null) {
            ins.getByteStream().close();
        } else if (ins.getCharacterStream() != null) {
            ins.getCharacterStream().close();
        }
        return doc;
    }

    public static String getPrefix(String uri, Node e) {
        while (e != null && e.getNodeType() == 1) {
            NamedNodeMap attrs = e.getAttributes();
            for (int n = 0; n < attrs.getLength(); ++n) {
                Attr a = (Attr)attrs.item(n);
                String name = a.getName();
                if (!name.startsWith("xmlns:") || !a.getNodeValue().equals(uri)) continue;
                return name.substring(6);
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static String getNamespace(String prefix, Node e) {
        while (e != null && e.getNodeType() == 1) {
            Attr attr = ((Element)e).getAttributeNodeNS("http://www.w3.org/2000/xmlns/", prefix);
            if (attr != null) {
                return attr.getValue();
            }
            e = e.getParentNode();
        }
        return null;
    }

    public static QName getQNameFromString(String str, Node e) {
        if (str == null || e == null) {
            return null;
        }
        int idx = str.indexOf(58);
        if (idx > -1) {
            String prefix = str.substring(0, idx);
            String ns = XMLUtils.getNamespace(prefix, e);
            if (ns == null) {
                return null;
            }
            return new QName(ns, str.substring(idx + 1));
        }
        return new QName("", str);
    }

    public static String getStringForQName(QName qname, Element e) {
        String uri = qname.getNamespaceURI();
        String prefix = XMLUtils.getPrefix(uri, e);
        if (prefix == null) {
            int i = 1;
            prefix = "ns" + i;
            while (XMLUtils.getNamespace(prefix, e) != null) {
                prefix = "ns" + ++i;
            }
            e.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, uri);
        }
        return prefix + ":" + qname.getLocalPart();
    }

    public static String getChildCharacterData(Element parentEl) {
        if (parentEl == null) {
            return null;
        }
        StringBuffer strBuf = new StringBuffer();
        for (Node tempNode = parentEl.getFirstChild(); tempNode != null; tempNode = tempNode.getNextSibling()) {
            switch (tempNode.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData charData = (CharacterData)tempNode;
                    strBuf.append(charData.getData());
                }
            }
        }
        return strBuf.toString();
    }

    public static InputSource getInputSourceFromURI(String uri) {
        return new InputSource(uri);
    }

    private static InputSource getInputSourceFromURI(String uri, String username, String password) throws IOException, ProtocolException, UnsupportedEncodingException {
        URL wsdlurl = null;
        try {
            wsdlurl = new URL(uri);
        }
        catch (MalformedURLException e) {
            return new InputSource(uri);
        }
        if (username == null && wsdlurl.getUserInfo() == null) {
            return new InputSource(uri);
        }
        if (!wsdlurl.getProtocol().startsWith("http")) {
            return new InputSource(uri);
        }
        URLConnection connection = wsdlurl.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            return new InputSource(uri);
        }
        HttpURLConnection uconn = (HttpURLConnection)connection;
        String userinfo = wsdlurl.getUserInfo();
        uconn.setRequestMethod("GET");
        uconn.setAllowUserInteraction(false);
        uconn.setDefaultUseCaches(false);
        uconn.setDoInput(true);
        uconn.setDoOutput(false);
        uconn.setInstanceFollowRedirects(true);
        uconn.setUseCaches(false);
        String auth = null;
        if (userinfo != null) {
            auth = userinfo;
        } else if (username != null) {
            String string = auth = password == null ? username : username + ":" + password;
        }
        if (auth != null) {
            uconn.setRequestProperty("Authorization", "Basic " + XMLUtils.base64encode(auth.getBytes(charEncoding)));
        }
        uconn.connect();
        return new InputSource(uconn.getInputStream());
    }

    public static String base64encode(byte[] bytes) {
        return Base64.encode((byte[])bytes);
    }

    public static InputSource getEmptyInputSource() {
        return new InputSource(bais);
    }

    public static Node findNode(Node node, QName name) {
        if (name.getNamespaceURI().equals(node.getNamespaceURI()) && name.getLocalPart().equals(node.getLocalName())) {
            return node;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node ret = XMLUtils.findNode(children.item(i), name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    public static OMElement toOM(Element element) throws Exception {
        return XMLUtils.toOM(element, true);
    }

    public static OMElement toOM(Element element, boolean buildAll) throws Exception {
        DOMSource source = new DOMSource(element);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
        ByteArrayInputStream is = new ByteArrayInputStream(baos.toByteArray());
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((InputStream)is);
        builder.setCache(true);
        OMElement omElement = builder.getDocumentElement();
        if (buildAll) {
            omElement.build();
            builder.close();
        }
        return omElement;
    }

    public static Element toDOM(OMElement element) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        element.serialize((OutputStream)baos);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        return factory.newDocumentBuilder().parse(bais).getDocumentElement();
    }

    public static OMNode toOM(InputStream inputStream) throws XMLStreamException {
        return XMLUtils.toOM(inputStream, true);
    }

    public static OMNode toOM(InputStream inputStream, boolean buildAll) throws XMLStreamException {
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((InputStream)inputStream);
        builder.setCache(true);
        OMElement omNode = builder.getDocumentElement();
        if (buildAll) {
            omNode.build();
            builder.close();
        }
        return omNode;
    }

    public static OMNode toOM(Reader reader) throws XMLStreamException {
        return XMLUtils.toOM(reader, true);
    }

    public static OMNode toOM(Reader reader, boolean buildAll) throws XMLStreamException {
        OMXMLParserWrapper builder = OMXMLBuilderFactory.createOMBuilder((Reader)reader);
        builder.setCache(true);
        OMElement omNode = builder.getDocumentElement();
        if (buildAll) {
            omNode.build();
            builder.close();
        }
        return omNode;
    }

    static {
        saxParsers = new Stack();
        empty = "";
        bais = new ByteArrayInputStream(empty.getBytes());
        XMLUtils.initSAXFactory(null, true, false);
        tryReset = true;
    }

    public static class ParserErrorHandler
    implements ErrorHandler {
        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            return "URI=" + systemId + " Line=" + spe.getLineNumber() + ": " + spe.getMessage();
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

