/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.builder.DisallowDoctypeDeclStreamReaderWrapper;
import org.apache.axis2.context.MessageContext;

public class SecureApplicationXMLBuilder
implements Builder {
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    public SecureApplicationXMLBuilder() {
        this.inputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        this.inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
    }

    @Override
    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext messageContext) throws AxisFault {
        SOAPFactory soapFactory = OMAbstractFactory.getSOAP11Factory();
        SOAPEnvelope soapEnvelope = soapFactory.getDefaultEnvelope();
        if (inputStream != null) {
            try {
                PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream);
                int b = pushbackInputStream.read();
                if (b > 0) {
                    pushbackInputStream.unread(b);
                    DisallowDoctypeDeclStreamReaderWrapper xmlreader = new DisallowDoctypeDeclStreamReaderWrapper(this.inputFactory.createXMLStreamReader(pushbackInputStream, (String)messageContext.getProperty("CHARACTER_SET_ENCODING")));
                    StAXOMBuilder builder = new StAXOMBuilder((XMLStreamReader)xmlreader);
                    OMNodeEx documentElement = (OMNodeEx)builder.getDocumentElement();
                    documentElement.setParent(null);
                    SOAPBody body = soapEnvelope.getBody();
                    body.addChild((OMNode)documentElement);
                }
            }
            catch (XMLStreamException e) {
                throw AxisFault.makeFault(e);
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
        }
        return soapEnvelope;
    }
}

