/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.llom.OMTextImpl;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.builder.DiskFileDataSource;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.axis2.transport.http.util.ComplexPart;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.lang3.StringUtils;

public class MultipartFormDataFormatter
implements MessageFormatter {
    private static final QName FILE_FIELD_QNAME = new QName("http://org.apache.axis2/xsd/form-data", "file");
    private static final QName FILENAME_ATTRIBUTE_QNAME = new QName("filename");
    private static final QName FILE_FIELD_NAME_ATTRIBUTE_QNAME = new QName("name");
    private static final QName CONTENT_TYPE_ATTRIBUTE_QNAME = new QName("content-type");
    private static final QName CHARSET_ATTRIBUTE_QNAME = new QName("charset");
    private static final String DEFAULT_FILE_NAME = "esb-generated-file";
    private static final String DEFAULT_FILE_FIELD_NAME = "file";
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private static final String DEFAULT_CHARSET = "ISO-8859-1";
    private static final String STRING_PART_DEFAULT_CHARSET = "US-ASCII";
    private static final String DECODE_MULTIPART_DATA_PARAM = "DECODE_MULTIPART_DATA";

    @Override
    public byte[] getBytes(MessageContext messageContext, OMOutputFormat format) throws AxisFault {
        OMElement omElement = messageContext.getEnvelope().getBody().getFirstElement();
        Part[] parts = this.createMultipatFormDataRequest(messageContext, omElement);
        if (parts.length > 0) {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            try {
                Part.sendParts((OutputStream)bytesOut, (Part[])parts, (byte[])format.getMimeBoundary().getBytes());
            }
            catch (IOException e) {
                throw AxisFault.makeFault(e);
            }
            return bytesOut.toByteArray();
        }
        return new byte[0];
    }

    @Override
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        try {
            byte[] b = this.getBytes(messageContext, format);
            if (b != null && b.length > 0) {
                outputStream.write(b);
            } else {
                outputStream.flush();
            }
        }
        catch (IOException e) {
            throw new AxisFault("An error occured while writing the request");
        }
    }

    @Override
    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String contentType = "multipart/form-data";
        String encoding = format.getCharSetEncoding();
        String setEncoding = (String)messageContext.getProperty("setCharacterEncoding");
        if (encoding != null && !"false".equalsIgnoreCase(setEncoding)) {
            contentType = contentType + "; charset=" + encoding;
        }
        contentType = contentType + "; boundary=" + format.getMimeBoundary();
        return contentType;
    }

    @Override
    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, false);
        return targetURL;
    }

    @Override
    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }

    private Part[] createMultipatFormDataRequest(MessageContext messageContext, OMElement dataOut) {
        ArrayList<ComplexPart> parts = new ArrayList<ComplexPart>();
        if (dataOut != null) {
            Iterator iter1 = dataOut.getChildElements();
            OMFactory omFactory = OMAbstractFactory.getOMFactory();
            while (iter1.hasNext()) {
                String charset;
                String contentType;
                String filename;
                String fieldName;
                ComplexPart part = null;
                OMElement ele = (OMElement)iter1.next();
                Iterator iter2 = ele.getChildElements();
                if (iter2.hasNext()) {
                    OMElement omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
                    omElement.addChild((OMNode)this.processComplexType(omElement, ele.getChildElements(), omFactory, false));
                    part = new ComplexPart(ele.getQName().getLocalPart(), omElement.toString());
                } else if (FILE_FIELD_QNAME.equals(ele.getQName())) {
                    fieldName = this.getAttributeValue(ele.getAttribute(FILE_FIELD_NAME_ATTRIBUTE_QNAME), DEFAULT_FILE_FIELD_NAME);
                    filename = this.getAttributeValue(ele.getAttribute(FILENAME_ATTRIBUTE_QNAME), DEFAULT_FILE_NAME);
                    contentType = this.getAttributeValue(ele.getAttribute(CONTENT_TYPE_ATTRIBUTE_QNAME), DEFAULT_CONTENT_TYPE);
                    charset = this.getAttributeValue(ele.getAttribute(CHARSET_ATTRIBUTE_QNAME), DEFAULT_CHARSET);
                    part = new FilePart(fieldName, (PartSource)new ByteArrayPartSource(filename, Base64.decodeBase64((byte[])ele.getText().getBytes())), contentType, charset);
                } else if (ele.getAttribute(FILENAME_ATTRIBUTE_QNAME) != null) {
                    fieldName = this.getAttributeValue(ele.getAttribute(FILE_FIELD_NAME_ATTRIBUTE_QNAME), ele.getLocalName());
                    filename = this.getAttributeValue(ele.getAttribute(FILENAME_ATTRIBUTE_QNAME), DEFAULT_FILE_NAME);
                    contentType = this.getAttributeValue(ele.getAttribute(CONTENT_TYPE_ATTRIBUTE_QNAME), DEFAULT_CONTENT_TYPE);
                    charset = BuilderUtil.extractCharSetValue(contentType);
                    if (StringUtils.isEmpty((CharSequence)charset)) {
                        charset = this.getAttributeValue(ele.getAttribute(CHARSET_ATTRIBUTE_QNAME), DEFAULT_CHARSET);
                    } else {
                        contentType = contentType.replace(HTTPConstants.CHAR_SET_ENCODING + "=" + charset, "");
                        contentType = contentType.replace(";", "");
                    }
                    Boolean decodeMultipartData = (Boolean)messageContext.getProperty(DECODE_MULTIPART_DATA_PARAM);
                    part = decodeMultipartData != null && decodeMultipartData.booleanValue() ? new FilePart(fieldName, (PartSource)new ByteArrayPartSource(filename, Base64.decodeBase64((byte[])ele.getText().getBytes())), contentType, charset) : new FilePart(fieldName, (PartSource)new ByteArrayPartSource(filename, ele.getText().getBytes()), contentType, charset);
                } else {
                    OMTextImpl firstChild = (OMTextImpl)ele.getFirstOMChild();
                    if (firstChild != null && firstChild.isBinary() && firstChild.getDataHandler() != null && ((DataHandler)firstChild.getDataHandler()).getDataSource() instanceof DiskFileDataSource) {
                        String fileName = null;
                        contentType = null;
                        DiskFileDataSource fileDataSource = (DiskFileDataSource)((DataHandler)firstChild.getDataHandler()).getDataSource();
                        fileName = fileDataSource.getName();
                        contentType = fileDataSource.getContentType();
                        part = new FilePart(ele.getQName().getLocalPart(), (PartSource)new ByteArrayPartSource(fileName, ele.getText().getBytes()), contentType, null);
                    }
                    if (part == null) {
                        String charset2 = this.getCharSet(messageContext, ele);
                        if (ele.getQName().getPrefix() != null && !ele.getQName().getPrefix().isEmpty()) {
                            part = new StringPart(ele.getQName().getPrefix() + ":" + ele.getQName().getLocalPart(), ele.getText(), charset2);
                        } else {
                            part = new StringPart(ele.getQName().getLocalPart(), ele.getText(), charset2);
                            if (ele.getAttributeValue(CONTENT_TYPE_ATTRIBUTE_QNAME) != null) {
                                ((StringPart)part).setContentType(ele.getAttributeValue(CONTENT_TYPE_ATTRIBUTE_QNAME));
                            }
                        }
                    }
                }
                parts.add(part);
            }
        }
        Part[] partsArray = new Part[parts.size()];
        return parts.toArray(partsArray);
    }

    private String getCharSet(MessageContext msgCtx, OMElement element) {
        OMAttribute charsetAttribute = element.getAttribute(CHARSET_ATTRIBUTE_QNAME);
        if (charsetAttribute != null) {
            return charsetAttribute.getAttributeValue();
        }
        Object charsetProperty = msgCtx.getProperty("CHARACTER_SET_ENCODING");
        if (charsetProperty != null) {
            return (String)charsetProperty;
        }
        return STRING_PART_DEFAULT_CHARSET;
    }

    private String getAttributeValue(OMAttribute filenameAttribute, String defaultValue) {
        String filename = defaultValue;
        if (filenameAttribute != null) {
            filename = filenameAttribute.getAttributeValue();
        }
        return filename;
    }

    private OMElement processComplexType(OMElement parent, Iterator iter, OMFactory omFactory, boolean returnParent) {
        OMElement omElement = null;
        while (iter.hasNext()) {
            OMElement ele = (OMElement)iter.next();
            omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
            Iterator iter2 = ele.getChildElements();
            if (iter2.hasNext()) {
                parent.addChild((OMNode)this.processComplexType(omElement, ele.getChildElements(), omFactory, true));
                continue;
            }
            omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
            omElement.setText(ele.getText());
            parent.addChild((OMNode)omElement);
        }
        if (returnParent) {
            return parent;
        }
        return omElement;
    }
}

