/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.description.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jws.HandlerChain;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingType;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebFault;
import javax.xml.ws.WebServiceClient;
import javax.xml.ws.WebServiceProvider;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.description.builder.BindingTypeAnnot;
import org.apache.axis2.jaxws.description.builder.CustomAnnotationInstance;
import org.apache.axis2.jaxws.description.builder.CustomAnnotationProcessor;
import org.apache.axis2.jaxws.description.builder.DescriptionBuilderUtils;
import org.apache.axis2.jaxws.description.builder.FieldDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.HandlerChainAnnot;
import org.apache.axis2.jaxws.description.builder.MethodDescriptionComposite;
import org.apache.axis2.jaxws.description.builder.PortComposite;
import org.apache.axis2.jaxws.description.builder.ServiceModeAnnot;
import org.apache.axis2.jaxws.description.builder.SoapBindingAnnot;
import org.apache.axis2.jaxws.description.builder.TMAnnotationComposite;
import org.apache.axis2.jaxws.description.builder.TMFAnnotationComposite;
import org.apache.axis2.jaxws.description.builder.WebFaultAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceClientAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceProviderAnnot;
import org.apache.axis2.jaxws.description.builder.WebServiceRefAnnot;
import org.apache.axis2.jaxws.description.builder.WsdlGenerator;
import org.apache.axis2.jaxws.description.xml.handler.HandlerChainsType;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.WSDL4JWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DescriptionBuilderComposite
implements TMAnnotationComposite,
TMFAnnotationComposite {
    private static final Log log = LogFactory.getLog(DescriptionBuilderComposite.class);
    private Definition wsdlDefinition = null;
    private URL wsdlURL = null;
    private WSDL4JWrapper wsdlWrapper = null;
    private ConfigurationContext myConfigContext;
    private WebServiceAnnot webServiceAnnot;
    private WebServiceProviderAnnot webServiceProviderAnnot;
    private ServiceModeAnnot serviceModeAnnot;
    private WebServiceClientAnnot webServiceClientAnnot;
    private WebFaultAnnot webFaultAnnot;
    private HandlerChainAnnot handlerChainAnnot;
    private SoapBindingAnnot soapBindingAnnot;
    private List<WebServiceRefAnnot> webServiceRefAnnotList;
    private BindingTypeAnnot bindingTypeAnnot;
    private List<PortComposite> portCompositeList = new ArrayList<PortComposite>();
    private List<Annotation> features;
    private Map<QName, Definition> wsdlDefs = new HashMap<QName, Definition>();
    private Map<QName, URL> wsdlURLs = new HashMap<QName, URL>();
    private Set<QName> serviceQNames = new HashSet<QName>();
    private Map<QName, List<PortComposite>> sQNameToPC = new HashMap<QName, List<PortComposite>>();
    private String className;
    private String[] classModifiers;
    private String extendsClass;
    private List<String> interfacesList;
    private boolean isInterface = false;
    private QName preferredPort;
    private boolean isMTOMEnabled = false;
    private List<MethodDescriptionComposite> methodDescriptions;
    private List<FieldDescriptionComposite> fieldDescriptions;
    private List<CustomAnnotationInstance> genericAnnotationInstances;
    private Map<String, CustomAnnotationProcessor> genericAnnotationProcessors;
    private WsdlGenerator wsdlGenerator;
    private ClassLoader classLoader;
    private HandlerChainsType handlerChainsType = null;
    private boolean isServiceProvider = true;
    private Class theCorrespondingClass;
    private WeakHashMap<Object, DescriptionBuilderComposite> sparseCompositeMap = new WeakHashMap();
    private JAXWSCatalogManager catalogManager = null;
    private Map<String, Object> properties = null;

    public DescriptionBuilderComposite() {
        this(null);
    }

    public DescriptionBuilderComposite(ConfigurationContext configContext) {
        this.myConfigContext = configContext;
        this.methodDescriptions = new ArrayList<MethodDescriptionComposite>();
        this.fieldDescriptions = new ArrayList<FieldDescriptionComposite>();
        this.webServiceRefAnnotList = new ArrayList<WebServiceRefAnnot>();
        this.interfacesList = new ArrayList<String>();
        this.genericAnnotationInstances = new ArrayList<CustomAnnotationInstance>();
        this.genericAnnotationProcessors = new HashMap<String, CustomAnnotationProcessor>();
        this.properties = new HashMap<String, Object>();
    }

    private static Annotation getAnnotationFromClass(final Class cls, final Class annotation) {
        return (Annotation)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                Object a = cls.getAnnotation(annotation);
                return a;
            }
        });
    }

    public void setSparseComposite(Object key, DescriptionBuilderComposite sparseComposite) {
        if (key != null && sparseComposite != null) {
            this.sparseCompositeMap.put(key, sparseComposite);
        }
    }

    public DescriptionBuilderComposite getSparseComposite(Object key) {
        return this.sparseCompositeMap.get(key);
    }

    public void setPreferredPort(QName preferredPort) {
        this.preferredPort = preferredPort;
    }

    public QName getPreferredPort() {
        return this.preferredPort;
    }

    public QName getPreferredPort(Object key) {
        DescriptionBuilderComposite sparse;
        QName returnPreferredPort = null;
        returnPreferredPort = key != null ? ((sparse = this.getSparseComposite(key)) != null && !DescriptionBuilderUtils.isEmpty(sparse.getPreferredPort()) ? sparse.getPreferredPort() : this.getPreferredPort()) : this.getPreferredPort();
        return returnPreferredPort;
    }

    public void setIsMTOMEnabled(boolean isMTOMEnabled) {
        this.isMTOMEnabled = isMTOMEnabled;
    }

    public boolean isMTOMEnabled() {
        return this.isMTOMEnabled;
    }

    public boolean isMTOMEnabled(Object key) {
        DescriptionBuilderComposite sparseDBC;
        boolean returnIsMTOMEnabled = false;
        returnIsMTOMEnabled = key != null ? ((sparseDBC = this.getSparseComposite(key)) != null && sparseDBC.isMTOMEnabled() ? sparseDBC.isMTOMEnabled() : this.isMTOMEnabled()) : this.isMTOMEnabled();
        return returnIsMTOMEnabled;
    }

    public WebServiceAnnot getWebServiceAnnot() {
        this.webServiceAnnot = (WebServiceAnnot)((Object)this.getCompositeAnnotation((Annotation)((Object)this.webServiceAnnot), WebServiceAnnot.class, WebService.class));
        return this.webServiceAnnot;
    }

    public String[] getClassModifiers() {
        return this.classModifiers;
    }

    public String getClassName() {
        if (this.className != null) {
            return this.className;
        }
        if (this.theCorrespondingClass != null) {
            return this.theCorrespondingClass.getName();
        }
        return null;
    }

    public String getSuperClassName() {
        return this.extendsClass;
    }

    public List<String> getInterfacesList() {
        return this.interfacesList;
    }

    public HandlerChainAnnot getHandlerChainAnnot() {
        this.handlerChainAnnot = (HandlerChainAnnot)((Object)this.getCompositeAnnotation((Annotation)((Object)this.handlerChainAnnot), HandlerChainAnnot.class, HandlerChain.class));
        return this.handlerChainAnnot;
    }

    public ServiceModeAnnot getServiceModeAnnot() {
        this.serviceModeAnnot = (ServiceModeAnnot)((Object)this.getCompositeAnnotation((Annotation)((Object)this.serviceModeAnnot), ServiceModeAnnot.class, ServiceMode.class));
        return this.serviceModeAnnot;
    }

    public SoapBindingAnnot getSoapBindingAnnot() {
        this.soapBindingAnnot = (SoapBindingAnnot)((Object)this.getCompositeAnnotation((Annotation)((Object)this.soapBindingAnnot), SoapBindingAnnot.class, SOAPBinding.class));
        return this.soapBindingAnnot;
    }

    public WebFaultAnnot getWebFaultAnnot() {
        this.webFaultAnnot = (WebFaultAnnot)((Object)this.getCompositeAnnotation((Annotation)((Object)this.webFaultAnnot), WebFaultAnnot.class, WebFault.class));
        return this.webFaultAnnot;
    }

    public WebServiceClientAnnot getWebServiceClientAnnot() {
        this.webServiceClientAnnot = (WebServiceClientAnnot)((Object)this.getCompositeAnnotation((Annotation)((Object)this.webServiceClientAnnot), WebServiceClientAnnot.class, WebServiceClient.class));
        return this.webServiceClientAnnot;
    }

    public WebServiceClientAnnot getWebServiceClientAnnot(Object key) {
        WebServiceClientAnnot annot = this.getWebServiceClientAnnot();
        DescriptionBuilderComposite sparseComposite = this.getSparseComposite(key);
        WebServiceClientAnnot sparseAnnot = null;
        if (sparseComposite != null) {
            sparseAnnot = sparseComposite.getWebServiceClientAnnot();
        }
        return WebServiceClientAnnot.createFromAnnotation((Annotation)((Object)annot), (Annotation)((Object)sparseAnnot));
    }

    private Annotation getCompositeAnnotation(Annotation compositeAnnotation, Class compositeAnnotClass, Class javaAnnotationClass) {
        Annotation annotationFromClass;
        Annotation returnAnnotation = compositeAnnotation;
        if (returnAnnotation == null && this.theCorrespondingClass != null && (annotationFromClass = DescriptionBuilderComposite.getAnnotationFromClass(this.theCorrespondingClass, javaAnnotationClass)) != null) {
            try {
                Method createAnnot = compositeAnnotClass.getMethod("createFromAnnotation", Annotation.class);
                returnAnnotation = (Annotation)createAnnot.invoke(null, annotationFromClass);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unable to create composite annotation due to exception.  Composite Annotation: " + compositeAnnotation + "; Composite Annot class: " + compositeAnnotClass + "; Java Annot class: " + javaAnnotationClass), (Throwable)e);
                }
                String msg = Messages.getMessage("DescriptionBuilderErr1", compositeAnnotClass.toString(), e.toString());
                throw ExceptionFactory.makeWebServiceException(msg, e);
            }
        }
        return returnAnnotation;
    }

    public WebServiceProviderAnnot getWebServiceProviderAnnot() {
        this.webServiceProviderAnnot = (WebServiceProviderAnnot)((Object)this.getCompositeAnnotation((Annotation)((Object)this.webServiceProviderAnnot), WebServiceProviderAnnot.class, WebServiceProvider.class));
        return this.webServiceProviderAnnot;
    }

    public List<WebServiceRefAnnot> getAllWebServiceRefAnnots() {
        return this.webServiceRefAnnotList;
    }

    public WebServiceRefAnnot getWebServiceRefAnnot(String name) {
        WebServiceRefAnnot wsra2 = null;
        for (WebServiceRefAnnot wsra2 : this.webServiceRefAnnotList) {
            if (!wsra2.name().equals(name)) continue;
            return wsra2;
        }
        return wsra2;
    }

    public BindingTypeAnnot getBindingTypeAnnot() {
        return (BindingTypeAnnot)((Object)this.getCompositeAnnotation((Annotation)((Object)this.bindingTypeAnnot), BindingTypeAnnot.class, BindingType.class));
    }

    public List<Annotation> getWebServiceFeatures() {
        return this.features;
    }

    public void setWebServiceFeatures(List<Annotation> list) {
        this.features = list;
    }

    public void addWebServiceFeature(Annotation a) {
        if (this.features == null) {
            this.features = new ArrayList<Annotation>();
        }
        this.features.add(a);
    }

    public Definition getWsdlDefinition() {
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition;
        }
        this.wsdlDefinition = this.wsdlWrapper != null ? this.wsdlWrapper.getDefinition() : this.createWsdlDefinition(this.wsdlURL);
        return this.wsdlDefinition;
    }

    public URL getWsdlURL() {
        return this.wsdlURL;
    }

    public List<MethodDescriptionComposite> getMethodDescriptionComposite(String methodName) {
        ArrayList<MethodDescriptionComposite> matchingMethods = new ArrayList<MethodDescriptionComposite>();
        for (MethodDescriptionComposite composite : this.methodDescriptions) {
            if (composite.getMethodName() == null || !composite.getMethodName().equals(methodName)) continue;
            matchingMethods.add(composite);
        }
        return matchingMethods;
    }

    public MethodDescriptionComposite getMethodDescriptionComposite(String methodName, int occurence) {
        MethodDescriptionComposite returnMDC = null;
        List<MethodDescriptionComposite> matchingMethods = this.getMethodDescriptionComposite(methodName);
        if (matchingMethods != null && !matchingMethods.isEmpty() && occurence > 0 && occurence <= matchingMethods.size()) {
            returnMDC = matchingMethods.get(--occurence);
        }
        return returnMDC;
    }

    public List<MethodDescriptionComposite> getMethodDescriptionsList() {
        return this.methodDescriptions;
    }

    public FieldDescriptionComposite getFieldDescriptionComposite(String fieldName) {
        FieldDescriptionComposite composite2 = null;
        for (FieldDescriptionComposite composite2 : this.fieldDescriptions) {
            if (!composite2.getFieldName().equals(fieldName)) continue;
            return composite2;
        }
        return composite2;
    }

    public WsdlGenerator getCustomWsdlGenerator() {
        return this.wsdlGenerator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public void setWebServiceAnnot(WebServiceAnnot webServiceAnnot) {
        this.webServiceAnnot = webServiceAnnot;
    }

    public void setClassModifiers(String[] classModifiers) {
        this.classModifiers = classModifiers;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSuperClassName(String extendsClass) {
        this.extendsClass = extendsClass;
    }

    public void setInterfacesList(List<String> interfacesList) {
        this.interfacesList = interfacesList;
    }

    @Override
    public void setHandlerChainAnnot(HandlerChainAnnot handlerChainAnnot) {
        this.handlerChainAnnot = handlerChainAnnot;
    }

    public void setServiceModeAnnot(ServiceModeAnnot serviceModeAnnot) {
        this.serviceModeAnnot = serviceModeAnnot;
    }

    @Override
    public void setSoapBindingAnnot(SoapBindingAnnot soapBindingAnnot) {
        this.soapBindingAnnot = soapBindingAnnot;
    }

    public void setWebFaultAnnot(WebFaultAnnot webFaultAnnot) {
        this.webFaultAnnot = webFaultAnnot;
    }

    public void setWebServiceClientAnnot(WebServiceClientAnnot webServiceClientAnnot) {
        this.webServiceClientAnnot = webServiceClientAnnot;
    }

    public void setWebServiceProviderAnnot(WebServiceProviderAnnot webServiceProviderAnnot) {
        this.webServiceProviderAnnot = webServiceProviderAnnot;
    }

    public void addWebServiceRefAnnot(WebServiceRefAnnot webServiceRefAnnot) {
        this.webServiceRefAnnotList.add(webServiceRefAnnot);
    }

    @Override
    public void setWebServiceRefAnnot(WebServiceRefAnnot webServiceRefAnnot) {
        this.addWebServiceRefAnnot(webServiceRefAnnot);
    }

    public void addCustomAnnotationProcessor(CustomAnnotationProcessor processor) {
        this.genericAnnotationProcessors.put(processor.getAnnotationInstanceClassName(), processor);
    }

    public Map<String, CustomAnnotationProcessor> getCustomAnnotationProcessors() {
        return this.genericAnnotationProcessors;
    }

    public void addCustomAnnotationInstance(CustomAnnotationInstance annotation) {
        this.genericAnnotationInstances.add(annotation);
    }

    public List<CustomAnnotationInstance> getCustomAnnotationInstances() {
        return this.genericAnnotationInstances;
    }

    public void setWsdlDefinition(Definition wsdlDef) {
        block8: {
            Definition def = null;
            if (wsdlDef != null) {
                String wsdlDefinitionBaseURI;
                if (wsdlDef instanceof WSDL4JWrapper) {
                    this.wsdlWrapper = (WSDL4JWrapper)wsdlDef;
                    def = this.wsdlWrapper.getDefinition();
                } else {
                    try {
                        this.wsdlWrapper = this.myConfigContext != null ? new WSDL4JWrapper(wsdlDef, this.myConfigContext) : new WSDL4JWrapper(wsdlDef, true, 2);
                        def = this.wsdlWrapper.getDefinition();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (def != null && (wsdlDefinitionBaseURI = def.getDocumentBaseURI()) != null && this.wsdlURL == null) {
                    try {
                        this.wsdlURL = new URL(wsdlDefinitionBaseURI);
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug((Object)("DescriptionBuilderComposite:setWsdlDefinition(): Caught exception creating WSDL URL :" + wsdlDefinitionBaseURI + "; exception: " + e.toString()), (Throwable)e);
                    }
                }
            }
        }
    }

    public void setwsdlURL(URL wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    public void setBindingTypeAnnot(BindingTypeAnnot bindingTypeAnnot) {
        this.bindingTypeAnnot = bindingTypeAnnot;
    }

    public void setIsInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public void addMethodDescriptionComposite(MethodDescriptionComposite methodDescription) {
        this.methodDescriptions.add(methodDescription);
    }

    public void addFieldDescriptionComposite(FieldDescriptionComposite fieldDescription) {
        this.fieldDescriptions.add(fieldDescription);
    }

    public void setCustomWsdlGenerator(WsdlGenerator wsdlGenerator) {
        this.wsdlGenerator = wsdlGenerator;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public HandlerChainsType getHandlerChainsType() {
        return this.handlerChainsType;
    }

    public void setHandlerChainsType(HandlerChainsType handlerChainsType) {
        this.handlerChainsType = handlerChainsType;
    }

    public boolean isServiceProvider() {
        return this.isServiceProvider;
    }

    public void setIsServiceProvider(boolean value) {
        this.isServiceProvider = value;
    }

    public void setCorrespondingClass(Class theClass) {
        this.theCorrespondingClass = theClass;
    }

    public Class getCorrespondingClass() {
        return this.theCorrespondingClass;
    }

    public void setCatalogManager(JAXWSCatalogManager theCatalogManager) {
        this.catalogManager = theCatalogManager;
    }

    public JAXWSCatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setWsdlDefinition(QName serviceQName, Definition definition) {
        this.wsdlDefs.put(serviceQName, definition);
    }

    public Definition getWsdlDefinition(QName serviceQName) {
        return this.wsdlDefs.get(serviceQName);
    }

    public void setwsdlURL(QName serviceQName, URL url) {
        this.wsdlURLs.put(serviceQName, url);
    }

    public URL getWsdlURL(QName serviceQName) {
        return this.wsdlURLs.get(serviceQName);
    }

    public void setServiceQNames(Set<QName> serviceQNames) {
        this.serviceQNames = serviceQNames;
    }

    public Set<QName> getServiceQNames() {
        return this.serviceQNames;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String newLine = "\n";
        String sameLine = "; ";
        sb.append(super.toString());
        sb.append("\n");
        sb.append("ClassName: " + this.className);
        sb.append("; ");
        sb.append("SuperClass:" + this.extendsClass);
        sb.append("\n");
        sb.append("Class modifiers: ");
        if (this.classModifiers != null) {
            for (int i = 0; i < this.classModifiers.length; ++i) {
                sb.append(this.classModifiers[i]);
                sb.append("; ");
            }
        }
        sb.append("\n");
        sb.append("is Service Provider: " + this.isServiceProvider());
        sb.append("\n");
        sb.append("wsdlURL: " + this.getWsdlURL());
        sb.append("\n");
        sb.append("has wsdlDefinition?: ");
        if (this.wsdlDefinition != null) {
            sb.append("true");
        } else {
            sb.append("false");
        }
        sb.append("\n");
        sb.append("Interfaces: ");
        for (String inter : this.interfacesList) {
            sb.append(inter);
            sb.append("; ");
        }
        if (this.webServiceAnnot != null) {
            sb.append("\n");
            sb.append("WebService: ");
            sb.append(this.webServiceAnnot.toString());
        }
        if (this.webServiceProviderAnnot != null) {
            sb.append("\n");
            sb.append("WebServiceProvider: ");
            sb.append(this.webServiceProviderAnnot.toString());
        }
        if (this.bindingTypeAnnot != null) {
            sb.append("\n");
            sb.append("BindingType: ");
            sb.append(this.bindingTypeAnnot.toString());
        }
        if (this.webServiceClientAnnot != null) {
            sb.append("\n");
            sb.append("WebServiceClient: ");
            sb.append(this.webServiceClientAnnot.toString());
        }
        if (this.webFaultAnnot != null) {
            sb.append("\n");
            sb.append("WebFault: ");
            sb.append(this.webFaultAnnot.toString());
        }
        if (this.serviceModeAnnot != null) {
            sb.append("\n");
            sb.append("ServiceMode: ");
            sb.append(this.serviceModeAnnot.toString());
        }
        if (this.soapBindingAnnot != null) {
            sb.append("\n");
            sb.append("SOAPBinding: ");
            sb.append(this.soapBindingAnnot.toString());
        }
        if (this.handlerChainAnnot != null) {
            sb.append("\n");
            sb.append("HandlerChain: ");
            sb.append(this.handlerChainAnnot.toString());
        }
        if (this.webServiceRefAnnotList.size() > 0) {
            sb.append("\n");
            sb.append("Number of WebServiceRef:  " + this.webServiceRefAnnotList.size());
            for (WebServiceRefAnnot wsr : this.webServiceRefAnnotList) {
                sb.append(wsr.toString());
                sb.append("; ");
            }
        }
        sb.append("\n");
        sb.append("Number of Method Descriptions: " + this.methodDescriptions.size());
        Iterator<MethodDescriptionComposite> mdcIter = this.methodDescriptions.iterator();
        while (mdcIter.hasNext()) {
            sb.append("\n");
            MethodDescriptionComposite mdc = mdcIter.next();
            sb.append(mdc.toString());
        }
        sb.append("\n");
        sb.append("Number of Field Descriptions: " + this.fieldDescriptions.size());
        Iterator<FieldDescriptionComposite> fdcIter = this.fieldDescriptions.iterator();
        while (fdcIter.hasNext()) {
            sb.append("\n");
            FieldDescriptionComposite fdc = fdcIter.next();
            sb.append(fdc.toString());
        }
        if (this.features != null && !this.features.isEmpty()) {
            sb.append("\n");
            sb.append("\n");
            sb.append("WebService Feature Objects (as annotations):");
            sb.append("\n");
            for (Annotation annotation : this.features) {
                sb.append(annotation.toString());
                sb.append("\n");
            }
        }
        if (this.portCompositeList != null && !this.portCompositeList.isEmpty()) {
            sb.append("\n");
            sb.append("\n");
            sb.append("** PortComposite Objects**");
            sb.append("\n");
            for (PortComposite pc : this.portCompositeList) {
                sb.append("PortComposite");
                sb.append("\n");
                sb.append(pc.toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    private Definition createWsdlDefinition(URL _wsdlURL) {
        Definition wsdlDef;
        block5: {
            if (_wsdlURL == null) {
                return null;
            }
            wsdlDef = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("new WSDL4JWrapper(" + _wsdlURL.toString() + ",ConfigurationContext"));
                }
                this.wsdlWrapper = new WSDL4JWrapper(_wsdlURL, this.myConfigContext);
                if (this.wsdlWrapper != null) {
                    wsdlDef = this.wsdlWrapper.getDefinition();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)("DescriptionBuilderComposite:createWsdlDefinition(" + _wsdlURL.toString() + "): Caught exception trying to create WSDL Definition: " + e), (Throwable)e);
            }
        }
        return wsdlDef;
    }

    public ConfigurationContext getConfigurationContext() {
        return this.myConfigContext;
    }

    public void addPortComposite(PortComposite portDBC) {
        this.portCompositeList.add(portDBC);
    }

    public void addPortComposite(QName serviceQName, PortComposite portDBC) {
        List<PortComposite> pcList = this.sQNameToPC.get(serviceQName);
        if (pcList == null) {
            pcList = new LinkedList<PortComposite>();
            this.sQNameToPC.put(serviceQName, pcList);
        }
        pcList.add(portDBC);
    }

    public List<PortComposite> getPortComposites() {
        return this.portCompositeList;
    }

    public List<PortComposite> getPortComposites(QName serviceQName) {
        return this.sQNameToPC.get(serviceQName);
    }

    public static String getServiceRefName(DescriptionBuilderComposite sparseComposite) {
        String serviceRefName = null;
        if (sparseComposite != null) {
            serviceRefName = (String)sparseComposite.getProperties().get("org.apache.axis2.jaxws.description.builder.SERVICE_REF_NAME");
        }
        return serviceRefName;
    }

    public String getServiceRefName(Object serviceDelegateKey) {
        String serviceRefName = null;
        if (serviceDelegateKey != null) {
            serviceRefName = DescriptionBuilderComposite.getServiceRefName(this.getSparseComposite(serviceDelegateKey));
        }
        return serviceRefName;
    }
}

