/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.ExceptionFactory;
import org.apache.axis2.jaxws.catalog.JAXWSCatalogManager;
import org.apache.axis2.jaxws.catalog.impl.OASISCatalogManager;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.util.CatalogWSDLLocator;
import org.apache.axis2.jaxws.util.WSDLWrapper;
import org.apache.axis2.jaxws.wsdl.WSDLReaderConfigurator;
import org.apache.axis2.metadata.factory.ResourceFinderFactory;
import org.apache.axis2.metadata.registry.MetadataFactoryRegistry;
import org.apache.axis2.metadata.resource.ResourceFinder;
import org.apache.axis2.wsdl.util.WSDLDefinitionWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDL4JWrapper
implements WSDLWrapper {
    private static final Log log = LogFactory.getLog(WSDL4JWrapper.class);
    private WSDLDefinitionWrapper wsdlDefinition = null;
    private URL wsdlURL;
    private String wsdlExplicitURL;
    private ConfigurationContext configContext;
    private JAXWSCatalogManager catalogManager = null;
    private boolean limitMemory = true;
    private int memoryType = 2;

    public WSDL4JWrapper(URL wsdlURL) throws FileNotFoundException, UnknownHostException, ConnectException, IOException, WSDLException {
        this.commonPartsURLConstructor(wsdlURL, null);
    }

    public WSDL4JWrapper(URL wsdlURL, boolean limitMemory, int memoryType) throws FileNotFoundException, UnknownHostException, ConnectException, IOException, WSDLException {
        this.limitMemory = limitMemory;
        this.memoryType = memoryType;
        this.commonPartsURLConstructor(wsdlURL, null);
    }

    public WSDL4JWrapper(URL wsdlURL, JAXWSCatalogManager catalogManager) throws FileNotFoundException, UnknownHostException, ConnectException, IOException, WSDLException {
        this(wsdlURL, catalogManager, false, 0);
    }

    public WSDL4JWrapper(URL wsdlURL, JAXWSCatalogManager catalogManager, boolean limitMemory) throws FileNotFoundException, UnknownHostException, ConnectException, IOException, WSDLException {
        this.catalogManager = catalogManager;
        this.limitMemory = limitMemory;
        this.commonPartsURLConstructor(wsdlURL, null);
    }

    public WSDL4JWrapper(URL wsdlURL, JAXWSCatalogManager catalogManager, boolean limitMemory, int memoryType) throws FileNotFoundException, UnknownHostException, ConnectException, IOException, WSDLException {
        this.catalogManager = catalogManager;
        this.limitMemory = limitMemory;
        this.memoryType = memoryType;
        this.commonPartsURLConstructor(wsdlURL, null);
    }

    public WSDL4JWrapper(URL wsdlURL, ConfigurationContext configContext, JAXWSCatalogManager catalogManager) throws FileNotFoundException, UnknownHostException, ConnectException, IOException, WSDLException {
        this.catalogManager = catalogManager;
        this.commonPartsURLConstructor(wsdlURL, configContext);
    }

    public WSDL4JWrapper(URL wsdlURL, ConfigurationContext configContext) throws FileNotFoundException, UnknownHostException, ConnectException, IOException, WSDLException {
        this.commonPartsURLConstructor(wsdlURL, configContext);
    }

    private void commonPartsURLConstructor(URL wsdlURL, ConfigurationContext configContext) throws FileNotFoundException, UnknownHostException, ConnectException, IOException, WSDLException {
        this.configContext = configContext;
        if (log.isDebugEnabled()) {
            log.debug((Object)("WSDL4JWrapper(URL,ConfigurationContext) - Looking for wsdl file on client: " + (wsdlURL != null ? wsdlURL.getPath() : null)));
        }
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        this.wsdlURL = wsdlURL;
        try {
            URLConnection urlCon = this.getPrivilegedURLConnection(this.wsdlURL);
            InputStream is = null;
            try {
                is = this.getInputStream(urlCon);
            }
            catch (IOException e) {
                String filePath;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not open url connection. Trying to use classloader to get another URL.");
                }
                String string = filePath = wsdlURL != null ? wsdlURL.getPath() : null;
                if (filePath != null) {
                    URL url = this.getAbsoluteURL(classLoader, filePath);
                    if (url == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Could not locate URL for wsdl. Reporting error");
                        }
                        throw new WSDLException("WSDL4JWrapper : ", e.getMessage(), (Throwable)e);
                    }
                    urlCon = this.openConnection(url);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Found URL for WSDL from jar");
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Could not get URL from classloader. Reporting error due to no file path.");
                }
                throw new WSDLException("WSDL4JWrapper : ", e.getMessage(), (Throwable)e);
            }
            if (is != null) {
                is.close();
            }
            this.wsdlExplicitURL = urlCon.getURL().toString();
            this.getDefinition();
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (UnknownHostException ex) {
            throw ex;
        }
        catch (ConnectException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WSDLException("WSDL4JWrapper : ", ex.getMessage(), (Throwable)ex);
        }
    }

    private URLConnection getURLConnection(URL url) throws IOException {
        boolean isFileProtocol;
        String filePath = null;
        boolean bl = isFileProtocol = url != null && "file".equals(url.getProtocol());
        if (isFileProtocol) {
            boolean isRelativePath;
            filePath = url != null ? url.getPath() : null;
            boolean bl2 = isRelativePath = filePath != null && !new File(filePath).isAbsolute();
            if (isRelativePath) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"WSDL URL has a relative path");
                }
                if ((url = this.getAbsoluteURL(this.getThreadClassLoader(), filePath)) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"WSDL URL for relative path not found in ClassLoader");
                        log.warn((Object)"Unable to read WSDL from relative path, check the relative path");
                        log.info((Object)"Relative path example: file:/WEB-INF/wsdl/<wsdlfilename>");
                        log.warn((Object)"Using relative path as default wsdl URL to create wsdl Definition.");
                    }
                    url = this.wsdlURL;
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("WSDL URL found for relative path: " + filePath + " scheme: " + url.getProtocol()));
                }
            }
        }
        URLConnection connection = null;
        if (url != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Retrieving URLConnection from WSDL URL");
            }
            connection = this.openConnection(url);
        }
        return connection;
    }

    private URLConnection getPrivilegedURLConnection(final URL url) throws IOException {
        try {
            return (URLConnection)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return WSDL4JWrapper.this.getURLConnection(url);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private URLConnection openConnection(final URL url) throws IOException {
        try {
            return (URLConnection)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return url.openConnection();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private ClassLoader getThreadClassLoader() {
        return (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private URL getAbsoluteURL(final ClassLoader classLoader, final String filePath) {
        URL url = (URL)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return classLoader.getResource(filePath);
            }
        });
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Could not get URL from classloader. Looking in a jar.");
            }
            if (classLoader instanceof URLClassLoader) {
                final URLClassLoader urlLoader = (URLClassLoader)classLoader;
                url = (URL)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                    public Object run() {
                        return WSDL4JWrapper.this.getURLFromJAR(urlLoader, WSDL4JWrapper.this.wsdlURL);
                    }
                });
            } else {
                final URLClassLoader nestedLoader = (URLClassLoader)this.getNestedClassLoader(URLClassLoader.class, classLoader);
                if (nestedLoader != null) {
                    url = (URL)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                        public Object run() {
                            return WSDL4JWrapper.this.getURLFromJAR(nestedLoader, WSDL4JWrapper.this.wsdlURL);
                        }
                    });
                }
            }
        }
        return url;
    }

    private ClassLoader getNestedClassLoader(Class type, ClassLoader root) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Searching for nested URLClassLoader");
        }
        while (!(root instanceof URLClassLoader) && root != null) {
            final ClassLoader current = root;
            root = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return current.getParent();
                }
            });
            if (!log.isDebugEnabled() || root == null) continue;
            log.debug((Object)("Checking parent ClassLoader: " + root.getClass().getName()));
        }
        return root;
    }

    private URL getURLFromJAR(URLClassLoader urlLoader, URL relativeURL) {
        URL[] urlList = null;
        ResourceFinderFactory rff = (ResourceFinderFactory)MetadataFactoryRegistry.getFactory(ResourceFinderFactory.class);
        ResourceFinder cf = rff.getResourceFinder();
        if (log.isDebugEnabled()) {
            log.debug((Object)("ResourceFinderFactory: " + rff.getClass().getName()));
            log.debug((Object)("ResourceFinder: " + cf.getClass().getName()));
        }
        if ((urlList = cf.getURLs(urlLoader)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No URL's found in URL ClassLoader");
            }
            throw ExceptionFactory.makeWebServiceException(Messages.getMessage("WSDL4JWrapperErr1"));
        }
        for (URL url : urlList) {
            File f;
            if (!"file".equals(url.getProtocol()) || !this.isAFile(f = new File(url.getPath().replaceAll("%20", " ")))) continue;
            try {
                JarFile jf = (JarFile)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new JarFile(f);
                    }
                });
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    String relativePath;
                    JarEntry je = entries.nextElement();
                    String name = je.getName();
                    if (!name.endsWith(".wsdl") || !(relativePath = relativeURL.getPath()).endsWith(name)) continue;
                    String path = f.getAbsolutePath();
                    if (path != null && path.indexOf("/") == 0) {
                        path = path.substring(1, path.length());
                    }
                    URL absoluteUrl = new URL("jar:file:/" + path + "!/" + je.getName());
                    return absoluteUrl;
                }
            }
            catch (Exception e) {
                throw ExceptionFactory.makeWebServiceException(e);
            }
        }
        return null;
    }

    private boolean isAFile(final File f) {
        Boolean ret = (Boolean)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                return new Boolean(f.exists() && !f.isDirectory());
            }
        });
        return ret;
    }

    private static WSDLReader getWSDLReader() throws WSDLException {
        WSDLReader reader;
        try {
            reader = (WSDLReader)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws WSDLException {
                    WSDLFactory factory = WSDLFactory.newInstance();
                    return factory.newWSDLReader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (WSDLException)e.getException();
        }
        WSDLReaderConfigurator configurator = (WSDLReaderConfigurator)MetadataFactoryRegistry.getFactory(WSDLReaderConfigurator.class);
        if (configurator != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling configureReaderInstance with: " + configurator.getClass().getName()));
            }
            configurator.configureReaderInstance(reader);
        }
        return reader;
    }

    public WSDL4JWrapper(URL wsdlURL, Definition wsdlDefinition) throws WSDLException {
        this(wsdlURL, wsdlDefinition, null, null);
    }

    public WSDL4JWrapper(URL wsdlURL, Definition wsdlDefinition, ConfigurationContext configContext) throws WSDLException {
        this(wsdlURL, wsdlDefinition, configContext, null);
    }

    public WSDL4JWrapper(URL wsdlURL, Definition wsdlDefinition, boolean limitMemory, int memoryType) throws WSDLException {
        this(wsdlURL, wsdlDefinition, null, null, limitMemory, memoryType);
    }

    public WSDL4JWrapper(URL wsdlURL, Definition wsdlDefinition, JAXWSCatalogManager catalogManager, boolean limitMemory, int memoryType) throws WSDLException {
        this(wsdlURL, wsdlDefinition, null, catalogManager, limitMemory, memoryType);
    }

    public WSDL4JWrapper(URL wsdlURL, Definition wsdlDefinition, JAXWSCatalogManager catalogManager) throws WSDLException {
        this(wsdlURL, wsdlDefinition, null, catalogManager, false, 0);
    }

    public WSDL4JWrapper(URL wsdlURL, Definition wsdlDefinition, ConfigurationContext configContext, JAXWSCatalogManager catalogManager) throws WSDLException {
        this(wsdlURL, wsdlDefinition, configContext, catalogManager, false, 0);
    }

    private WSDL4JWrapper(URL wsdlURL, Definition wsdlDefinition, ConfigurationContext configContext, JAXWSCatalogManager catalogManager, boolean limitMemory, int memoryType) throws WSDLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"WSDL4JWrapper(...) entry");
        }
        this.configContext = configContext;
        this.catalogManager = catalogManager;
        this.wsdlURL = wsdlURL;
        this.limitMemory = limitMemory;
        this.memoryType = memoryType;
        this.wsdlDefinition = wsdlDefinition != null && !(wsdlDefinition instanceof WSDLDefinitionWrapper) ? (configContext != null && configContext.getAxisConfiguration() != null ? new WSDLDefinitionWrapper(wsdlDefinition, wsdlURL, configContext.getAxisConfiguration()) : new WSDLDefinitionWrapper(wsdlDefinition, wsdlURL, limitMemory, 2)) : (WSDLDefinitionWrapper)wsdlDefinition;
    }

    public WSDL4JWrapper(Definition wsdlDefinition) throws WSDLException {
        this(wsdlDefinition, false, 0);
    }

    public WSDL4JWrapper(Definition wsdlDefinition, boolean limitMemory, int memoryType) throws WSDLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"WSDL4JWrapper(Definition, boolean) entry");
        }
        this.limitMemory = limitMemory;
        this.memoryType = memoryType;
        this.wsdlDefinition = wsdlDefinition != null && !(wsdlDefinition instanceof WSDLDefinitionWrapper) ? new WSDLDefinitionWrapper(wsdlDefinition, null, limitMemory, memoryType) : (WSDLDefinitionWrapper)wsdlDefinition;
        if (this.wsdlDefinition != null) {
            String baseURI = wsdlDefinition.getDocumentBaseURI();
            try {
                this.wsdlURL = new URL(baseURI);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public WSDL4JWrapper(Definition wsdlDefinition, ConfigurationContext configContext) throws WSDLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"WSDL4JWrapper(Definition) entry");
        }
        this.wsdlDefinition = wsdlDefinition != null && !(wsdlDefinition instanceof WSDLDefinitionWrapper) ? new WSDLDefinitionWrapper(wsdlDefinition, configContext.getAxisConfiguration()) : (WSDLDefinitionWrapper)wsdlDefinition;
        if (this.wsdlDefinition != null) {
            String baseURI = wsdlDefinition.getDocumentBaseURI();
            try {
                this.wsdlURL = new URL(baseURI);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    @Override
    public Definition getDefinition() {
        Definition def;
        if (this.wsdlDefinition == null && (def = this.loadDefinition()) != null) {
            this.wsdlDefinition = this.configContext != null ? new WSDLDefinitionWrapper(def, this.configContext.getAxisConfiguration()) : new WSDLDefinitionWrapper(def, this.wsdlURL, this.limitMemory, this.memoryType);
        }
        return this.wsdlDefinition;
    }

    @Override
    public Definition getUnwrappedDefinition() {
        Object def = this.wsdlDefinition == null ? this.loadDefinition() : (this.wsdlDefinition instanceof WSDLDefinitionWrapper ? this.wsdlDefinition.getUnwrappedDefinition() : this.wsdlDefinition);
        return def;
    }

    public Definition loadDefinition() {
        Definition def = null;
        if (this.wsdlExplicitURL != null) {
            try {
                block17: {
                    URLConnection urlConn = this.getPrivilegedURLConnection(this.wsdlURL);
                    if (urlConn != null) {
                        try {
                            InputStream is = this.getInputStream(urlConn);
                            if (is != null) {
                                if (this.catalogManager == null) {
                                    this.catalogManager = new OASISCatalogManager();
                                }
                                final CatalogWSDLLocator locator = new CatalogWSDLLocator(this.wsdlExplicitURL, is, this.getThreadClassLoader(), this.catalogManager);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("Loading WSDL using ModuleWSDLLocator from base location: " + this.wsdlExplicitURL));
                                }
                                def = (Definition)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                                    public Object run() throws WSDLException {
                                        WSDLReader reader = WSDL4JWrapper.getWSDLReader();
                                        return reader.readWSDL((WSDLLocator)locator);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block17;
                            log.debug((Object)("Using ModuleWSDLLocator was not successful for loading WSDL due to the following error: " + e.toString() + ". The " + "WSDL will be read from the WSDL location: " + this.wsdlExplicitURL));
                        }
                    }
                }
                if (def == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Loading WSDL from location: " + this.wsdlExplicitURL));
                    }
                    def = (Definition)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws WSDLException {
                            WSDLReader reader = WSDL4JWrapper.getWSDLReader();
                            return reader.readWSDL(WSDL4JWrapper.this.wsdlExplicitURL);
                        }
                    });
                }
            }
            catch (PrivilegedActionException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Exception thrown from AccessController: " + e));
                }
                throw ExceptionFactory.makeWebServiceException(e.getException());
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("An error occurred while attempting to load the WSDL file at the following location: " + this.wsdlExplicitURL));
                }
                throw ExceptionFactory.makeWebServiceException(ioe);
            }
        }
        if (log.isDebugEnabled()) {
            if (def != null) {
                log.debug((Object)"loadDefinition() returning a NON-NULL definition");
            } else {
                log.debug((Object)"loadDefinition() returning a NULL definition");
            }
        }
        return def;
    }

    public Binding getFirstPortBinding(QName serviceQname) {
        Service service = this.getService(serviceQname);
        if (service == null) {
            return null;
        }
        Map map = this.getService(serviceQname).getPorts();
        if (map == null || map.isEmpty()) {
            return null;
        }
        Iterator i$ = map.values().iterator();
        if (i$.hasNext()) {
            Object listObject = i$.next();
            Port wsdlPort = (Port)listObject;
            return wsdlPort.getBinding();
        }
        return null;
    }

    @Override
    public String getOperationName(QName serviceQname, QName portQname) {
        Port port = this.getPort(serviceQname, portQname);
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        List operations = binding.getBindingOperations();
        Iterator i$ = operations.iterator();
        if (i$.hasNext()) {
            Object opObj = i$.next();
            BindingOperation operation = (BindingOperation)opObj;
            return operation.getName();
        }
        return null;
    }

    private Port getPort(QName serviceQname, QName eprQname) {
        Service service = this.getService(serviceQname);
        if (service == null) {
            return null;
        }
        return service.getPort(eprQname.getLocalPart());
    }

    @Override
    public ArrayList getPortBinding(QName serviceQname) {
        Map map = this.getService(serviceQname).getPorts();
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<Binding> portBindings = new ArrayList<Binding>();
        for (Object listObject : map.values()) {
            Port wsdlPort = (Port)listObject;
            Binding binding = wsdlPort.getBinding();
            if (binding == null) continue;
            portBindings.add(binding);
        }
        return portBindings;
    }

    @Override
    public String getPortBinding(QName serviceQname, QName portQname) {
        Port port = this.getPort(serviceQname, portQname);
        if (port == null) {
            return null;
        }
        Binding binding = port.getBinding();
        return binding.getQName().getLocalPart();
    }

    @Override
    public String[] getPorts(QName serviceQname) {
        String[] portNames = null;
        Service service = this.getService(serviceQname);
        if (service == null) {
            return null;
        }
        Map map = service.getPorts();
        if (map == null || map.isEmpty()) {
            return null;
        }
        portNames = new String[map.values().size()];
        Iterator iter = map.values().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Port wsdlPort = (Port)iter.next();
            if (wsdlPort != null) {
                portNames[i] = wsdlPort.getName();
            }
            ++i;
        }
        return portNames;
    }

    public Service getService(QName serviceQname) {
        if (serviceQname == null) {
            return null;
        }
        Definition def = this.getDefinition();
        if (def != null) {
            return def.getService(serviceQname);
        }
        return null;
    }

    @Override
    public String getSOAPAction(QName serviceQname) {
        Binding binding = this.getFirstPortBinding(serviceQname);
        if (binding == null) {
            return null;
        }
        List operations = binding.getBindingOperations();
        for (Object opObj : operations) {
            BindingOperation operation = (BindingOperation)opObj;
            List exElements = operation.getExtensibilityElements();
            for (Object elObj : exElements) {
                ExtensibilityElement exElement = (ExtensibilityElement)elObj;
                if (!this.isSoapOperation(exElement)) continue;
                SOAPOperation soapOperation = (SOAPOperation)exElement;
                return soapOperation.getSoapActionURI();
            }
        }
        return null;
    }

    @Override
    public String getSOAPAction(QName serviceQname, QName portQname) {
        Port port = this.getPort(serviceQname, portQname);
        if (port == null) {
            return null;
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        List operations = binding.getBindingOperations();
        for (Object opObj : operations) {
            BindingOperation operation = (BindingOperation)opObj;
            List exElements = operation.getExtensibilityElements();
            for (Object elObj : exElements) {
                ExtensibilityElement exElement = (ExtensibilityElement)elObj;
                if (!this.isSoapOperation(exElement)) continue;
                SOAPOperation soapOperation = (SOAPOperation)exElement;
                return soapOperation.getSoapActionURI();
            }
        }
        return null;
    }

    @Override
    public String getSOAPAction(QName serviceQname, QName portQname, QName operationQname) {
        Port port = this.getPort(serviceQname, portQname);
        if (port == null) {
            return null;
        }
        Binding binding = port.getBinding();
        if (binding == null) {
            return null;
        }
        List operations = binding.getBindingOperations();
        if (operations == null) {
            return null;
        }
        BindingOperation operation = null;
        for (Object opObj : operations) {
            operation = (BindingOperation)opObj;
        }
        List exElements = operation.getExtensibilityElements();
        for (Object elObj : exElements) {
            SOAPOperation soapOperation;
            ExtensibilityElement exElement = (ExtensibilityElement)elObj;
            if (!this.isSoapOperation(exElement) || !(soapOperation = (SOAPOperation)exElement).getElementType().equals(operationQname)) continue;
            return soapOperation.getSoapActionURI();
        }
        return null;
    }

    @Override
    public URL getWSDLLocation() {
        return this.wsdlURL;
    }

    private boolean isSoapOperation(ExtensibilityElement exElement) {
        return WSDLWrapper.SOAP_11_OPERATION.equals(exElement.getElementType());
    }

    @Override
    public String getTargetNamespace() {
        Definition def = this.getDefinition();
        if (def != null) {
            return def.getTargetNamespace();
        }
        return null;
    }

    private InputStream getInputStream(URLConnection urlCon) throws Exception {
        final URLConnection finalURLCon = urlCon;
        InputStream is = null;
        try {
            is = (InputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return finalURLCon.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return is;
    }

    private void debugMemoryParms(ConfigurationContext configContext) {
        if (configContext != null) {
            AxisConfiguration axisCfg = configContext.getAxisConfiguration();
            boolean reduceWSDLMemoryCache = false;
            int reduceWSDLMemoryType = 9;
            if (axisCfg != null) {
                String value;
                Parameter param = axisCfg.getParameter("reduceWSDLMemoryCache");
                reduceWSDLMemoryCache = param != null && ((String)param.getValue()).equalsIgnoreCase("true");
                param = axisCfg.getParameter("reduceWSDLMemoryType");
                if (param != null && (value = (String)param.getValue()) != null) {
                    Integer i = new Integer(value);
                    reduceWSDLMemoryType = i;
                }
                log.debug((Object)("reduceWSDLMemoryCache:" + reduceWSDLMemoryCache + ", reduceWSDLMemoryType:" + reduceWSDLMemoryType));
            } else {
                log.debug((Object)"AxisConfiguration is null");
            }
        } else {
            log.debug((Object)"ConfigContext is null");
        }
    }
}

