/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.engine.ListenerManager;
import org.apache.axis2.transport.http.HTTPWorkerFactory;
import org.apache.axis2.transport.http.server.DefaultConnectionListener;
import org.apache.axis2.transport.http.server.DefaultConnectionListenerFailureHandler;
import org.apache.axis2.transport.http.server.DefaultHttpConnectionManager;
import org.apache.axis2.transport.http.server.DefaultThreadFactory;
import org.apache.axis2.transport.http.server.HttpConnectionManager;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.axis2.transport.http.server.RequestSessionCookie;
import org.apache.axis2.transport.http.server.ResponseSessionCookie;
import org.apache.axis2.transport.http.server.WorkerFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class HttpFactory {
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_HOST_ADDRESS = "hostname";
    public static final String PARAMETER_ORIGIN_SERVER = "originServer";
    public static final String PARAMETER_REQUEST_SOCKET_TIMEOUT = "requestTimeout";
    public static final String PARAMETER_REQUEST_TCP_NO_DELAY = "requestTcpNoDelay";
    public static final String PARAMETER_REQUEST_CORE_THREAD_POOL_SIZE = "requestCoreThreadPoolSize";
    public static final String PARAMETER_REQUEST_MAX_THREAD_POOL_SIZE = "requestMaxThreadPoolSize";
    public static final String PARAMETER_THREAD_KEEP_ALIVE_TIME = "threadKeepAliveTime";
    public static final String PARAMETER_THREAD_KEEP_ALIVE_TIME_UNIT = "threadKeepAliveTimeUnit";
    private ConfigurationContext configurationContext;
    private TransportInDescription httpConfiguration;
    private int port;
    private String hostAddress;
    private String originServer;
    private int requestSocketTimeout;
    private boolean requestTcpNoDelay;
    private int requestCoreThreadPoolSize;
    private int requestMaxThreadPoolSize;
    private long threadKeepAliveTime;
    private TimeUnit threadKeepAliveTimeUnit;
    private WorkerFactory requestWorkerFactory = null;

    public HttpFactory(ConfigurationContext configurationContext) throws AxisFault {
        this.configurationContext = configurationContext;
        this.httpConfiguration = configurationContext.getAxisConfiguration().getTransportIn("http");
        this.port = this.getIntParam(PARAMETER_PORT, 6060);
        this.hostAddress = this.getStringParam(PARAMETER_HOST_ADDRESS, null);
        this.originServer = this.getStringParam(PARAMETER_ORIGIN_SERVER, "Simple-Server/1.1");
        this.requestSocketTimeout = this.getIntParam(PARAMETER_REQUEST_SOCKET_TIMEOUT, 20000);
        this.requestTcpNoDelay = this.getBooleanParam(PARAMETER_REQUEST_TCP_NO_DELAY, true);
        this.requestCoreThreadPoolSize = this.getIntParam(PARAMETER_REQUEST_CORE_THREAD_POOL_SIZE, 100);
        this.requestMaxThreadPoolSize = this.getIntParam(PARAMETER_REQUEST_MAX_THREAD_POOL_SIZE, 150);
        this.threadKeepAliveTime = this.getLongParam(PARAMETER_THREAD_KEEP_ALIVE_TIME, 180L);
        this.threadKeepAliveTimeUnit = this.getTimeUnitParam(PARAMETER_THREAD_KEEP_ALIVE_TIME_UNIT, TimeUnit.SECONDS);
    }

    public HttpFactory(ConfigurationContext configurationContext, int port) throws AxisFault {
        this(configurationContext);
        this.port = port;
    }

    public HttpFactory(ConfigurationContext configurationContext, int port, WorkerFactory requestWorkerFactory) throws AxisFault {
        this(configurationContext, port);
        this.requestWorkerFactory = requestWorkerFactory;
    }

    private int getIntParam(String name, int def) {
        String config = this.getStringParam(name, null);
        if (config != null) {
            return Integer.parseInt(config);
        }
        return def;
    }

    private long getLongParam(String name, long def) {
        String config = this.getStringParam(name, null);
        if (config != null) {
            return Long.parseLong(config);
        }
        return def;
    }

    private boolean getBooleanParam(String name, boolean def) throws AxisFault {
        String config = this.getStringParam(name, null);
        if (config != null) {
            if (config.equals("yes") || config.equals("true")) {
                return true;
            }
            if (config.equals("no") || config.equals("false")) {
                return false;
            }
            throw new AxisFault("Boolean value must be yes, true, no or false for parameter " + name + ":  " + config);
        }
        return def;
    }

    private TimeUnit getTimeUnitParam(String name, TimeUnit def) throws AxisFault {
        String config = this.getStringParam(name, null);
        if (config != null) {
            try {
                return (TimeUnit)((Object)TimeUnit.class.getField(config).get(null));
            }
            catch (Exception e) {
                throw AxisFault.makeFault(e);
            }
        }
        return def;
    }

    private String getStringParam(String name, String def) {
        String config;
        Parameter param = this.httpConfiguration.getParameter(name);
        if (param != null && (config = (String)param.getValue()) != null) {
            return config;
        }
        return def;
    }

    public ListenerManager getListenerManager() {
        return this.configurationContext.getListenerManager();
    }

    public ExecutorService newListenerExecutor(int port) {
        return new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory(new ThreadGroup("Listener thread group"), "HttpListener-" + this.port));
    }

    public IOProcessor newRequestConnectionListener(int port, HttpConnectionManager manager, HttpParams params) throws IOException {
        return new DefaultConnectionListener(port, manager, new DefaultConnectionListenerFailureHandler(), params);
    }

    public HttpParams newRequestConnectionParams() {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", this.requestSocketTimeout).setBooleanParameter("http.tcp.nodelay", this.requestTcpNoDelay).setIntParameter("http.connection.max-line-length", 4000).setIntParameter("http.connection.max-header-count", 500).setIntParameter("http.socket.buffer-size", 8192).setParameter("http.origin-server", (Object)this.originServer);
        return params;
    }

    public HttpConnectionManager newRequestConnectionManager(ExecutorService requestExecutor, WorkerFactory workerFactory, HttpParams params) {
        return new DefaultHttpConnectionManager(this.configurationContext, requestExecutor, workerFactory, params);
    }

    public ExecutorService newRequestExecutor(int port) {
        return new ThreadPoolExecutor(this.requestCoreThreadPoolSize, this.requestMaxThreadPoolSize, this.threadKeepAliveTime, this.threadKeepAliveTimeUnit, (BlockingQueue<Runnable>)this.newRequestBlockingQueue(), new DefaultThreadFactory(new ThreadGroup("Connection thread group"), "HttpConnection-" + port));
    }

    public BlockingQueue newRequestBlockingQueue() {
        return new LinkedBlockingQueue();
    }

    public WorkerFactory newRequestWorkerFactory() {
        if (this.requestWorkerFactory != null) {
            return this.requestWorkerFactory;
        }
        return new HTTPWorkerFactory();
    }

    public HttpProcessor newHttpProcessor() {
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpRequestInterceptor)new RequestSessionCookie());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseSessionCookie());
        return httpProcessor;
    }

    public ConnectionReuseStrategy newConnStrategy() {
        return new DefaultConnectionReuseStrategy();
    }

    public HttpResponseFactory newResponseFactory() {
        return new DefaultHttpResponseFactory();
    }

    public ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public TransportInDescription getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public String getOriginServer() {
        return this.originServer;
    }

    public void setOriginServer(String originServer) {
        this.originServer = originServer;
    }

    public int getRequestSocketTimeout() {
        return this.requestSocketTimeout;
    }

    public void setRequestSocketTimeout(int requestSocketTimeout) {
        this.requestSocketTimeout = requestSocketTimeout;
    }

    public boolean getRequestTcpNoDelay() {
        return this.requestTcpNoDelay;
    }

    public void setRequestTcpNoDelay(boolean requestTcpNoDelay) {
        this.requestTcpNoDelay = requestTcpNoDelay;
    }

    public int getRequestCoreThreadPoolSize() {
        return this.requestCoreThreadPoolSize;
    }

    public void setRequestCoreThreadPoolSize(int requestCoreThreadPoolSize) {
        this.requestCoreThreadPoolSize = requestCoreThreadPoolSize;
    }

    public int getRequestMaxThreadPoolSize() {
        return this.requestMaxThreadPoolSize;
    }

    public void setRequestMaxThreadPoolSize(int requestMaxThreadPoolSize) {
        this.requestMaxThreadPoolSize = requestMaxThreadPoolSize;
    }

    public long getThreadKeepAliveTime() {
        return this.threadKeepAliveTime;
    }

    public void setThreadKeepAliveTime(long threadKeepAliveTime) {
        this.threadKeepAliveTime = threadKeepAliveTime;
    }

    public TimeUnit getThreadKeepAliveTimeUnit() {
        return this.threadKeepAliveTimeUnit;
    }

    public void setThreadKeepAliveTimeUnit(TimeUnit threadKeepAliveTimeUnit) {
        this.threadKeepAliveTimeUnit = threadKeepAliveTimeUnit;
    }
}

