/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atom;

import java.util.Date;
import org.apache.abdera.model.Entry;
import org.apache.camel.component.feed.EntryFilter;
import org.apache.camel.component.feed.FeedEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatedDateFilter
implements EntryFilter {
    private static final transient Logger LOG = LoggerFactory.getLogger(UpdatedDateFilter.class);
    private Date lastUpdate;

    public UpdatedDateFilter(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    @Override
    public boolean isValidEntry(FeedEndpoint endpoint, Object feed, Object entry) {
        Date updated = ((Entry)entry).getUpdated();
        if (updated == null) {
            updated = ((Entry)entry).getPublished();
        }
        if (updated == null) {
            LOG.debug("No updated time for entry so assuming its valid: entry=[{}]", entry);
            return true;
        }
        if (this.lastUpdate != null && (this.lastUpdate.after(updated) || this.lastUpdate.equals(updated))) {
            LOG.debug("Entry is older than lastupdate=[{}], no valid entry=[{}]", (Object)this.lastUpdate, entry);
            return false;
        }
        this.lastUpdate = updated;
        return true;
    }
}

