/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.bam.ActivityBuilder;
import org.apache.camel.bam.QueryUtils;
import org.apache.camel.bam.model.ActivityDefinition;
import org.apache.camel.bam.model.ProcessDefinition;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.processor.ActivityMonitorEngine;
import org.apache.camel.bam.processor.JpaBamProcessor;
import org.apache.camel.bam.rules.ProcessRules;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class ProcessBuilder
extends RouteBuilder {
    private static int processCounter;
    private JpaTemplate jpaTemplate;
    private TransactionTemplate transactionTemplate;
    private String processName;
    private List<ActivityBuilder> activityBuilders = new ArrayList<ActivityBuilder>();
    private Class<ProcessInstance> entityType = ProcessInstance.class;
    private ProcessRules processRules = new ProcessRules();
    private ProcessDefinition processDefinition;
    private ActivityMonitorEngine engine;

    protected ProcessBuilder() {
    }

    protected ProcessBuilder(JpaTemplate jpaTemplate, TransactionTemplate transactionTemplate) {
        this(jpaTemplate, transactionTemplate, ProcessBuilder.createProcessName());
    }

    protected ProcessBuilder(JpaTemplate jpaTemplate, TransactionTemplate transactionTemplate, String processName) {
        this.jpaTemplate = jpaTemplate;
        this.transactionTemplate = transactionTemplate;
        this.processName = processName;
    }

    protected static synchronized String createProcessName() {
        return "Process-" + ++processCounter;
    }

    public ActivityBuilder activity(String endpointUri) {
        return this.activity(this.endpoint(endpointUri));
    }

    public ActivityBuilder activity(Endpoint endpoint) {
        ActivityBuilder answer = new ActivityBuilder(this, endpoint);
        this.activityBuilders.add(answer);
        return answer;
    }

    public ProcessBuilder entityType(Class<ProcessInstance> entityType) {
        this.entityType = entityType;
        return this;
    }

    public Processor createActivityProcessor(ActivityBuilder activityBuilder) {
        ObjectHelper.notNull((Object)this.jpaTemplate, (String)"jpaTemplate");
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                ProcessBuilder.this.processRules.setProcessDefinition(ProcessBuilder.this.getProcessDefinition());
            }
        });
        return new JpaBamProcessor(this.getTransactionTemplate(), this.getJpaTemplate(), activityBuilder.getCorrelationExpression(), activityBuilder.getActivityRules(), this.getEntityType());
    }

    public List<ActivityBuilder> getActivityBuilders() {
        return this.activityBuilders;
    }

    public Class<ProcessInstance> getEntityType() {
        return this.entityType;
    }

    public JpaTemplate getJpaTemplate() {
        return this.jpaTemplate;
    }

    public void setJpaTemplate(JpaTemplate jpaTemplate) {
        this.jpaTemplate = jpaTemplate;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public ProcessRules getProcessRules() {
        return this.processRules;
    }

    public String getProcessName() {
        if (this.processName == null) {
            this.processName = ProcessBuilder.createProcessName();
        }
        return this.processName;
    }

    public ProcessDefinition getProcessDefinition() {
        if (this.processDefinition == null) {
            this.processDefinition = this.findOrCreateProcessDefinition();
        }
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    protected void populateRoutes() throws Exception {
        ModelCamelContext camelContext;
        ObjectHelper.notNull((Object)this.getJpaTemplate(), (String)"jpaTemplate", (Object)((Object)this));
        ObjectHelper.notNull((Object)this.getTransactionTemplate(), (String)"transactionTemplate", (Object)((Object)this));
        if (this.engine == null) {
            this.engine = new ActivityMonitorEngine(this.getJpaTemplate(), this.getTransactionTemplate(), this.getProcessRules());
        }
        if ((camelContext = this.getContext()) instanceof DefaultCamelContext) {
            DefaultCamelContext defaultCamelContext = (DefaultCamelContext)camelContext;
            defaultCamelContext.addService((Object)this.engine);
        }
        for (ActivityBuilder builder : this.activityBuilders) {
            this.from(builder.getEndpoint()).process(builder.getProcessor());
        }
        super.populateRoutes();
    }

    public ActivityDefinition findOrCreateActivityDefinition(String activityName) {
        ProcessDefinition definition = this.getProcessDefinition();
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("definition", definition);
        params.put("name", activityName);
        List list = CastUtils.cast((List)this.jpaTemplate.findByNamedParams("select x from " + QueryUtils.getTypeName(ActivityDefinition.class) + " x where x.processDefinition = :definition and x.name = :name", params));
        if (!list.isEmpty()) {
            return (ActivityDefinition)list.get(0);
        }
        ActivityDefinition answer = new ActivityDefinition();
        answer.setName(activityName);
        answer.setProcessDefinition(ProcessDefinition.getRefreshedProcessDefinition(this.jpaTemplate, definition));
        this.jpaTemplate.persist((Object)answer);
        return answer;
    }

    protected ProcessDefinition findOrCreateProcessDefinition() {
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put("name", this.processName);
        List list = CastUtils.cast((List)this.jpaTemplate.findByNamedParams("select x from " + QueryUtils.getTypeName(ProcessDefinition.class) + " x where x.name = :name", params));
        if (!list.isEmpty()) {
            return (ProcessDefinition)list.get(0);
        }
        ProcessDefinition answer = new ProcessDefinition();
        answer.setName(this.processName);
        this.jpaTemplate.persist((Object)answer);
        return answer;
    }
}

