/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.processor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.bam.QueryUtils;
import org.apache.camel.bam.model.ProcessDefinition;
import org.apache.camel.bam.processor.BamProcessorSupport;
import org.apache.camel.bam.rules.ActivityRules;
import org.apache.camel.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.jpa.JpaTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class JpaBamProcessorSupport<T>
extends BamProcessorSupport<T> {
    private static final transient Logger LOG = LoggerFactory.getLogger(JpaBamProcessorSupport.class);
    private static final Lock LOCK = new ReentrantLock();
    private ActivityRules activityRules;
    private JpaTemplate template;
    private String findByKeyQuery;
    private String keyPropertyName = "correlationKey";
    private boolean correlationKeyIsPrimary = true;

    public JpaBamProcessorSupport(TransactionTemplate transactionTemplate, JpaTemplate template, Expression correlationKeyExpression, ActivityRules activityRules, Class<T> entitytype) {
        super(transactionTemplate, correlationKeyExpression, entitytype);
        this.activityRules = activityRules;
        this.template = template;
    }

    public JpaBamProcessorSupport(TransactionTemplate transactionTemplate, JpaTemplate template, Expression correlationKeyExpression, ActivityRules activityRules) {
        super(transactionTemplate, correlationKeyExpression);
        this.activityRules = activityRules;
        this.template = template;
    }

    public String getFindByKeyQuery() {
        if (this.findByKeyQuery == null) {
            this.findByKeyQuery = this.createFindByKeyQuery();
        }
        return this.findByKeyQuery;
    }

    public void setFindByKeyQuery(String findByKeyQuery) {
        this.findByKeyQuery = findByKeyQuery;
    }

    public ActivityRules getActivityRules() {
        return this.activityRules;
    }

    public void setActivityRules(ActivityRules activityRules) {
        this.activityRules = activityRules;
    }

    public String getKeyPropertyName() {
        return this.keyPropertyName;
    }

    public void setKeyPropertyName(String keyPropertyName) {
        this.keyPropertyName = keyPropertyName;
    }

    public JpaTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JpaTemplate template) {
        this.template = template;
    }

    public boolean isCorrelationKeyIsPrimary() {
        return this.correlationKeyIsPrimary;
    }

    public void setCorrelationKeyIsPrimary(boolean correlationKeyIsPrimary) {
        this.correlationKeyIsPrimary = correlationKeyIsPrimary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T loadEntity(Exchange exchange, Object key) throws Exception {
        LOCK.lock();
        try {
            LOG.info(">> LoadEntity call");
            T entity = this.findEntityByCorrelationKey(key);
            if (entity == null) {
                entity = this.createEntity(exchange, key);
                this.setKeyProperty(entity, key);
                ProcessDefinition definition = ProcessDefinition.getRefreshedProcessDefinition(this.template, this.getActivityRules().getProcessRules().getProcessDefinition());
                this.setProcessDefinitionProperty(entity, definition);
                this.template.persist(entity);
                LOG.debug("About to flush on entity: " + entity + " with key: " + key);
                this.template.flush();
            }
            T t = entity;
            return t;
        }
        finally {
            LOCK.unlock();
        }
    }

    protected T findEntityByCorrelationKey(Object key) {
        if (this.isCorrelationKeyIsPrimary()) {
            return (T)this.template.find(this.getEntityType(), key);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("key", key);
        List list = this.template.findByNamedParams(this.getFindByKeyQuery(), params);
        if (list.isEmpty()) {
            return null;
        }
        return (T)list.get(0);
    }

    @Override
    protected Class<?> getKeyType() {
        try {
            Method getter = IntrospectionSupport.getPropertyGetter(this.getEntityType(), (String)this.getKeyPropertyName());
            return getter.getReturnType();
        }
        catch (NoSuchMethodException e) {
            LOG.warn("no such getter for: " + this.getKeyPropertyName() + " on " + this.getEntityType() + ". Reason: " + e, (Throwable)e);
            return null;
        }
    }

    protected void setKeyProperty(T entity, Object key) throws Exception {
        IntrospectionSupport.setProperty(entity, (String)this.getKeyPropertyName(), (Object)key);
    }

    protected void setProcessDefinitionProperty(T entity, ProcessDefinition processDefinition) throws Exception {
        IntrospectionSupport.setProperty(entity, (String)"processDefinition", (Object)processDefinition);
    }

    protected T createEntity(Exchange exchange, Object key) {
        return (T)exchange.getContext().getInjector().newInstance(this.getEntityType());
    }

    @Override
    protected void processEntity(Exchange exchange, T entity) throws Exception {
        if (!(entity instanceof Processor)) {
            throw new IllegalArgumentException("No processor defined for this route");
        }
        Processor processor = (Processor)entity;
        processor.process(exchange);
    }

    protected String createFindByKeyQuery() {
        return "select x from " + QueryUtils.getTypeName(this.getEntityType()) + " x where x." + this.getKeyPropertyName() + " = :key";
    }
}

