/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.bam.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.bam.model.ActivityState;
import org.apache.camel.bam.model.ProcessDefinition;
import org.apache.camel.bam.model.ProcessInstance;
import org.apache.camel.bam.rules.ActivityRules;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ServiceHelper;

public class ProcessRules
extends ServiceSupport {
    private ProcessDefinition processDefinition;
    private List<ActivityRules> activities = new ArrayList<ActivityRules>();

    public void processExpired(ActivityState activityState) throws Exception {
        for (ActivityRules activityRules : this.activities) {
            activityRules.processExpired(activityState);
        }
    }

    public void processExchange(Exchange exchange, ProcessInstance process) {
        for (ActivityRules activityRules : this.activities) {
            activityRules.processExchange(exchange, process);
        }
    }

    public List<ActivityRules> getActivities() {
        return this.activities;
    }

    public ProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(ProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startServices(this.activities);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.activities);
    }
}

