/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cassandra.CassandraComponent;
import org.apache.camel.component.cassandra.CassandraConsumer;
import org.apache.camel.component.cassandra.CassandraProducer;
import org.apache.camel.component.cassandra.ResultSetConversionStrategies;
import org.apache.camel.component.cassandra.ResultSetConversionStrategy;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.utils.cassandra.CassandraLoadBalancingPolicies;
import org.apache.camel.utils.cassandra.CassandraSessionHolder;

@UriEndpoint(firstVersion="2.15.0", scheme="cql", title="Cassandra CQL", syntax="cql:beanRef:hosts:port/keyspace", label="database,nosql")
public class CassandraEndpoint
extends ScheduledPollEndpoint {
    private volatile CassandraSessionHolder sessionHolder;
    @UriPath(description="beanRef is defined using bean:id")
    private String beanRef;
    @UriPath
    private String hosts;
    @UriPath
    private Integer port;
    @UriPath
    private String keyspace;
    @UriParam
    private String cql;
    @UriParam(defaultValue="true")
    private boolean prepareStatements = true;
    @UriParam
    private String clusterName;
    @UriParam
    private String username;
    @UriParam
    private String password;
    @UriParam
    private Cluster cluster;
    @UriParam
    private Session session;
    @UriParam
    private ConsistencyLevel consistencyLevel;
    @UriParam
    private String loadBalancingPolicy;
    @UriParam(javaType="java.lang.String")
    private ResultSetConversionStrategy resultSetConversionStrategy = ResultSetConversionStrategies.all();

    public CassandraEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public CassandraEndpoint(String uri, CassandraComponent component, Cluster cluster, Session session, String keyspace) {
        super(uri, (Component)component);
        this.cluster = cluster;
        this.session = session;
        this.keyspace = keyspace;
    }

    public Producer createProducer() throws Exception {
        return new CassandraProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        CassandraConsumer consumer = new CassandraConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public boolean isSingleton() {
        return true;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.cluster == null && this.beanRef != null) {
            Object bean = CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)this.beanRef);
            if (bean instanceof Session) {
                this.session = (Session)bean;
                this.cluster = this.session.getCluster();
                this.keyspace = this.session.getLoggedKeyspace();
            } else if (bean instanceof Cluster) {
                this.cluster = (Cluster)bean;
                this.session = null;
            } else {
                throw new IllegalArgumentException("CQL Bean type should be of type Session or Cluster but was " + bean);
            }
        }
        if (this.cluster == null && this.hosts != null) {
            this.cluster = this.createClusterBuilder().build();
        }
        this.sessionHolder = this.cluster != null ? new CassandraSessionHolder(this.cluster, this.keyspace) : new CassandraSessionHolder(this.session);
        this.sessionHolder.start();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.sessionHolder.stop();
    }

    protected CassandraSessionHolder getSessionHolder() {
        return this.sessionHolder;
    }

    protected Cluster.Builder createClusterBuilder() throws Exception {
        CassandraLoadBalancingPolicies cassLoadBalancingPolicies = new CassandraLoadBalancingPolicies();
        Cluster.Builder clusterBuilder = Cluster.builder();
        for (String host : this.hosts.split(",")) {
            clusterBuilder = clusterBuilder.addContactPoint(host);
        }
        if (this.port != null) {
            clusterBuilder = clusterBuilder.withPort(this.port.intValue());
        }
        if (this.clusterName != null) {
            clusterBuilder = clusterBuilder.withClusterName(this.clusterName);
        }
        if (this.username != null && !this.username.isEmpty() && this.password != null) {
            clusterBuilder.withCredentials(this.username, this.password);
        }
        if (this.loadBalancingPolicy != null && !this.loadBalancingPolicy.isEmpty()) {
            clusterBuilder.withLoadBalancingPolicy(cassLoadBalancingPolicies.getLoadBalancingPolicy(this.loadBalancingPolicy));
        }
        return clusterBuilder;
    }

    protected PreparedStatement prepareStatement(String cql) {
        PreparedStatement preparedStatement = this.getSessionHolder().getSession().prepare(cql);
        if (this.consistencyLevel != null) {
            preparedStatement.setConsistencyLevel(this.consistencyLevel);
        }
        return preparedStatement;
    }

    protected PreparedStatement prepareStatement() {
        return this.prepareStatement(this.cql);
    }

    protected void fillMessage(ResultSet resultSet, Message message) {
        message.setBody(this.resultSetConversionStrategy.getBody(resultSet));
    }

    public String getBean() {
        return this.beanRef;
    }

    public void setBean(String beanRef) {
        this.beanRef = beanRef;
    }

    @Deprecated
    public String getBeanRef() {
        return this.beanRef;
    }

    @Deprecated
    public void setBeanRef(String beanRef) {
        this.beanRef = beanRef;
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public String getCql() {
        return this.cql;
    }

    public void setCql(String cql) {
        this.cql = cql;
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Session getSession() {
        if (this.session == null) {
            return this.sessionHolder.getSession();
        }
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public ResultSetConversionStrategy getResultSetConversionStrategy() {
        return this.resultSetConversionStrategy;
    }

    public void setResultSetConversionStrategy(ResultSetConversionStrategy resultSetConversionStrategy) {
        this.resultSetConversionStrategy = resultSetConversionStrategy;
    }

    public boolean isPrepareStatements() {
        return this.prepareStatements;
    }

    public void setPrepareStatements(boolean prepareStatements) {
        this.prepareStatements = prepareStatements;
    }

    public String getLoadBalancingPolicy() {
        return this.loadBalancingPolicy;
    }

    public void setLoadBalancingPolicy(String loadBalancingPolicy) {
        this.loadBalancingPolicy = loadBalancingPolicy;
    }
}

