/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.CatalogHelper;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.apache.camel.catalog.URISupport;

public class DefaultCamelCatalog
implements CamelCatalog {
    private static final String MODELS_CATALOG = "org/apache/camel/catalog/models.properties";
    private static final String COMPONENTS_CATALOG = "org/apache/camel/catalog/components.properties";
    private static final String DATA_FORMATS_CATALOG = "org/apache/camel/catalog/dataformats.properties";
    private static final String LANGUAGE_CATALOG = "org/apache/camel/catalog/languages.properties";
    private static final String MODEL_JSON = "org/apache/camel/catalog/models";
    private static final String COMPONENTS_JSON = "org/apache/camel/catalog/components";
    private static final String DATA_FORMATS_JSON = "org/apache/camel/catalog/dataformats";
    private static final String LANGUAGE_JSON = "org/apache/camel/catalog/languages";
    private static final String ARCHETYPES_CATALOG = "org/apache/camel/catalog/archetypes/archetype-catalog.xml";
    private static final String SCHEMAS_XML = "org/apache/camel/catalog/schemas";
    private static final Pattern SYNTAX_PATTERN = Pattern.compile("(\\w+)");

    @Override
    public List<String> findComponentNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(COMPONENTS_CATALOG);
        if (is != null) {
            try {
                CatalogHelper.loadLines(is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    @Override
    public List<String> findDataFormatNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(DATA_FORMATS_CATALOG);
        if (is != null) {
            try {
                CatalogHelper.loadLines(is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    @Override
    public List<String> findLanguageNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(LANGUAGE_CATALOG);
        if (is != null) {
            try {
                CatalogHelper.loadLines(is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    @Override
    public List<String> findModelNames() {
        ArrayList<String> names = new ArrayList<String>();
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(MODELS_CATALOG);
        if (is != null) {
            try {
                CatalogHelper.loadLines(is, names);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return names;
    }

    @Override
    public List<String> findModelNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findModelNames();
        for (String name : names) {
            String json = this.modelJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findComponentNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findComponentNames();
        for (String name : names) {
            String json = this.componentJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findDataFormatNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findDataFormatNames();
        for (String name : names) {
            String json = this.dataFormatJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public List<String> findLanguageNames(String filter) {
        ArrayList<String> answer = new ArrayList<String>();
        List<String> names = this.findLanguageNames();
        for (String name : names) {
            String json = this.languageJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    try {
                        if (!part.equalsIgnoreCase(filter) && !CatalogHelper.matchWildcard(part, filter) && !part.matches(filter)) continue;
                        answer.add(name);
                    }
                    catch (PatternSyntaxException e) {
                        // empty catch block
                    }
                }
            }
        }
        return answer;
    }

    @Override
    public String modelJSonSchema(String name) {
        String file = "org/apache/camel/catalog/models/" + name + ".json";
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
        if (is != null) {
            try {
                return CatalogHelper.loadText(is);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String componentJSonSchema(String name) {
        String file = "org/apache/camel/catalog/components/" + name + ".json";
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
        if (is != null) {
            try {
                return CatalogHelper.loadText(is);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String dataFormatJSonSchema(String name) {
        String file = "org/apache/camel/catalog/dataformats/" + name + ".json";
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
        if (is != null) {
            try {
                return CatalogHelper.loadText(is);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String languageJSonSchema(String name) {
        String file = "org/apache/camel/catalog/languages/" + name + ".json";
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
        if (is != null) {
            try {
                return CatalogHelper.loadText(is);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Set<String> findModelLabels() {
        TreeSet<String> answer = new TreeSet<String>();
        List<String> names = this.findModelNames();
        for (String name : names) {
            String json = this.modelJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("model", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    answer.add(part);
                }
            }
        }
        return answer;
    }

    @Override
    public Set<String> findComponentLabels() {
        TreeSet<String> answer = new TreeSet<String>();
        List<String> names = this.findComponentNames();
        for (String name : names) {
            String json = this.componentJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    answer.add(part);
                }
            }
        }
        return answer;
    }

    @Override
    public Set<String> findDataFormatLabels() {
        TreeSet<String> answer = new TreeSet<String>();
        List<String> names = this.findDataFormatNames();
        for (String name : names) {
            String json = this.dataFormatJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("dataformat", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    answer.add(part);
                }
            }
        }
        return answer;
    }

    @Override
    public Set<String> findLanguageLabels() {
        TreeSet<String> answer = new TreeSet<String>();
        List<String> names = this.findLanguageNames();
        for (String name : names) {
            String json = this.languageJSonSchema(name);
            if (json == null) continue;
            List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("language", json, false);
            for (Map<String, String> row : rows) {
                String[] parts;
                if (!row.containsKey("label")) continue;
                String label = row.get("label");
                for (String part : parts = label.split(",")) {
                    answer.add(part);
                }
            }
        }
        return answer;
    }

    @Override
    public String archetypeCatalogAsXml() {
        String file = ARCHETYPES_CATALOG;
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
        if (is != null) {
            try {
                return CatalogHelper.loadText(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String springSchemaAsXml() {
        String file = "org/apache/camel/catalog/schemas/camel-spring.xsd";
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
        if (is != null) {
            try {
                return CatalogHelper.loadText(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String blueprintSchemaAsXml() {
        String file = "org/apache/camel/catalog/schemas/camel-blueprint.xsd";
        InputStream is = DefaultCamelCatalog.class.getClassLoader().getResourceAsStream(file);
        if (is != null) {
            try {
                return CatalogHelper.loadText(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Map<String, String> endpointProperties(String uri) throws URISyntaxException {
        URI u = new URI(uri);
        String scheme = u.getScheme();
        String json = this.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String syntax = null;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        for (Map<String, String> row : rows) {
            if (!row.containsKey("syntax")) continue;
            syntax = row.get("syntax");
            break;
        }
        if (syntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        Matcher matcher = SYNTAX_PATTERN.matcher(syntax);
        ArrayList<String> word = new ArrayList<String>();
        while (matcher.find()) {
            String s = matcher.group(1);
            if (scheme.equals(s)) continue;
            word.add(s);
        }
        String uriPath = URISupport.stripQuery(uri);
        ArrayList<String> word2 = new ArrayList<String>();
        if (word.size() == 1) {
            String s = uriPath;
            s = URISupport.stripPrefix(s, scheme);
            while (s.startsWith(":") || s.startsWith("/")) {
                s = s.substring(1);
            }
            word2.add(s);
        } else {
            Matcher matcher2 = SYNTAX_PATTERN.matcher(uriPath);
            while (matcher2.find()) {
                String s = matcher2.group(1);
                if (scheme.equals(s)) continue;
                word2.add(s);
            }
        }
        rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        boolean defaultValueAdded = false;
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        Iterator it = word2.iterator();
        for (int i = 0; i < word.size(); ++i) {
            String value;
            String key = (String)word.get(i);
            boolean allOptions = word.size() == word2.size();
            boolean required = JSonSchemaHelper.isPropertyRequired(rows, key);
            String defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, key);
            if (allOptions) {
                value = (String)it.next();
                options.put(key, value);
                continue;
            }
            if (!required) {
                value = defaultValue;
                options.put(key, value);
                defaultValueAdded = true;
                continue;
            }
            value = (String)it.next();
            options.put(key, value);
        }
        LinkedHashMap<String, String> answer = new LinkedHashMap<String, String>();
        for (Map.Entry entry : options.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (defaultValueAdded) {
                boolean required = JSonSchemaHelper.isPropertyRequired(rows, key);
                String defaultValue = JSonSchemaHelper.getPropertyDefaultValue(rows, key);
                if (!required && defaultValue != null && defaultValue.equals(value)) continue;
            }
            answer.put(key, value);
        }
        Map<String, Object> parameters = URISupport.parseParameters(u);
        for (Map.Entry<String, Object> entry : parameters.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue() != null ? entry.getValue().toString() : "";
            answer.put(key, value);
        }
        return answer;
    }

    @Override
    public String asEndpointUri(String scheme, String json) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, json, "&");
    }

    @Override
    public String asEndpointUriXml(String scheme, String json) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, json, "&amp;");
    }

    private String doAsEndpointUri(String scheme, String json, String ampersand) throws URISyntaxException {
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("properties", json, true);
        HashMap<String, String> copy = new HashMap<String, String>();
        for (Map<String, String> row : rows) {
            String name = row.get("name");
            String required = row.get("required");
            String value = row.get("value");
            String defaultValue = row.get("defaultValue");
            String valueToAdd = null;
            if ("true".equals(required)) {
                String string = valueToAdd = value != null ? value : defaultValue;
                if (valueToAdd == null) {
                    valueToAdd = "";
                }
            } else {
                if (value != null && defaultValue == null) {
                    valueToAdd = value;
                }
                if (value != null && defaultValue != null && !value.equals(defaultValue)) {
                    valueToAdd = value;
                }
            }
            if (valueToAdd == null) continue;
            copy.put(name, valueToAdd);
        }
        return this.doAsEndpointUri(scheme, copy, ampersand);
    }

    @Override
    public String asEndpointUri(String scheme, Map<String, String> properties) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, properties, "&");
    }

    @Override
    public String asEndpointUriXml(String scheme, Map<String, String> properties) throws URISyntaxException {
        return this.doAsEndpointUri(scheme, properties, "&amp;");
    }

    private String doAsEndpointUri(String scheme, Map<String, String> properties, String ampersand) throws URISyntaxException {
        String json = this.componentJSonSchema(scheme);
        if (json == null) {
            throw new IllegalArgumentException("Cannot find endpoint with scheme " + scheme);
        }
        String syntax = null;
        List<Map<String, String>> rows = JSonSchemaHelper.parseJsonSchema("component", json, false);
        for (Map<String, String> row : rows) {
            if (!row.containsKey("syntax")) continue;
            syntax = row.get("syntax");
            break;
        }
        if (syntax == null) {
            throw new IllegalArgumentException("Endpoint with scheme " + scheme + " has no syntax defined in the json schema");
        }
        String originalSyntax = syntax;
        TreeMap<String, String> copy = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String value;
            String key = entry.getKey();
            String string = value = entry.getValue() != null ? entry.getValue() : "";
            if (syntax.contains(key)) {
                syntax = syntax.replace(key, value);
                continue;
            }
            copy.put(key, value);
        }
        String[] tokens = syntax.split("\\w+");
        Matcher matcher = SYNTAX_PATTERN.matcher(originalSyntax);
        ArrayList<String> options = new ArrayList<String>();
        while (matcher.find()) {
            String s = matcher.group(1);
            options.add(s);
        }
        Matcher matcher2 = SYNTAX_PATTERN.matcher(syntax);
        ArrayList<String> options2 = new ArrayList<String>();
        while (matcher2.find()) {
            String s = matcher2.group(1);
            options2.add(s);
        }
        StringBuilder sb = new StringBuilder();
        int range = 0;
        for (int i = 0; i < options.size(); ++i) {
            String key = (String)options.get(i);
            String key2 = (String)options2.get(i);
            String token = tokens[i];
            if (i == 0 || properties.containsKey(key)) {
                sb.append(token);
                sb.append(key2);
            }
            ++range;
        }
        while (range < options2.size()) {
            String token = tokens[range];
            String key2 = (String)options2.get(range);
            sb.append(token);
            sb.append(key2);
            ++range;
        }
        if (!copy.isEmpty()) {
            sb.append('?');
            String query = URISupport.createQueryString(copy, ampersand);
            sb.append(query);
        }
        return sb.toString();
    }
}

