/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;

public class CamelCatalogMBeanExporter {
    public static final String MBEAN_NAME = "org.apache.camel.catalog:type=catalog,name=catalog";
    private CamelCatalog catalog;
    private ObjectName objectName;
    private MBeanServer mBeanServer;

    public void init() throws Exception {
        this.catalog = new DefaultCamelCatalog();
        if (this.objectName == null) {
            this.objectName = this.getObjectName();
        }
        if (this.mBeanServer == null) {
            this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        if (this.mBeanServer != null) {
            try {
                ObjectInstance oi = this.mBeanServer.registerMBean(this.catalog, this.objectName);
                if (oi != null && oi.getObjectName() != null) {
                    this.objectName = oi.getObjectName();
                }
            }
            catch (InstanceAlreadyExistsException iaee) {
                this.mBeanServer.unregisterMBean(this.objectName);
                this.mBeanServer.registerMBean(this.catalog, this.objectName);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.mBeanServer != null && this.objectName != null) {
            this.mBeanServer.unregisterMBean(this.objectName);
        }
    }

    protected ObjectName getObjectName() throws Exception {
        return new ObjectName(MBEAN_NAME);
    }
}

