/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.catalog;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimePatternConverter {
    private static final String NUMBERS_ONLY_STRING_PATTERN = "^[-]?(\\d)+$";
    private static final String HOUR_REGEX_PATTERN = "((\\d)*(\\d))h(our(s)?)?";
    private static final String MINUTES_REGEX_PATTERN = "((\\d)*(\\d))m(in(ute(s)?)?)?";
    private static final String SECONDS_REGEX_PATTERN = "((\\d)*(\\d))s(ec(ond)?(s)?)?";

    private TimePatternConverter() {
    }

    public static long toMilliSeconds(String source) throws IllegalArgumentException {
        long milliseconds = 0L;
        boolean foundFlag = false;
        TimePatternConverter.checkCorrectnessOfPattern(source);
        Matcher matcher = TimePatternConverter.createMatcher(NUMBERS_ONLY_STRING_PATTERN, source);
        if (matcher.find()) {
            milliseconds = Long.valueOf(source);
        } else {
            matcher = TimePatternConverter.createMatcher(HOUR_REGEX_PATTERN, source);
            if (matcher.find()) {
                milliseconds += 3600000L * Long.valueOf(matcher.group(1));
                foundFlag = true;
            }
            if ((matcher = TimePatternConverter.createMatcher(MINUTES_REGEX_PATTERN, source)).find()) {
                long minutes = Long.valueOf(matcher.group(1));
                if (minutes > 59L && foundFlag) {
                    throw new IllegalArgumentException("Minutes should contain a valid value between 0 and 59: " + source);
                }
                foundFlag = true;
                milliseconds += 60000L * minutes;
            }
            if ((matcher = TimePatternConverter.createMatcher(SECONDS_REGEX_PATTERN, source)).find()) {
                long seconds = Long.valueOf(matcher.group(1));
                if (seconds > 59L && foundFlag) {
                    throw new IllegalArgumentException("Seconds should contain a valid value between 0 and 59: " + source);
                }
                foundFlag = true;
                milliseconds += 1000L * seconds;
            }
            if (!foundFlag) {
                milliseconds = Long.valueOf(source);
            }
        }
        return milliseconds;
    }

    private static void checkCorrectnessOfPattern(String source) {
        Matcher matcher = TimePatternConverter.createMatcher(NUMBERS_ONLY_STRING_PATTERN, source);
        String replaceSource = matcher.replaceFirst("");
        if ((matcher = TimePatternConverter.createMatcher(HOUR_REGEX_PATTERN, replaceSource)).find() && matcher.find()) {
            throw new IllegalArgumentException("Hours should not be specified more then once: " + source);
        }
        replaceSource = matcher.replaceFirst("");
        if ((matcher = TimePatternConverter.createMatcher(MINUTES_REGEX_PATTERN, replaceSource)).find() && matcher.find()) {
            throw new IllegalArgumentException("Minutes should not be specified more then once: " + source);
        }
        replaceSource = matcher.replaceFirst("");
        if ((matcher = TimePatternConverter.createMatcher(SECONDS_REGEX_PATTERN, replaceSource)).find() && matcher.find()) {
            throw new IllegalArgumentException("Seconds should not be specified more then once: " + source);
        }
        replaceSource = matcher.replaceFirst("");
        if (replaceSource.length() > 0) {
            throw new IllegalArgumentException("Illegal characters: " + source);
        }
    }

    private static Matcher createMatcher(String regexPattern, String source) {
        Pattern pattern = Pattern.compile(regexPattern, 2);
        return pattern.matcher(source);
    }
}

