/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.camel.cdi.CdiBeanRegistry;
import org.apache.camel.cdi.CdiInjector;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;

public class CdiCamelContext
extends DefaultCamelContext {
    public CdiCamelContext() {
        super((Registry)new CdiBeanRegistry());
        this.setInjector(new CdiInjector(this.getInjector()));
    }

    @Inject
    public void setRegistry(Instance<Registry> instance) {
        if (this.isSingular(instance)) {
            this.setRegistry((Registry)instance.get());
        }
    }

    @Inject
    public void setInjector(Instance<Injector> instance) {
        if (this.isSingular(instance)) {
            this.setInjector((Injector)instance.get());
        }
    }

    private <T> boolean isSingular(Instance<T> instance) {
        return !instance.isUnsatisfied() && !instance.isAmbiguous();
    }

    @PostConstruct
    public void start() {
        try {
            super.start();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }

    @PreDestroy
    public void stop() {
        try {
            super.stop();
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

