/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.config.AWSConfigComponent;
import org.apache.camel.component.aws.config.AWSConfigConfiguration;
import org.apache.camel.component.aws.config.AWSConfigOperations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.config.ConfigClient;

public interface AwsConfigComponentBuilderFactory {
    public static AwsConfigComponentBuilder awsConfig() {
        return new AwsConfigComponentBuilderImpl();
    }

    public static class AwsConfigComponentBuilderImpl
    extends AbstractComponentBuilder<AWSConfigComponent>
    implements AwsConfigComponentBuilder {
        @Override
        protected AWSConfigComponent buildConcreteComponent() {
            return new AWSConfigComponent();
        }

        private AWSConfigConfiguration getOrCreateConfiguration(AWSConfigComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new AWSConfigConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "configuration": {
                    ((AWSConfigComponent)component).setConfiguration((AWSConfigConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((AWSConfigComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setOperation((AWSConfigOperations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setRegion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((AWSConfigComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configClient": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setConfigClient((ConfigClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((AWSConfigComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((AWSConfigComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setSecretKey((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((AWSConfigComponent)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsConfigComponentBuilder
    extends ComponentBuilder<AWSConfigComponent> {
        default public AwsConfigComponentBuilder configuration(AWSConfigConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsConfigComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsConfigComponentBuilder operation(AWSConfigOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsConfigComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AwsConfigComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AwsConfigComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsConfigComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public AwsConfigComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AwsConfigComponentBuilder configClient(ConfigClient configClient) {
            this.doSetProperty("configClient", configClient);
            return this;
        }

        default public AwsConfigComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public AwsConfigComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public AwsConfigComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsConfigComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsConfigComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsConfigComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsConfigComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public AwsConfigComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsConfigComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AwsConfigComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }

        default public AwsConfigComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    }
}

