/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerComponent;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerConfiguration;
import org.apache.camel.component.aws.secretsmanager.SecretsManagerOperations;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;

public interface AwsSecretsManagerComponentBuilderFactory {
    public static AwsSecretsManagerComponentBuilder awsSecretsManager() {
        return new AwsSecretsManagerComponentBuilderImpl();
    }

    public static class AwsSecretsManagerComponentBuilderImpl
    extends AbstractComponentBuilder<SecretsManagerComponent>
    implements AwsSecretsManagerComponentBuilder {
        @Override
        protected SecretsManagerComponent buildConcreteComponent() {
            return new SecretsManagerComponent();
        }

        private SecretsManagerConfiguration getOrCreateConfiguration(SecretsManagerComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new SecretsManagerConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "binaryPayload": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setBinaryPayload(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((SecretsManagerComponent)component).setConfiguration((SecretsManagerConfiguration)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((SecretsManagerComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setOperation((SecretsManagerOperations)value);
                    return true;
                }
                case "overrideEndpoint": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setOverrideEndpoint(((Boolean)value).booleanValue());
                    return true;
                }
                case "pojoRequest": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setPojoRequest(((Boolean)value).booleanValue());
                    return true;
                }
                case "profileCredentialsName": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setProfileCredentialsName((String)value);
                    return true;
                }
                case "region": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setRegion((String)value);
                    return true;
                }
                case "uriEndpointOverride": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setUriEndpointOverride((String)value);
                    return true;
                }
                case "useProfileCredentialsProvider": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setUseProfileCredentialsProvider(((Boolean)value).booleanValue());
                    return true;
                }
                case "autowiredEnabled": {
                    ((SecretsManagerComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "secretsManagerClient": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setSecretsManagerClient((SecretsManagerClient)value);
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((SecretsManagerComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((SecretsManagerComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "proxyHost": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setProxyHost((String)value);
                    return true;
                }
                case "proxyPort": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setProxyPort((Integer)value);
                    return true;
                }
                case "proxyProtocol": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setProxyProtocol((Protocol)value);
                    return true;
                }
                case "accessKey": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setAccessKey((String)value);
                    return true;
                }
                case "secretKey": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setSecretKey((String)value);
                    return true;
                }
                case "trustAllCertificates": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setTrustAllCertificates(((Boolean)value).booleanValue());
                    return true;
                }
                case "useDefaultCredentialsProvider": {
                    this.getOrCreateConfiguration((SecretsManagerComponent)component).setUseDefaultCredentialsProvider(Boolean.valueOf((Boolean)value));
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AwsSecretsManagerComponentBuilder
    extends ComponentBuilder<SecretsManagerComponent> {
        default public AwsSecretsManagerComponentBuilder binaryPayload(boolean binaryPayload) {
            this.doSetProperty("binaryPayload", binaryPayload);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder configuration(SecretsManagerConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder operation(SecretsManagerOperations operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            this.doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder pojoRequest(boolean pojoRequest) {
            this.doSetProperty("pojoRequest", pojoRequest);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder profileCredentialsName(String profileCredentialsName) {
            this.doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder region(String region) {
            this.doSetProperty("region", region);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder uriEndpointOverride(String uriEndpointOverride) {
            this.doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            this.doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder secretsManagerClient(SecretsManagerClient secretsManagerClient) {
            this.doSetProperty("secretsManagerClient", secretsManagerClient);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder proxyHost(String proxyHost) {
            this.doSetProperty("proxyHost", proxyHost);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder proxyPort(Integer proxyPort) {
            this.doSetProperty("proxyPort", proxyPort);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder proxyProtocol(Protocol proxyProtocol) {
            this.doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder accessKey(String accessKey) {
            this.doSetProperty("accessKey", accessKey);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder secretKey(String secretKey) {
            this.doSetProperty("secretKey", secretKey);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            this.doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }

        default public AwsSecretsManagerComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            this.doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
    }
}

