/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.azure.core.credential.AzureSasCredential;
import com.azure.identity.ClientSecretCredential;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Set;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.storage.datalake.DataLakeComponent;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.apache.camel.component.azure.storage.datalake.DataLakeOperationsDefinition;

public interface AzureStorageDatalakeComponentBuilderFactory {
    public static AzureStorageDatalakeComponentBuilder azureStorageDatalake() {
        return new AzureStorageDatalakeComponentBuilderImpl();
    }

    public static class AzureStorageDatalakeComponentBuilderImpl
    extends AbstractComponentBuilder<DataLakeComponent>
    implements AzureStorageDatalakeComponentBuilder {
        @Override
        protected DataLakeComponent buildConcreteComponent() {
            return new DataLakeComponent();
        }

        private DataLakeConfiguration getOrCreateConfiguration(DataLakeComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new DataLakeConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "clientId": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setClientId((String)value);
                    return true;
                }
                case "close": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setClose((Boolean)value);
                    return true;
                }
                case "closeStreamAfterRead": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setCloseStreamAfterRead((Boolean)value);
                    return true;
                }
                case "configuration": {
                    ((DataLakeComponent)component).setConfiguration((DataLakeConfiguration)value);
                    return true;
                }
                case "dataCount": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setDataCount((Long)value);
                    return true;
                }
                case "directoryName": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setDirectoryName((String)value);
                    return true;
                }
                case "downloadLinkExpiration": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setDownloadLinkExpiration((Long)value);
                    return true;
                }
                case "expression": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setExpression((String)value);
                    return true;
                }
                case "fileDir": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setFileDir((String)value);
                    return true;
                }
                case "fileName": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setFileName((String)value);
                    return true;
                }
                case "fileOffset": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setFileOffset((Long)value);
                    return true;
                }
                case "maxResults": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setMaxResults((Integer)value);
                    return true;
                }
                case "maxRetryRequests": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setMaxRetryRequests(((Integer)value).intValue());
                    return true;
                }
                case "openOptions": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setOpenOptions((Set)value);
                    return true;
                }
                case "path": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setPath((String)value);
                    return true;
                }
                case "permission": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setPermission((String)value);
                    return true;
                }
                case "position": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setPosition((Long)value);
                    return true;
                }
                case "recursive": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setRecursive((Boolean)value);
                    return true;
                }
                case "regex": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setRegex((String)value);
                    return true;
                }
                case "retainUncommitedData": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setRetainUncommitedData((Boolean)value);
                    return true;
                }
                case "serviceClient": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setServiceClient((DataLakeServiceClient)value);
                    return true;
                }
                case "sharedKeyCredential": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setSharedKeyCredential((StorageSharedKeyCredential)value);
                    return true;
                }
                case "tenantId": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setTenantId((String)value);
                    return true;
                }
                case "timeout": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setTimeout((Duration)value);
                    return true;
                }
                case "umask": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setUmask((String)value);
                    return true;
                }
                case "userPrincipalNameReturned": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setUserPrincipalNameReturned((Boolean)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((DataLakeComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "lazyStartProducer": {
                    ((DataLakeComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setOperation((DataLakeOperationsDefinition)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((DataLakeComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((DataLakeComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((DataLakeComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accountKey": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setAccountKey((String)value);
                    return true;
                }
                case "clientSecret": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setClientSecret((String)value);
                    return true;
                }
                case "clientSecretCredential": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setClientSecretCredential((ClientSecretCredential)value);
                    return true;
                }
                case "sasCredential": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setSasCredential((AzureSasCredential)value);
                    return true;
                }
                case "sasSignature": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setSasSignature((String)value);
                    return true;
                }
                case "useDefaultIdentity": {
                    this.getOrCreateConfiguration((DataLakeComponent)component).setUseDefaultIdentity((Boolean)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AzureStorageDatalakeComponentBuilder
    extends ComponentBuilder<DataLakeComponent> {
        default public AzureStorageDatalakeComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder close(Boolean close) {
            this.doSetProperty("close", close);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder closeStreamAfterRead(Boolean closeStreamAfterRead) {
            this.doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder configuration(DataLakeConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder dataCount(Long dataCount) {
            this.doSetProperty("dataCount", dataCount);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder directoryName(String directoryName) {
            this.doSetProperty("directoryName", directoryName);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder downloadLinkExpiration(Long downloadLinkExpiration) {
            this.doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder expression(String expression) {
            this.doSetProperty("expression", expression);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder fileDir(String fileDir) {
            this.doSetProperty("fileDir", fileDir);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder fileName(String fileName) {
            this.doSetProperty("fileName", fileName);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder fileOffset(Long fileOffset) {
            this.doSetProperty("fileOffset", fileOffset);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder maxResults(Integer maxResults) {
            this.doSetProperty("maxResults", maxResults);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder maxRetryRequests(int maxRetryRequests) {
            this.doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder openOptions(Set<OpenOption> openOptions) {
            this.doSetProperty("openOptions", openOptions);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder path(String path) {
            this.doSetProperty("path", path);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder permission(String permission) {
            this.doSetProperty("permission", permission);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder position(Long position) {
            this.doSetProperty("position", position);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder recursive(Boolean recursive) {
            this.doSetProperty("recursive", recursive);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder regex(String regex) {
            this.doSetProperty("regex", regex);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder retainUncommitedData(Boolean retainUncommitedData) {
            this.doSetProperty("retainUncommitedData", retainUncommitedData);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder serviceClient(DataLakeServiceClient serviceClient) {
            this.doSetProperty("serviceClient", serviceClient);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder sharedKeyCredential(StorageSharedKeyCredential sharedKeyCredential) {
            this.doSetProperty("sharedKeyCredential", sharedKeyCredential);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder tenantId(String tenantId) {
            this.doSetProperty("tenantId", tenantId);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder timeout(Duration timeout) {
            this.doSetProperty("timeout", timeout);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder umask(String umask) {
            this.doSetProperty("umask", umask);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder userPrincipalNameReturned(Boolean userPrincipalNameReturned) {
            this.doSetProperty("userPrincipalNameReturned", userPrincipalNameReturned);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder operation(DataLakeOperationsDefinition operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder accountKey(String accountKey) {
            this.doSetProperty("accountKey", accountKey);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder clientSecret(String clientSecret) {
            this.doSetProperty("clientSecret", clientSecret);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder clientSecretCredential(ClientSecretCredential clientSecretCredential) {
            this.doSetProperty("clientSecretCredential", clientSecretCredential);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder sasCredential(AzureSasCredential sasCredential) {
            this.doSetProperty("sasCredential", sasCredential);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder sasSignature(String sasSignature) {
            this.doSetProperty("sasSignature", sasSignature);
            return this;
        }

        default public AzureStorageDatalakeComponentBuilder useDefaultIdentity(Boolean useDefaultIdentity) {
            this.doSetProperty("useDefaultIdentity", useDefaultIdentity);
            return this;
        }
    }
}

