/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.component.kafka.KafkaComponent;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.PollOnError;
import org.apache.camel.component.kafka.SeekPolicy;
import org.apache.camel.component.kafka.consumer.KafkaManualCommitFactory;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.jsse.SSLContextParameters;

public interface KafkaComponentBuilderFactory {
    public static KafkaComponentBuilder kafka() {
        return new KafkaComponentBuilderImpl();
    }

    public static class KafkaComponentBuilderImpl
    extends AbstractComponentBuilder<KafkaComponent>
    implements KafkaComponentBuilder {
        @Override
        protected KafkaComponent buildConcreteComponent() {
            return new KafkaComponent();
        }

        private KafkaConfiguration getOrCreateConfiguration(KafkaComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new KafkaConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "additionalProperties": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setAdditionalProperties((Map)value);
                    return true;
                }
                case "brokers": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setBrokers((String)value);
                    return true;
                }
                case "clientId": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setClientId((String)value);
                    return true;
                }
                case "configuration": {
                    ((KafkaComponent)component).setConfiguration((KafkaConfiguration)value);
                    return true;
                }
                case "headerFilterStrategy": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setHeaderFilterStrategy((HeaderFilterStrategy)value);
                    return true;
                }
                case "reconnectBackoffMaxMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setReconnectBackoffMaxMs((Integer)value);
                    return true;
                }
                case "shutdownTimeout": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setShutdownTimeout(((Integer)value).intValue());
                    return true;
                }
                case "allowManualCommit": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setAllowManualCommit(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoCommitEnable": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setAutoCommitEnable(((Boolean)value).booleanValue());
                    return true;
                }
                case "autoCommitIntervalMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setAutoCommitIntervalMs((Integer)value);
                    return true;
                }
                case "autoOffsetReset": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setAutoOffsetReset((String)value);
                    return true;
                }
                case "batching": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setBatching(((Boolean)value).booleanValue());
                    return true;
                }
                case "breakOnFirstError": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setBreakOnFirstError(((Boolean)value).booleanValue());
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((KafkaComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "checkCrcs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setCheckCrcs((Boolean)value);
                    return true;
                }
                case "commitTimeoutMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setCommitTimeoutMs((Long)value);
                    return true;
                }
                case "consumerRequestTimeoutMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setConsumerRequestTimeoutMs((Integer)value);
                    return true;
                }
                case "consumersCount": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setConsumersCount(((Integer)value).intValue());
                    return true;
                }
                case "fetchMaxBytes": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setFetchMaxBytes((Integer)value);
                    return true;
                }
                case "fetchMinBytes": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setFetchMinBytes((Integer)value);
                    return true;
                }
                case "fetchWaitMaxMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setFetchWaitMaxMs((Integer)value);
                    return true;
                }
                case "groupId": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setGroupId((String)value);
                    return true;
                }
                case "groupInstanceId": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setGroupInstanceId((String)value);
                    return true;
                }
                case "headerDeserializer": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setHeaderDeserializer((KafkaHeaderDeserializer)value);
                    return true;
                }
                case "heartbeatIntervalMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setHeartbeatIntervalMs((Integer)value);
                    return true;
                }
                case "keyDeserializer": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKeyDeserializer((String)value);
                    return true;
                }
                case "maxPartitionFetchBytes": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMaxPartitionFetchBytes((Integer)value);
                    return true;
                }
                case "maxPollIntervalMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMaxPollIntervalMs((Integer)value);
                    return true;
                }
                case "maxPollRecords": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMaxPollRecords((Integer)value);
                    return true;
                }
                case "offsetRepository": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setOffsetRepository((StateRepository)value);
                    return true;
                }
                case "partitionAssignor": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setPartitionAssignor((String)value);
                    return true;
                }
                case "pollOnError": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setPollOnError((PollOnError)value);
                    return true;
                }
                case "pollTimeoutMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setPollTimeoutMs((Long)value);
                    return true;
                }
                case "preValidateHostAndPort": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setPreValidateHostAndPort(((Boolean)value).booleanValue());
                    return true;
                }
                case "seekTo": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSeekTo((SeekPolicy)value);
                    return true;
                }
                case "sessionTimeoutMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSessionTimeoutMs((Integer)value);
                    return true;
                }
                case "specificAvroReader": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSpecificAvroReader(((Boolean)value).booleanValue());
                    return true;
                }
                case "topicIsPattern": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setTopicIsPattern(((Boolean)value).booleanValue());
                    return true;
                }
                case "valueDeserializer": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setValueDeserializer((String)value);
                    return true;
                }
                case "createConsumerBackoffInterval": {
                    ((KafkaComponent)component).setCreateConsumerBackoffInterval(((Long)value).longValue());
                    return true;
                }
                case "createConsumerBackoffMaxAttempts": {
                    ((KafkaComponent)component).setCreateConsumerBackoffMaxAttempts(((Integer)value).intValue());
                    return true;
                }
                case "isolationLevel": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setIsolationLevel((String)value);
                    return true;
                }
                case "kafkaManualCommitFactory": {
                    ((KafkaComponent)component).setKafkaManualCommitFactory((KafkaManualCommitFactory)value);
                    return true;
                }
                case "pollExceptionStrategy": {
                    ((KafkaComponent)component).setPollExceptionStrategy((PollExceptionStrategy)value);
                    return true;
                }
                case "subscribeConsumerBackoffInterval": {
                    ((KafkaComponent)component).setSubscribeConsumerBackoffInterval(((Long)value).longValue());
                    return true;
                }
                case "subscribeConsumerBackoffMaxAttempts": {
                    ((KafkaComponent)component).setSubscribeConsumerBackoffMaxAttempts(((Integer)value).intValue());
                    return true;
                }
                case "batchWithIndividualHeaders": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setBatchWithIndividualHeaders(((Boolean)value).booleanValue());
                    return true;
                }
                case "bufferMemorySize": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setBufferMemorySize((Integer)value);
                    return true;
                }
                case "compressionCodec": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setCompressionCodec((String)value);
                    return true;
                }
                case "connectionMaxIdleMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setConnectionMaxIdleMs((Integer)value);
                    return true;
                }
                case "deliveryTimeoutMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setDeliveryTimeoutMs((Integer)value);
                    return true;
                }
                case "enableIdempotence": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setEnableIdempotence(((Boolean)value).booleanValue());
                    return true;
                }
                case "headerSerializer": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setHeaderSerializer((KafkaHeaderSerializer)value);
                    return true;
                }
                case "key": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKey((String)value);
                    return true;
                }
                case "keySerializer": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKeySerializer((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((KafkaComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "lingerMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setLingerMs((Integer)value);
                    return true;
                }
                case "maxBlockMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMaxBlockMs((Integer)value);
                    return true;
                }
                case "maxInFlightRequest": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMaxInFlightRequest((Integer)value);
                    return true;
                }
                case "maxRequestSize": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMaxRequestSize((Integer)value);
                    return true;
                }
                case "metadataMaxAgeMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMetadataMaxAgeMs((Integer)value);
                    return true;
                }
                case "metricReporters": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMetricReporters((String)value);
                    return true;
                }
                case "metricsSampleWindowMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setMetricsSampleWindowMs((Integer)value);
                    return true;
                }
                case "noOfMetricsSample": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setNoOfMetricsSample((Integer)value);
                    return true;
                }
                case "partitioner": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setPartitioner((String)value);
                    return true;
                }
                case "partitionerIgnoreKeys": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setPartitionerIgnoreKeys(((Boolean)value).booleanValue());
                    return true;
                }
                case "partitionKey": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setPartitionKey((Integer)value);
                    return true;
                }
                case "producerBatchSize": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setProducerBatchSize((Integer)value);
                    return true;
                }
                case "queueBufferingMaxMessages": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setQueueBufferingMaxMessages((Integer)value);
                    return true;
                }
                case "receiveBufferBytes": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setReceiveBufferBytes((Integer)value);
                    return true;
                }
                case "reconnectBackoffMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setReconnectBackoffMs((Integer)value);
                    return true;
                }
                case "recordMetadata": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setRecordMetadata(((Boolean)value).booleanValue());
                    return true;
                }
                case "requestRequiredAcks": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setRequestRequiredAcks((String)value);
                    return true;
                }
                case "requestTimeoutMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setRequestTimeoutMs((Integer)value);
                    return true;
                }
                case "retries": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setRetries((Integer)value);
                    return true;
                }
                case "retryBackoffMs": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setRetryBackoffMs((Integer)value);
                    return true;
                }
                case "sendBufferBytes": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSendBufferBytes((Integer)value);
                    return true;
                }
                case "useIterator": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setUseIterator(((Boolean)value).booleanValue());
                    return true;
                }
                case "valueSerializer": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setValueSerializer((String)value);
                    return true;
                }
                case "workerPool": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setWorkerPool((ExecutorService)value);
                    return true;
                }
                case "workerPoolCoreSize": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setWorkerPoolCoreSize((Integer)value);
                    return true;
                }
                case "workerPoolMaxSize": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setWorkerPoolMaxSize((Integer)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((KafkaComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "kafkaClientFactory": {
                    ((KafkaComponent)component).setKafkaClientFactory((KafkaClientFactory)value);
                    return true;
                }
                case "synchronous": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSynchronous(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckConsumerEnabled": {
                    ((KafkaComponent)component).setHealthCheckConsumerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "healthCheckProducerEnabled": {
                    ((KafkaComponent)component).setHealthCheckProducerEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "interceptorClasses": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setInterceptorClasses((String)value);
                    return true;
                }
                case "schemaRegistryURL": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSchemaRegistryURL((String)value);
                    return true;
                }
                case "kerberosBeforeReloginMinTime": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKerberosBeforeReloginMinTime((Integer)value);
                    return true;
                }
                case "kerberosConfigLocation": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKerberosConfigLocation((String)value);
                    return true;
                }
                case "kerberosInitCmd": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKerberosInitCmd((String)value);
                    return true;
                }
                case "kerberosPrincipalToLocalRules": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKerberosPrincipalToLocalRules((String)value);
                    return true;
                }
                case "kerberosRenewJitter": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKerberosRenewJitter((Double)value);
                    return true;
                }
                case "kerberosRenewWindowFactor": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setKerberosRenewWindowFactor((Double)value);
                    return true;
                }
                case "saslJaasConfig": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSaslJaasConfig((String)value);
                    return true;
                }
                case "saslKerberosServiceName": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSaslKerberosServiceName((String)value);
                    return true;
                }
                case "saslMechanism": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSaslMechanism((String)value);
                    return true;
                }
                case "securityProtocol": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSecurityProtocol((String)value);
                    return true;
                }
                case "sslCipherSuites": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslCipherSuites((String)value);
                    return true;
                }
                case "sslContextParameters": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslContextParameters((SSLContextParameters)value);
                    return true;
                }
                case "sslEnabledProtocols": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslEnabledProtocols((String)value);
                    return true;
                }
                case "sslEndpointAlgorithm": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslEndpointAlgorithm((String)value);
                    return true;
                }
                case "sslKeymanagerAlgorithm": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslKeymanagerAlgorithm((String)value);
                    return true;
                }
                case "sslKeyPassword": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslKeyPassword((String)value);
                    return true;
                }
                case "sslKeystoreLocation": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslKeystoreLocation((String)value);
                    return true;
                }
                case "sslKeystorePassword": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslKeystorePassword((String)value);
                    return true;
                }
                case "sslKeystoreType": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslKeystoreType((String)value);
                    return true;
                }
                case "sslProtocol": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslProtocol((String)value);
                    return true;
                }
                case "sslProvider": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslProvider((String)value);
                    return true;
                }
                case "sslTrustmanagerAlgorithm": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslTrustmanagerAlgorithm((String)value);
                    return true;
                }
                case "sslTruststoreLocation": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslTruststoreLocation((String)value);
                    return true;
                }
                case "sslTruststorePassword": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslTruststorePassword((String)value);
                    return true;
                }
                case "sslTruststoreType": {
                    this.getOrCreateConfiguration((KafkaComponent)component).setSslTruststoreType((String)value);
                    return true;
                }
                case "useGlobalSslContextParameters": {
                    ((KafkaComponent)component).setUseGlobalSslContextParameters(((Boolean)value).booleanValue());
                    return true;
                }
            }
            return false;
        }
    }

    public static interface KafkaComponentBuilder
    extends ComponentBuilder<KafkaComponent> {
        default public KafkaComponentBuilder additionalProperties(Map<String, Object> additionalProperties) {
            this.doSetProperty("additionalProperties", additionalProperties);
            return this;
        }

        default public KafkaComponentBuilder brokers(String brokers) {
            this.doSetProperty("brokers", brokers);
            return this;
        }

        default public KafkaComponentBuilder clientId(String clientId) {
            this.doSetProperty("clientId", clientId);
            return this;
        }

        default public KafkaComponentBuilder configuration(KafkaConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public KafkaComponentBuilder headerFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
            this.doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }

        default public KafkaComponentBuilder reconnectBackoffMaxMs(Integer reconnectBackoffMaxMs) {
            this.doSetProperty("reconnectBackoffMaxMs", reconnectBackoffMaxMs);
            return this;
        }

        default public KafkaComponentBuilder shutdownTimeout(int shutdownTimeout) {
            this.doSetProperty("shutdownTimeout", shutdownTimeout);
            return this;
        }

        default public KafkaComponentBuilder allowManualCommit(boolean allowManualCommit) {
            this.doSetProperty("allowManualCommit", allowManualCommit);
            return this;
        }

        default public KafkaComponentBuilder autoCommitEnable(boolean autoCommitEnable) {
            this.doSetProperty("autoCommitEnable", autoCommitEnable);
            return this;
        }

        default public KafkaComponentBuilder autoCommitIntervalMs(Integer autoCommitIntervalMs) {
            this.doSetProperty("autoCommitIntervalMs", autoCommitIntervalMs);
            return this;
        }

        default public KafkaComponentBuilder autoOffsetReset(String autoOffsetReset) {
            this.doSetProperty("autoOffsetReset", autoOffsetReset);
            return this;
        }

        default public KafkaComponentBuilder batching(boolean batching) {
            this.doSetProperty("batching", batching);
            return this;
        }

        default public KafkaComponentBuilder breakOnFirstError(boolean breakOnFirstError) {
            this.doSetProperty("breakOnFirstError", breakOnFirstError);
            return this;
        }

        default public KafkaComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public KafkaComponentBuilder checkCrcs(Boolean checkCrcs) {
            this.doSetProperty("checkCrcs", checkCrcs);
            return this;
        }

        default public KafkaComponentBuilder commitTimeoutMs(Long commitTimeoutMs) {
            this.doSetProperty("commitTimeoutMs", commitTimeoutMs);
            return this;
        }

        default public KafkaComponentBuilder consumerRequestTimeoutMs(Integer consumerRequestTimeoutMs) {
            this.doSetProperty("consumerRequestTimeoutMs", consumerRequestTimeoutMs);
            return this;
        }

        default public KafkaComponentBuilder consumersCount(int consumersCount) {
            this.doSetProperty("consumersCount", consumersCount);
            return this;
        }

        default public KafkaComponentBuilder fetchMaxBytes(Integer fetchMaxBytes) {
            this.doSetProperty("fetchMaxBytes", fetchMaxBytes);
            return this;
        }

        default public KafkaComponentBuilder fetchMinBytes(Integer fetchMinBytes) {
            this.doSetProperty("fetchMinBytes", fetchMinBytes);
            return this;
        }

        default public KafkaComponentBuilder fetchWaitMaxMs(Integer fetchWaitMaxMs) {
            this.doSetProperty("fetchWaitMaxMs", fetchWaitMaxMs);
            return this;
        }

        default public KafkaComponentBuilder groupId(String groupId) {
            this.doSetProperty("groupId", groupId);
            return this;
        }

        default public KafkaComponentBuilder groupInstanceId(String groupInstanceId) {
            this.doSetProperty("groupInstanceId", groupInstanceId);
            return this;
        }

        default public KafkaComponentBuilder headerDeserializer(KafkaHeaderDeserializer headerDeserializer) {
            this.doSetProperty("headerDeserializer", headerDeserializer);
            return this;
        }

        default public KafkaComponentBuilder heartbeatIntervalMs(Integer heartbeatIntervalMs) {
            this.doSetProperty("heartbeatIntervalMs", heartbeatIntervalMs);
            return this;
        }

        default public KafkaComponentBuilder keyDeserializer(String keyDeserializer) {
            this.doSetProperty("keyDeserializer", keyDeserializer);
            return this;
        }

        default public KafkaComponentBuilder maxPartitionFetchBytes(Integer maxPartitionFetchBytes) {
            this.doSetProperty("maxPartitionFetchBytes", maxPartitionFetchBytes);
            return this;
        }

        default public KafkaComponentBuilder maxPollIntervalMs(Integer maxPollIntervalMs) {
            this.doSetProperty("maxPollIntervalMs", maxPollIntervalMs);
            return this;
        }

        default public KafkaComponentBuilder maxPollRecords(Integer maxPollRecords) {
            this.doSetProperty("maxPollRecords", maxPollRecords);
            return this;
        }

        default public KafkaComponentBuilder offsetRepository(StateRepository<String, String> offsetRepository) {
            this.doSetProperty("offsetRepository", offsetRepository);
            return this;
        }

        default public KafkaComponentBuilder partitionAssignor(String partitionAssignor) {
            this.doSetProperty("partitionAssignor", partitionAssignor);
            return this;
        }

        default public KafkaComponentBuilder pollOnError(PollOnError pollOnError) {
            this.doSetProperty("pollOnError", pollOnError);
            return this;
        }

        default public KafkaComponentBuilder pollTimeoutMs(Long pollTimeoutMs) {
            this.doSetProperty("pollTimeoutMs", pollTimeoutMs);
            return this;
        }

        default public KafkaComponentBuilder preValidateHostAndPort(boolean preValidateHostAndPort) {
            this.doSetProperty("preValidateHostAndPort", preValidateHostAndPort);
            return this;
        }

        default public KafkaComponentBuilder seekTo(SeekPolicy seekTo) {
            this.doSetProperty("seekTo", seekTo);
            return this;
        }

        default public KafkaComponentBuilder sessionTimeoutMs(Integer sessionTimeoutMs) {
            this.doSetProperty("sessionTimeoutMs", sessionTimeoutMs);
            return this;
        }

        default public KafkaComponentBuilder specificAvroReader(boolean specificAvroReader) {
            this.doSetProperty("specificAvroReader", specificAvroReader);
            return this;
        }

        default public KafkaComponentBuilder topicIsPattern(boolean topicIsPattern) {
            this.doSetProperty("topicIsPattern", topicIsPattern);
            return this;
        }

        default public KafkaComponentBuilder valueDeserializer(String valueDeserializer) {
            this.doSetProperty("valueDeserializer", valueDeserializer);
            return this;
        }

        default public KafkaComponentBuilder createConsumerBackoffInterval(long createConsumerBackoffInterval) {
            this.doSetProperty("createConsumerBackoffInterval", createConsumerBackoffInterval);
            return this;
        }

        default public KafkaComponentBuilder createConsumerBackoffMaxAttempts(int createConsumerBackoffMaxAttempts) {
            this.doSetProperty("createConsumerBackoffMaxAttempts", createConsumerBackoffMaxAttempts);
            return this;
        }

        default public KafkaComponentBuilder isolationLevel(String isolationLevel) {
            this.doSetProperty("isolationLevel", isolationLevel);
            return this;
        }

        default public KafkaComponentBuilder kafkaManualCommitFactory(KafkaManualCommitFactory kafkaManualCommitFactory) {
            this.doSetProperty("kafkaManualCommitFactory", kafkaManualCommitFactory);
            return this;
        }

        default public KafkaComponentBuilder pollExceptionStrategy(PollExceptionStrategy pollExceptionStrategy) {
            this.doSetProperty("pollExceptionStrategy", pollExceptionStrategy);
            return this;
        }

        default public KafkaComponentBuilder subscribeConsumerBackoffInterval(long subscribeConsumerBackoffInterval) {
            this.doSetProperty("subscribeConsumerBackoffInterval", subscribeConsumerBackoffInterval);
            return this;
        }

        default public KafkaComponentBuilder subscribeConsumerBackoffMaxAttempts(int subscribeConsumerBackoffMaxAttempts) {
            this.doSetProperty("subscribeConsumerBackoffMaxAttempts", subscribeConsumerBackoffMaxAttempts);
            return this;
        }

        default public KafkaComponentBuilder batchWithIndividualHeaders(boolean batchWithIndividualHeaders) {
            this.doSetProperty("batchWithIndividualHeaders", batchWithIndividualHeaders);
            return this;
        }

        default public KafkaComponentBuilder bufferMemorySize(Integer bufferMemorySize) {
            this.doSetProperty("bufferMemorySize", bufferMemorySize);
            return this;
        }

        default public KafkaComponentBuilder compressionCodec(String compressionCodec) {
            this.doSetProperty("compressionCodec", compressionCodec);
            return this;
        }

        default public KafkaComponentBuilder connectionMaxIdleMs(Integer connectionMaxIdleMs) {
            this.doSetProperty("connectionMaxIdleMs", connectionMaxIdleMs);
            return this;
        }

        default public KafkaComponentBuilder deliveryTimeoutMs(Integer deliveryTimeoutMs) {
            this.doSetProperty("deliveryTimeoutMs", deliveryTimeoutMs);
            return this;
        }

        default public KafkaComponentBuilder enableIdempotence(boolean enableIdempotence) {
            this.doSetProperty("enableIdempotence", enableIdempotence);
            return this;
        }

        default public KafkaComponentBuilder headerSerializer(KafkaHeaderSerializer headerSerializer) {
            this.doSetProperty("headerSerializer", headerSerializer);
            return this;
        }

        default public KafkaComponentBuilder key(String key) {
            this.doSetProperty("key", key);
            return this;
        }

        default public KafkaComponentBuilder keySerializer(String keySerializer) {
            this.doSetProperty("keySerializer", keySerializer);
            return this;
        }

        default public KafkaComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public KafkaComponentBuilder lingerMs(Integer lingerMs) {
            this.doSetProperty("lingerMs", lingerMs);
            return this;
        }

        default public KafkaComponentBuilder maxBlockMs(Integer maxBlockMs) {
            this.doSetProperty("maxBlockMs", maxBlockMs);
            return this;
        }

        default public KafkaComponentBuilder maxInFlightRequest(Integer maxInFlightRequest) {
            this.doSetProperty("maxInFlightRequest", maxInFlightRequest);
            return this;
        }

        default public KafkaComponentBuilder maxRequestSize(Integer maxRequestSize) {
            this.doSetProperty("maxRequestSize", maxRequestSize);
            return this;
        }

        default public KafkaComponentBuilder metadataMaxAgeMs(Integer metadataMaxAgeMs) {
            this.doSetProperty("metadataMaxAgeMs", metadataMaxAgeMs);
            return this;
        }

        default public KafkaComponentBuilder metricReporters(String metricReporters) {
            this.doSetProperty("metricReporters", metricReporters);
            return this;
        }

        default public KafkaComponentBuilder metricsSampleWindowMs(Integer metricsSampleWindowMs) {
            this.doSetProperty("metricsSampleWindowMs", metricsSampleWindowMs);
            return this;
        }

        default public KafkaComponentBuilder noOfMetricsSample(Integer noOfMetricsSample) {
            this.doSetProperty("noOfMetricsSample", noOfMetricsSample);
            return this;
        }

        default public KafkaComponentBuilder partitioner(String partitioner) {
            this.doSetProperty("partitioner", partitioner);
            return this;
        }

        default public KafkaComponentBuilder partitionerIgnoreKeys(boolean partitionerIgnoreKeys) {
            this.doSetProperty("partitionerIgnoreKeys", partitionerIgnoreKeys);
            return this;
        }

        default public KafkaComponentBuilder partitionKey(Integer partitionKey) {
            this.doSetProperty("partitionKey", partitionKey);
            return this;
        }

        default public KafkaComponentBuilder producerBatchSize(Integer producerBatchSize) {
            this.doSetProperty("producerBatchSize", producerBatchSize);
            return this;
        }

        default public KafkaComponentBuilder queueBufferingMaxMessages(Integer queueBufferingMaxMessages) {
            this.doSetProperty("queueBufferingMaxMessages", queueBufferingMaxMessages);
            return this;
        }

        default public KafkaComponentBuilder receiveBufferBytes(Integer receiveBufferBytes) {
            this.doSetProperty("receiveBufferBytes", receiveBufferBytes);
            return this;
        }

        default public KafkaComponentBuilder reconnectBackoffMs(Integer reconnectBackoffMs) {
            this.doSetProperty("reconnectBackoffMs", reconnectBackoffMs);
            return this;
        }

        default public KafkaComponentBuilder recordMetadata(boolean recordMetadata) {
            this.doSetProperty("recordMetadata", recordMetadata);
            return this;
        }

        default public KafkaComponentBuilder requestRequiredAcks(String requestRequiredAcks) {
            this.doSetProperty("requestRequiredAcks", requestRequiredAcks);
            return this;
        }

        default public KafkaComponentBuilder requestTimeoutMs(Integer requestTimeoutMs) {
            this.doSetProperty("requestTimeoutMs", requestTimeoutMs);
            return this;
        }

        default public KafkaComponentBuilder retries(Integer retries) {
            this.doSetProperty("retries", retries);
            return this;
        }

        default public KafkaComponentBuilder retryBackoffMs(Integer retryBackoffMs) {
            this.doSetProperty("retryBackoffMs", retryBackoffMs);
            return this;
        }

        default public KafkaComponentBuilder sendBufferBytes(Integer sendBufferBytes) {
            this.doSetProperty("sendBufferBytes", sendBufferBytes);
            return this;
        }

        default public KafkaComponentBuilder useIterator(boolean useIterator) {
            this.doSetProperty("useIterator", useIterator);
            return this;
        }

        default public KafkaComponentBuilder valueSerializer(String valueSerializer) {
            this.doSetProperty("valueSerializer", valueSerializer);
            return this;
        }

        default public KafkaComponentBuilder workerPool(ExecutorService workerPool) {
            this.doSetProperty("workerPool", workerPool);
            return this;
        }

        default public KafkaComponentBuilder workerPoolCoreSize(Integer workerPoolCoreSize) {
            this.doSetProperty("workerPoolCoreSize", workerPoolCoreSize);
            return this;
        }

        default public KafkaComponentBuilder workerPoolMaxSize(Integer workerPoolMaxSize) {
            this.doSetProperty("workerPoolMaxSize", workerPoolMaxSize);
            return this;
        }

        default public KafkaComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public KafkaComponentBuilder kafkaClientFactory(KafkaClientFactory kafkaClientFactory) {
            this.doSetProperty("kafkaClientFactory", kafkaClientFactory);
            return this;
        }

        default public KafkaComponentBuilder synchronous(boolean synchronous) {
            this.doSetProperty("synchronous", synchronous);
            return this;
        }

        default public KafkaComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            this.doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }

        default public KafkaComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            this.doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }

        default public KafkaComponentBuilder interceptorClasses(String interceptorClasses) {
            this.doSetProperty("interceptorClasses", interceptorClasses);
            return this;
        }

        default public KafkaComponentBuilder schemaRegistryURL(String schemaRegistryURL) {
            this.doSetProperty("schemaRegistryURL", schemaRegistryURL);
            return this;
        }

        default public KafkaComponentBuilder kerberosBeforeReloginMinTime(Integer kerberosBeforeReloginMinTime) {
            this.doSetProperty("kerberosBeforeReloginMinTime", kerberosBeforeReloginMinTime);
            return this;
        }

        default public KafkaComponentBuilder kerberosConfigLocation(String kerberosConfigLocation) {
            this.doSetProperty("kerberosConfigLocation", kerberosConfigLocation);
            return this;
        }

        default public KafkaComponentBuilder kerberosInitCmd(String kerberosInitCmd) {
            this.doSetProperty("kerberosInitCmd", kerberosInitCmd);
            return this;
        }

        default public KafkaComponentBuilder kerberosPrincipalToLocalRules(String kerberosPrincipalToLocalRules) {
            this.doSetProperty("kerberosPrincipalToLocalRules", kerberosPrincipalToLocalRules);
            return this;
        }

        default public KafkaComponentBuilder kerberosRenewJitter(Double kerberosRenewJitter) {
            this.doSetProperty("kerberosRenewJitter", kerberosRenewJitter);
            return this;
        }

        default public KafkaComponentBuilder kerberosRenewWindowFactor(Double kerberosRenewWindowFactor) {
            this.doSetProperty("kerberosRenewWindowFactor", kerberosRenewWindowFactor);
            return this;
        }

        default public KafkaComponentBuilder saslJaasConfig(String saslJaasConfig) {
            this.doSetProperty("saslJaasConfig", saslJaasConfig);
            return this;
        }

        default public KafkaComponentBuilder saslKerberosServiceName(String saslKerberosServiceName) {
            this.doSetProperty("saslKerberosServiceName", saslKerberosServiceName);
            return this;
        }

        default public KafkaComponentBuilder saslMechanism(String saslMechanism) {
            this.doSetProperty("saslMechanism", saslMechanism);
            return this;
        }

        default public KafkaComponentBuilder securityProtocol(String securityProtocol) {
            this.doSetProperty("securityProtocol", securityProtocol);
            return this;
        }

        default public KafkaComponentBuilder sslCipherSuites(String sslCipherSuites) {
            this.doSetProperty("sslCipherSuites", sslCipherSuites);
            return this;
        }

        default public KafkaComponentBuilder sslContextParameters(SSLContextParameters sslContextParameters) {
            this.doSetProperty("sslContextParameters", sslContextParameters);
            return this;
        }

        default public KafkaComponentBuilder sslEnabledProtocols(String sslEnabledProtocols) {
            this.doSetProperty("sslEnabledProtocols", sslEnabledProtocols);
            return this;
        }

        default public KafkaComponentBuilder sslEndpointAlgorithm(String sslEndpointAlgorithm) {
            this.doSetProperty("sslEndpointAlgorithm", sslEndpointAlgorithm);
            return this;
        }

        default public KafkaComponentBuilder sslKeymanagerAlgorithm(String sslKeymanagerAlgorithm) {
            this.doSetProperty("sslKeymanagerAlgorithm", sslKeymanagerAlgorithm);
            return this;
        }

        default public KafkaComponentBuilder sslKeyPassword(String sslKeyPassword) {
            this.doSetProperty("sslKeyPassword", sslKeyPassword);
            return this;
        }

        default public KafkaComponentBuilder sslKeystoreLocation(String sslKeystoreLocation) {
            this.doSetProperty("sslKeystoreLocation", sslKeystoreLocation);
            return this;
        }

        default public KafkaComponentBuilder sslKeystorePassword(String sslKeystorePassword) {
            this.doSetProperty("sslKeystorePassword", sslKeystorePassword);
            return this;
        }

        default public KafkaComponentBuilder sslKeystoreType(String sslKeystoreType) {
            this.doSetProperty("sslKeystoreType", sslKeystoreType);
            return this;
        }

        default public KafkaComponentBuilder sslProtocol(String sslProtocol) {
            this.doSetProperty("sslProtocol", sslProtocol);
            return this;
        }

        default public KafkaComponentBuilder sslProvider(String sslProvider) {
            this.doSetProperty("sslProvider", sslProvider);
            return this;
        }

        default public KafkaComponentBuilder sslTrustmanagerAlgorithm(String sslTrustmanagerAlgorithm) {
            this.doSetProperty("sslTrustmanagerAlgorithm", sslTrustmanagerAlgorithm);
            return this;
        }

        default public KafkaComponentBuilder sslTruststoreLocation(String sslTruststoreLocation) {
            this.doSetProperty("sslTruststoreLocation", sslTruststoreLocation);
            return this;
        }

        default public KafkaComponentBuilder sslTruststorePassword(String sslTruststorePassword) {
            this.doSetProperty("sslTruststorePassword", sslTruststorePassword);
            return this;
        }

        default public KafkaComponentBuilder sslTruststoreType(String sslTruststoreType) {
            this.doSetProperty("sslTruststoreType", sslTruststoreType);
            return this;
        }

        default public KafkaComponentBuilder useGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
            this.doSetProperty("useGlobalSslContextParameters", useGlobalSslContextParameters);
            return this;
        }
    }
}

