/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.component.dsl;

import com.azure.cosmos.ConsistencyLevel;
import com.azure.cosmos.CosmosAsyncClient;
import com.azure.cosmos.models.ChangeFeedProcessorOptions;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.IndexingPolicy;
import com.azure.cosmos.models.ThroughputProperties;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.azure.cosmosdb.CosmosDbComponent;
import org.apache.camel.component.azure.cosmosdb.CosmosDbConfiguration;
import org.apache.camel.component.azure.cosmosdb.CosmosDbOperationsDefinition;
import org.apache.camel.component.azure.cosmosdb.CredentialType;

public interface AzureCosmosdbComponentBuilderFactory {
    public static AzureCosmosdbComponentBuilder azureCosmosdb() {
        return new AzureCosmosdbComponentBuilderImpl();
    }

    public static class AzureCosmosdbComponentBuilderImpl
    extends AbstractComponentBuilder<CosmosDbComponent>
    implements AzureCosmosdbComponentBuilder {
        @Override
        protected CosmosDbComponent buildConcreteComponent() {
            return new CosmosDbComponent();
        }

        private CosmosDbConfiguration getOrCreateConfiguration(CosmosDbComponent component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new CosmosDbConfiguration());
            }
            return component.getConfiguration();
        }

        @Override
        protected boolean setPropertyOnComponent(Component component, String name, Object value) {
            switch (name) {
                case "clientTelemetryEnabled": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setClientTelemetryEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "configuration": {
                    ((CosmosDbComponent)component).setConfiguration((CosmosDbConfiguration)value);
                    return true;
                }
                case "connectionSharingAcrossClientsEnabled": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setConnectionSharingAcrossClientsEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "consistencyLevel": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setConsistencyLevel((ConsistencyLevel)value);
                    return true;
                }
                case "containerPartitionKeyPath": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setContainerPartitionKeyPath((String)value);
                    return true;
                }
                case "contentResponseOnWriteEnabled": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setContentResponseOnWriteEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "cosmosAsyncClient": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setCosmosAsyncClient((CosmosAsyncClient)value);
                    return true;
                }
                case "createContainerIfNotExists": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setCreateContainerIfNotExists(((Boolean)value).booleanValue());
                    return true;
                }
                case "createDatabaseIfNotExists": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setCreateDatabaseIfNotExists(((Boolean)value).booleanValue());
                    return true;
                }
                case "databaseEndpoint": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setDatabaseEndpoint((String)value);
                    return true;
                }
                case "multipleWriteRegionsEnabled": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setMultipleWriteRegionsEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "preferredRegions": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setPreferredRegions((String)value);
                    return true;
                }
                case "readRequestsFallbackEnabled": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setReadRequestsFallbackEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "throughputProperties": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setThroughputProperties((ThroughputProperties)value);
                    return true;
                }
                case "bridgeErrorHandler": {
                    ((CosmosDbComponent)component).setBridgeErrorHandler(((Boolean)value).booleanValue());
                    return true;
                }
                case "changeFeedProcessorOptions": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setChangeFeedProcessorOptions((ChangeFeedProcessorOptions)value);
                    return true;
                }
                case "createLeaseContainerIfNotExists": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setCreateLeaseContainerIfNotExists(((Boolean)value).booleanValue());
                    return true;
                }
                case "createLeaseDatabaseIfNotExists": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setCreateLeaseDatabaseIfNotExists(((Boolean)value).booleanValue());
                    return true;
                }
                case "hostName": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setHostName((String)value);
                    return true;
                }
                case "leaseContainerName": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setLeaseContainerName((String)value);
                    return true;
                }
                case "leaseDatabaseName": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setLeaseDatabaseName((String)value);
                    return true;
                }
                case "itemId": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setItemId((String)value);
                    return true;
                }
                case "itemPartitionKey": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setItemPartitionKey((String)value);
                    return true;
                }
                case "lazyStartProducer": {
                    ((CosmosDbComponent)component).setLazyStartProducer(((Boolean)value).booleanValue());
                    return true;
                }
                case "operation": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setOperation((CosmosDbOperationsDefinition)value);
                    return true;
                }
                case "query": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setQuery((String)value);
                    return true;
                }
                case "queryRequestOptions": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setQueryRequestOptions((CosmosQueryRequestOptions)value);
                    return true;
                }
                case "indexingPolicy": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setIndexingPolicy((IndexingPolicy)value);
                    return true;
                }
                case "autowiredEnabled": {
                    ((CosmosDbComponent)component).setAutowiredEnabled(((Boolean)value).booleanValue());
                    return true;
                }
                case "accountKey": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setAccountKey((String)value);
                    return true;
                }
                case "credentialType": {
                    this.getOrCreateConfiguration((CosmosDbComponent)component).setCredentialType((CredentialType)value);
                    return true;
                }
            }
            return false;
        }
    }

    public static interface AzureCosmosdbComponentBuilder
    extends ComponentBuilder<CosmosDbComponent> {
        default public AzureCosmosdbComponentBuilder clientTelemetryEnabled(boolean clientTelemetryEnabled) {
            this.doSetProperty("clientTelemetryEnabled", clientTelemetryEnabled);
            return this;
        }

        default public AzureCosmosdbComponentBuilder configuration(CosmosDbConfiguration configuration) {
            this.doSetProperty("configuration", configuration);
            return this;
        }

        default public AzureCosmosdbComponentBuilder connectionSharingAcrossClientsEnabled(boolean connectionSharingAcrossClientsEnabled) {
            this.doSetProperty("connectionSharingAcrossClientsEnabled", connectionSharingAcrossClientsEnabled);
            return this;
        }

        default public AzureCosmosdbComponentBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            this.doSetProperty("consistencyLevel", consistencyLevel);
            return this;
        }

        default public AzureCosmosdbComponentBuilder containerPartitionKeyPath(String containerPartitionKeyPath) {
            this.doSetProperty("containerPartitionKeyPath", containerPartitionKeyPath);
            return this;
        }

        default public AzureCosmosdbComponentBuilder contentResponseOnWriteEnabled(boolean contentResponseOnWriteEnabled) {
            this.doSetProperty("contentResponseOnWriteEnabled", contentResponseOnWriteEnabled);
            return this;
        }

        default public AzureCosmosdbComponentBuilder cosmosAsyncClient(CosmosAsyncClient cosmosAsyncClient) {
            this.doSetProperty("cosmosAsyncClient", cosmosAsyncClient);
            return this;
        }

        default public AzureCosmosdbComponentBuilder createContainerIfNotExists(boolean createContainerIfNotExists) {
            this.doSetProperty("createContainerIfNotExists", createContainerIfNotExists);
            return this;
        }

        default public AzureCosmosdbComponentBuilder createDatabaseIfNotExists(boolean createDatabaseIfNotExists) {
            this.doSetProperty("createDatabaseIfNotExists", createDatabaseIfNotExists);
            return this;
        }

        default public AzureCosmosdbComponentBuilder databaseEndpoint(String databaseEndpoint) {
            this.doSetProperty("databaseEndpoint", databaseEndpoint);
            return this;
        }

        default public AzureCosmosdbComponentBuilder multipleWriteRegionsEnabled(boolean multipleWriteRegionsEnabled) {
            this.doSetProperty("multipleWriteRegionsEnabled", multipleWriteRegionsEnabled);
            return this;
        }

        default public AzureCosmosdbComponentBuilder preferredRegions(String preferredRegions) {
            this.doSetProperty("preferredRegions", preferredRegions);
            return this;
        }

        default public AzureCosmosdbComponentBuilder readRequestsFallbackEnabled(boolean readRequestsFallbackEnabled) {
            this.doSetProperty("readRequestsFallbackEnabled", readRequestsFallbackEnabled);
            return this;
        }

        default public AzureCosmosdbComponentBuilder throughputProperties(ThroughputProperties throughputProperties) {
            this.doSetProperty("throughputProperties", throughputProperties);
            return this;
        }

        default public AzureCosmosdbComponentBuilder bridgeErrorHandler(boolean bridgeErrorHandler) {
            this.doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }

        default public AzureCosmosdbComponentBuilder changeFeedProcessorOptions(ChangeFeedProcessorOptions changeFeedProcessorOptions) {
            this.doSetProperty("changeFeedProcessorOptions", changeFeedProcessorOptions);
            return this;
        }

        default public AzureCosmosdbComponentBuilder createLeaseContainerIfNotExists(boolean createLeaseContainerIfNotExists) {
            this.doSetProperty("createLeaseContainerIfNotExists", createLeaseContainerIfNotExists);
            return this;
        }

        default public AzureCosmosdbComponentBuilder createLeaseDatabaseIfNotExists(boolean createLeaseDatabaseIfNotExists) {
            this.doSetProperty("createLeaseDatabaseIfNotExists", createLeaseDatabaseIfNotExists);
            return this;
        }

        default public AzureCosmosdbComponentBuilder hostName(String hostName) {
            this.doSetProperty("hostName", hostName);
            return this;
        }

        default public AzureCosmosdbComponentBuilder leaseContainerName(String leaseContainerName) {
            this.doSetProperty("leaseContainerName", leaseContainerName);
            return this;
        }

        default public AzureCosmosdbComponentBuilder leaseDatabaseName(String leaseDatabaseName) {
            this.doSetProperty("leaseDatabaseName", leaseDatabaseName);
            return this;
        }

        default public AzureCosmosdbComponentBuilder itemId(String itemId) {
            this.doSetProperty("itemId", itemId);
            return this;
        }

        default public AzureCosmosdbComponentBuilder itemPartitionKey(String itemPartitionKey) {
            this.doSetProperty("itemPartitionKey", itemPartitionKey);
            return this;
        }

        default public AzureCosmosdbComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            this.doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }

        default public AzureCosmosdbComponentBuilder operation(CosmosDbOperationsDefinition operation) {
            this.doSetProperty("operation", operation);
            return this;
        }

        default public AzureCosmosdbComponentBuilder query(String query) {
            this.doSetProperty("query", query);
            return this;
        }

        default public AzureCosmosdbComponentBuilder queryRequestOptions(CosmosQueryRequestOptions queryRequestOptions) {
            this.doSetProperty("queryRequestOptions", queryRequestOptions);
            return this;
        }

        default public AzureCosmosdbComponentBuilder indexingPolicy(IndexingPolicy indexingPolicy) {
            this.doSetProperty("indexingPolicy", indexingPolicy);
            return this;
        }

        default public AzureCosmosdbComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            this.doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }

        default public AzureCosmosdbComponentBuilder accountKey(String accountKey) {
            this.doSetProperty("accountKey", accountKey);
            return this;
        }

        default public AzureCosmosdbComponentBuilder credentialType(CredentialType credentialType) {
            this.doSetProperty("credentialType", credentialType);
            return this;
        }
    }
}

