/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.console.DevConsole;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.annotations.DevConsole;

@DevConsole(value="health")
public class HealthDevConsole
extends AbstractDevConsole {
    public HealthDevConsole() {
        super("camel", "health", "Health Check", "Health Check Status");
    }

    @Override
    protected Object doCall(DevConsole.MediaType mediaType, Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        Collection results = HealthCheckHelper.invoke((CamelContext)this.getCamelContext());
        boolean up = results.stream().allMatch(h -> HealthCheck.State.UP.equals((Object)h.getState()));
        sb.append(String.format("Health Check Status: %s", up ? "UP" : "DOWN"));
        sb.append("\n");
        results.forEach(res -> {
            boolean ok = res.getState().equals((Object)HealthCheck.State.UP);
            if (ok) {
                sb.append(String.format("\n    %s: %s", res.getCheck().getId(), res.getState()));
            } else {
                String msg = res.getMessage().orElse("");
                sb.append(String.format("\n    %s: %s (%s)", res.getCheck().getId(), res.getState(), msg));
                Throwable cause = res.getError().orElse(null);
                if (cause != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    cause.printStackTrace(pw);
                    sb.append(pw);
                    sb.append("\n\n");
                }
            }
        });
        return sb.toString();
    }
}

