/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.console;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Map;
import org.apache.camel.console.DevConsole;
import org.apache.camel.impl.console.AbstractDevConsole;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.DevConsole;
import org.apache.camel.util.TimeUtils;

@DevConsole(value="jvm")
@Configurer(bootstrap=true)
public class JvmDevConsole
extends AbstractDevConsole {
    @Metadata(defaultValue="true", description="Show classpath information")
    private boolean showClasspath = true;

    public JvmDevConsole() {
        super("jvm", "jvm", "JVM", "Displays JVM information");
    }

    public boolean isShowClasspath() {
        return this.showClasspath;
    }

    public void setShowClasspath(boolean showClasspath) {
        this.showClasspath = showClasspath;
    }

    @Override
    protected Object doCall(DevConsole.MediaType mediaType, Map<String, Object> options) {
        StringBuilder sb = new StringBuilder();
        RuntimeMXBean mb = ManagementFactory.getRuntimeMXBean();
        if (mb != null) {
            String cp;
            sb.append(String.format("Java Name: %s\n", mb.getVmName()));
            sb.append(String.format("Java Version: %s\n", mb.getVmVersion()));
            sb.append(String.format("Java Vendor: %s\n", mb.getVmVendor()));
            sb.append(String.format("Uptime: %s\n", TimeUtils.printDuration((long)mb.getUptime())));
            sb.append(String.format("PID: %s\n", mb.getPid()));
            if (!mb.getInputArguments().isEmpty()) {
                sb.append("Input Arguments:");
                cp = String.join((CharSequence)"\n    ", mb.getInputArguments());
                sb.append("\n    ").append(cp).append("\n");
            }
            if (mb.isBootClassPathSupported()) {
                sb.append("Boot Classpath:");
                cp = String.join((CharSequence)"\n    ", mb.getBootClassPath().split("[:|;]"));
                sb.append("\n    ").append(cp).append("\n");
            }
            sb.append("Classpath:");
            cp = String.join((CharSequence)"\n    ", mb.getClassPath().split("[:|;]"));
            sb.append("\n    ").append(cp).append("\n");
        }
        return sb.toString();
    }
}

