/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dynamicrouter.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.DynamicRouterControlChannelProcessor;
import org.apache.camel.component.dynamicrouter.DynamicRouterControlProducer;
import org.apache.camel.component.dynamicrouter.DynamicRouterEndpoint;
import org.apache.camel.component.dynamicrouter.DynamicRouterProcessor;
import org.apache.camel.component.dynamicrouter.DynamicRouterProducer;
import org.apache.camel.component.dynamicrouter.PrioritizedFilterProcessor;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="dynamic-router")
public class DynamicRouterComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterComponent.class);
    private final transient Map<String, DynamicRouterProcessor> processors = new HashMap<String, DynamicRouterProcessor>();
    private DynamicRouterControlChannelProcessor controlChannelProcessor;
    private Supplier<DynamicRouterEndpoint.DynamicRouterEndpointFactory> endpointFactorySupplier = DynamicRouterEndpoint.DynamicRouterEndpointFactory::new;
    private Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier = DynamicRouterProcessor.DynamicRouterProcessorFactory::new;
    private Supplier<DynamicRouterControlChannelProcessor.DynamicRouterControlChannelProcessorFactory> controlChannelProcessorFactorySupplier = DynamicRouterControlChannelProcessor.DynamicRouterControlChannelProcessorFactory::new;
    private Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier = DynamicRouterProducer.DynamicRouterProducerFactory::new;
    private Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> controlProducerFactorySupplier = DynamicRouterControlProducer.DynamicRouterControlProducerFactory::new;
    private Supplier<PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory> filterProcessorFactorySupplier = PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory::new;

    public DynamicRouterComponent() {
        LOG.debug("Created Dynamic Router component");
    }

    public DynamicRouterComponent(Supplier<DynamicRouterEndpoint.DynamicRouterEndpointFactory> endpointFactorySupplier, Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier, Supplier<DynamicRouterControlChannelProcessor.DynamicRouterControlChannelProcessorFactory> controlChannelProcessorFactorySupplier, Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier, Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> controlProducerFactorySupplier, Supplier<PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory> filterProcessorFactorySupplier) {
        this.endpointFactorySupplier = endpointFactorySupplier;
        this.processorFactorySupplier = processorFactorySupplier;
        this.controlChannelProcessorFactorySupplier = controlChannelProcessorFactorySupplier;
        this.producerFactorySupplier = producerFactorySupplier;
        this.controlProducerFactorySupplier = controlProducerFactorySupplier;
        this.filterProcessorFactorySupplier = filterProcessorFactorySupplier;
        LOG.debug("Created Dynamic Router component");
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        DynamicRouterConfiguration configuration = new DynamicRouterConfiguration();
        configuration.parsePath(remaining);
        if (remaining == null || remaining.isBlank()) {
            throw new IllegalArgumentException("You must provide a channel for the Dynamic Router");
        }
        DynamicRouterEndpoint endpoint = remaining.startsWith("control") ? this.endpointFactorySupplier.get().getInstance(uri, this, configuration, this.controlChannelProcessorFactorySupplier, this.controlProducerFactorySupplier) : this.endpointFactorySupplier.get().getInstance(uri, this, configuration, this.processorFactorySupplier, this.producerFactorySupplier, this.filterProcessorFactorySupplier);
        this.setProperties((Endpoint)endpoint, parameters);
        return endpoint;
    }

    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.processors);
        this.processors.clear();
        super.doShutdown();
    }

    void addRoutingProcessor(String channel, DynamicRouterProcessor processor) {
        if (this.processors.putIfAbsent(channel, processor) != null) {
            throw new IllegalArgumentException("Dynamic Router can have only one processor per channel; channel '" + channel + "' already has a processor");
        }
    }

    public DynamicRouterProcessor getRoutingProcessor(String channel) {
        return this.processors.get(channel);
    }

    void setControlChannelProcessor(DynamicRouterControlChannelProcessor controlChannelProcessor) {
        this.controlChannelProcessor = controlChannelProcessor;
    }

    DynamicRouterControlChannelProcessor getControlChannelProcessor() {
        return this.controlChannelProcessor;
    }
}

