/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.camel.Predicate;
import org.apache.camel.component.dynamicrouter.DynamicRouterConstants;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;

@UriParams
public class DynamicRouterConfiguration {
    @UriPath(name="channel", label="common", description="Channel of the Dynamic Router")
    @Metadata(required=true)
    private String channel;
    @UriPath(name="controlAction", label="control", enums="subscribe,unsubscribe", description="Control channel action: subscribe or unsubscribe")
    @Metadata
    private String controlAction;
    @UriPath(name="subscribeChannel", label="control", description="The channel to subscribe to")
    @Metadata
    private String subscribeChannel;
    @UriParam(label="control", description="The subscription ID; if unspecified, one will be assigned and returned.")
    private String subscriptionId;
    @UriParam(label="control", description="The destination URI for exchanges that match.")
    private String destinationUri;
    @UriParam(label="control", description="The subscription priority.")
    private Integer priority;
    @UriParam(label="control", description="The subscription predicate.")
    private String predicate;
    @UriParam(label="control", description="A Predicate instance in the registry.", javaType="org.apache.camel.Predicate")
    private Predicate predicateBean;
    @UriParam(label="control", defaultValue="simple", description="The subscription predicate language.")
    private String expressionLanguage = "simple";
    @UriParam(label="common", defaultValue="firstMatch", enums="firstMatch,allMatch", description="Recipient mode: firstMatch or allMatch")
    private String recipientMode = "firstMatch";
    @UriParam(label="common", defaultValue="false")
    private boolean synchronous;
    @UriParam(label="common", defaultValue="false")
    private boolean warnDroppedMessage;

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getControlAction() {
        return this.controlAction;
    }

    public void setControlAction(String controlAction) {
        this.controlAction = controlAction;
    }

    public String getSubscribeChannel() {
        return this.subscribeChannel;
    }

    public void setSubscribeChannel(String subscribeChannel) {
        this.subscribeChannel = subscribeChannel;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getDestinationUri() {
        return this.destinationUri;
    }

    public void setDestinationUri(String destinationUri) {
        this.destinationUri = destinationUri;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public Predicate getPredicateBean() {
        return this.predicateBean;
    }

    public void setPredicateBean(Predicate predicateBean) {
        this.predicateBean = predicateBean;
    }

    public String getExpressionLanguage() {
        return this.expressionLanguage;
    }

    public void setExpressionLanguage(String expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String getRecipientMode() {
        return this.recipientMode;
    }

    public void setRecipientMode(String recipientMode) {
        this.recipientMode = recipientMode;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public boolean isWarnDroppedMessage() {
        return this.warnDroppedMessage;
    }

    public void setWarnDroppedMessage(boolean warnDroppedMessage) {
        this.warnDroppedMessage = warnDroppedMessage;
    }

    public void parsePath(String path) {
        Optional.ofNullable(path).map(s -> s.isEmpty() ? null : s).ifPresent(p -> {
            Matcher matcher = DynamicRouterConstants.PATH_PARAMS_PATTERN.matcher((CharSequence)p);
            boolean matches = matcher.matches();
            if (!matches) {
                throw new IllegalArgumentException("Illegal syntax for a Dynamic Router URI: " + path);
            }
            this.setChannel(matcher.group("channel"));
            this.setControlAction(matcher.group("action"));
            this.setSubscribeChannel(matcher.group("subscribe"));
        });
    }
}

