/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dynamicrouter;

import java.util.function.Supplier;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.dynamicrouter.DynamicRouterComponent;
import org.apache.camel.component.dynamicrouter.DynamicRouterConfiguration;
import org.apache.camel.component.dynamicrouter.DynamicRouterControlChannelProcessor;
import org.apache.camel.component.dynamicrouter.DynamicRouterControlProducer;
import org.apache.camel.component.dynamicrouter.DynamicRouterProcessor;
import org.apache.camel.component.dynamicrouter.DynamicRouterProducer;
import org.apache.camel.component.dynamicrouter.PrioritizedFilterProcessor;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.15.0", scheme="dynamic-router", title="Dynamic Router", syntax="dynamic-router:channel", alternativeSyntax="dynamic-router:channel/controlAction/subscribeChannel", producerOnly=true, category={Category.ENDPOINT, Category.JAVA})
public class DynamicRouterEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicRouterEndpoint.class);
    private Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier = DynamicRouterProcessor.DynamicRouterProcessorFactory::new;
    private Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier = DynamicRouterProducer.DynamicRouterProducerFactory::new;
    private Supplier<PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory> filterProcessorFactorySupplier = PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory::new;
    private Supplier<DynamicRouterControlChannelProcessor.DynamicRouterControlChannelProcessorFactory> controlChannelProcessorFactorySupplier = DynamicRouterControlChannelProcessor.DynamicRouterControlChannelProcessorFactory::new;
    private Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> controlProducerFactorySupplier = DynamicRouterControlProducer.DynamicRouterControlProducerFactory::new;
    @UriParam
    private DynamicRouterConfiguration configuration;

    public DynamicRouterEndpoint(String uri, DynamicRouterComponent component, DynamicRouterConfiguration configuration, Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier, Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier, Supplier<PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory> filterProcessorFactorySupplier) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.processorFactorySupplier = processorFactorySupplier;
        this.producerFactorySupplier = producerFactorySupplier;
        this.filterProcessorFactorySupplier = filterProcessorFactorySupplier;
        LOG.debug("Created Dynamic Router endpoint URI: {}", (Object)uri);
    }

    public DynamicRouterEndpoint(String uri, DynamicRouterComponent component, DynamicRouterConfiguration configuration, Supplier<DynamicRouterControlChannelProcessor.DynamicRouterControlChannelProcessorFactory> processorFactorySupplier, Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> controlProducerFactorySupplier) {
        super(uri, (Component)component);
        this.configuration = configuration;
        this.controlChannelProcessorFactorySupplier = processorFactorySupplier;
        this.controlProducerFactorySupplier = controlProducerFactorySupplier;
        LOG.debug("Created Dynamic Router Control Channel endpoint URI: {}", (Object)uri);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInit() throws Exception {
        super.doInit();
        DynamicRouterComponent component = this.getDynamicRouterComponent();
        if ("control".equals(this.configuration.getChannel())) {
            DynamicRouterControlChannelProcessor processor = this.controlChannelProcessorFactorySupplier.get().getInstance(component);
            processor.setConfiguration(this.configuration);
            try {
                if (component.getControlChannelProcessor() != null) return;
                component.setControlChannelProcessor(processor);
                return;
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not create Dynamic Router endpoint", e);
            }
        } else {
            DynamicRouterProcessor processor = this.processorFactorySupplier.get().getInstance("dynamicRouterProcessor-" + this.configuration.getChannel(), this.getCamelContext(), this.configuration.getRecipientMode(), this.configuration.isWarnDroppedMessage(), this.filterProcessorFactorySupplier);
            ServiceHelper.startService((Object)((Object)processor));
            component.addRoutingProcessor(this.configuration.getChannel(), processor);
        }
    }

    public Producer createProducer() {
        return "control".equals(this.configuration.getChannel()) ? this.controlProducerFactorySupplier.get().getInstance(this) : this.producerFactorySupplier.get().getInstance(this);
    }

    public Consumer createConsumer(Processor processor) {
        throw new IllegalStateException("Dynamic Router is a producer-only component");
    }

    public DynamicRouterComponent getDynamicRouterComponent() {
        return (DynamicRouterComponent)this.getComponent();
    }

    public DynamicRouterConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DynamicRouterConfiguration configuration) {
        this.configuration = configuration;
    }

    public static class DynamicRouterEndpointFactory {
        public DynamicRouterEndpoint getInstance(String uri, DynamicRouterComponent component, DynamicRouterConfiguration configuration, Supplier<DynamicRouterProcessor.DynamicRouterProcessorFactory> processorFactorySupplier, Supplier<DynamicRouterProducer.DynamicRouterProducerFactory> producerFactorySupplier, Supplier<PrioritizedFilterProcessor.PrioritizedFilterProcessorFactory> filterProcessorFactorySupplier) {
            return new DynamicRouterEndpoint(uri, component, configuration, processorFactorySupplier, producerFactorySupplier, filterProcessorFactorySupplier);
        }

        public DynamicRouterEndpoint getInstance(String uri, DynamicRouterComponent component, DynamicRouterConfiguration configuration, Supplier<DynamicRouterControlChannelProcessor.DynamicRouterControlChannelProcessorFactory> processorFactorySupplier, Supplier<DynamicRouterControlProducer.DynamicRouterControlProducerFactory> producerFactorySupplier) {
            return new DynamicRouterEndpoint(uri, component, configuration, processorFactorySupplier, producerFactorySupplier);
        }
    }
}

