/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Use ElSql to define SQL queries. Extends the SQL Component.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface ElsqlEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the ElSQL component.
     */
    public interface ElsqlEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedElsqlEndpointConsumerBuilder advanced() {
            return (AdvancedElsqlEndpointConsumerBuilder) this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder allowNamedParameters(
                boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder allowNamedParameters(
                String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.elsql.ElSqlDatabaseVendor&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param databaseVendor the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder databaseVendor(
                ElSqlDatabaseVendor databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.elsql.ElSqlDatabaseVendor&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param databaseVendor the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder databaseVendor(
                String databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option is a: &lt;code&gt;javax.sql.DataSource&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder dataSource(Object dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sql.DataSource&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputHeader the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sql.SqlOutputType&lt;/code&gt;
         * type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder outputType(SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sql.SqlOutputType&lt;/code&gt;
         * type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: &lt;code&gt;char&lt;/code&gt; type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a &lt;code&gt;char&lt;/code&gt; type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * Sets whether to break batch if onConsume failed.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param breakBatchOnConsumeFail the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder breakBatchOnConsumeFail(
                boolean breakBatchOnConsumeFail) {
            doSetProperty("breakBatchOnConsumeFail", breakBatchOnConsumeFail);
            return this;
        }
        /**
         * Sets whether to break batch if onConsume failed.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param breakBatchOnConsumeFail the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder breakBatchOnConsumeFail(
                String breakBatchOnConsumeFail) {
            doSetProperty("breakBatchOnConsumeFail", breakBatchOnConsumeFail);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Sets an expected update count to validate when using onConsume.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param expectedUpdateCount the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder expectedUpdateCount(
                int expectedUpdateCount) {
            doSetProperty("expectedUpdateCount", expectedUpdateCount);
            return this;
        }
        /**
         * Sets an expected update count to validate when using onConsume.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: -1
         * Group: consumer
         * 
         * @param expectedUpdateCount the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder expectedUpdateCount(
                String expectedUpdateCount) {
            doSetProperty("expectedUpdateCount", expectedUpdateCount);
            return this;
        }
        /**
         * Sets the maximum number of messages to poll.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder maxMessagesPerPoll(
                int maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * Sets the maximum number of messages to poll.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param maxMessagesPerPoll the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder maxMessagesPerPoll(
                String maxMessagesPerPoll) {
            doSetProperty("maxMessagesPerPoll", maxMessagesPerPoll);
            return this;
        }
        /**
         * After processing each row then this query can be executed, if the
         * Exchange was processed successfully, for example to mark the row as
         * processed. The query can have parameter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param onConsume the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder onConsume(String onConsume) {
            doSetProperty("onConsume", onConsume);
            return this;
        }
        /**
         * After processing the entire batch, this query can be executed to bulk
         * update rows etc. The query cannot have parameters.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param onConsumeBatchComplete the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder onConsumeBatchComplete(
                String onConsumeBatchComplete) {
            doSetProperty("onConsumeBatchComplete", onConsumeBatchComplete);
            return this;
        }
        /**
         * After processing each row then this query can be executed, if the
         * Exchange failed, for example to mark the row as failed. The query can
         * have parameter.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param onConsumeFailed the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder onConsumeFailed(
                String onConsumeFailed) {
            doSetProperty("onConsumeFailed", onConsumeFailed);
            return this;
        }
        /**
         * Sets whether empty resultset should be allowed to be sent to the next
         * hop. Defaults to false. So the empty resultset will be filtered out.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param routeEmptyResultSet the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder routeEmptyResultSet(
                boolean routeEmptyResultSet) {
            doSetProperty("routeEmptyResultSet", routeEmptyResultSet);
            return this;
        }
        /**
         * Sets whether empty resultset should be allowed to be sent to the next
         * hop. Defaults to false. So the empty resultset will be filtered out.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param routeEmptyResultSet the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder routeEmptyResultSet(
                String routeEmptyResultSet) {
            doSetProperty("routeEmptyResultSet", routeEmptyResultSet);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * Enables or disables transaction. If enabled then if processing an
         * exchange failed then the consumer breaks out processing any further
         * exchanges to cause a rollback eager.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder transacted(boolean transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Enables or disables transaction. If enabled then if processing an
         * exchange failed then the consumer breaks out processing any further
         * exchanges to cause a rollback eager.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param transacted the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder transacted(String transacted) {
            doSetProperty("transacted", transacted);
            return this;
        }
        /**
         * Sets how resultset should be delivered to route. Indicates delivery
         * as either a list or individual object. defaults to true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param useIterator the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder useIterator(boolean useIterator) {
            doSetProperty("useIterator", useIterator);
            return this;
        }
        /**
         * Sets how resultset should be delivered to route. Indicates delivery
         * as either a list or individual object. defaults to true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param useIterator the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder useIterator(String useIterator) {
            doSetProperty("useIterator", useIterator);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the ElSQL component.
     */
    public interface AdvancedElsqlEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default ElsqlEndpointConsumerBuilder basic() {
            return (ElsqlEndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlProcessingStrategy to execute
         * queries when the consumer has processed the rows/batch.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sql.SqlProcessingStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param processingStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder processingStrategy(
                Object processingStrategy) {
            doSetProperty("processingStrategy", processingStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlProcessingStrategy to execute
         * queries when the consumer has processed the rows/batch.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sql.SqlProcessingStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param processingStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder processingStrategy(
                String processingStrategy) {
            doSetProperty("processingStrategy", processingStrategy);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder alwaysPopulateStatement(
                boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder alwaysPopulateStatement(
                String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option is a:
         * &lt;code&gt;com.opengamma.elsql.ElSqlConfig&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param elSqlConfig the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder elSqlConfig(
                Object elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.opengamma.elsql.ElSqlConfig&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param elSqlConfig the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder elSqlConfig(
                String elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder parametersCount(
                int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder parametersCount(
                String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: #
         * Group: advanced
         * 
         * @param placeholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder placeholder(
                String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sql.SqlPrepareStatementStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder prepareStatementStrategy(
                Object prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sql.SqlPrepareStatementStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder prepareStatementStrategy(
                String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder templateOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("templateOptions", "template." + key, value);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder templateOptions(Map values) {
            doSetMultiValueProperties("templateOptions", "template.", values);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder usePlaceholder(
                boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointConsumerBuilder usePlaceholder(
                String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the ElSQL component.
     */
    public interface ElsqlEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedElsqlEndpointProducerBuilder advanced() {
            return (AdvancedElsqlEndpointProducerBuilder) this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder allowNamedParameters(
                boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder allowNamedParameters(
                String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.elsql.ElSqlDatabaseVendor&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param databaseVendor the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder databaseVendor(
                ElSqlDatabaseVendor databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.elsql.ElSqlDatabaseVendor&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param databaseVendor the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder databaseVendor(
                String databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option is a: &lt;code&gt;javax.sql.DataSource&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder dataSource(Object dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sql.DataSource&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputHeader the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sql.SqlOutputType&lt;/code&gt;
         * type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder outputType(SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sql.SqlOutputType&lt;/code&gt;
         * type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: &lt;code&gt;char&lt;/code&gt; type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a &lt;code&gt;char&lt;/code&gt; type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * Enables or disables batch mode.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param batch the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder batch(boolean batch) {
            doSetProperty("batch", batch);
            return this;
        }
        /**
         * Enables or disables batch mode.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param batch the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder batch(String batch) {
            doSetProperty("batch", batch);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * If set, will ignore the results of the SQL query and use the existing
         * IN message as the OUT message for the continuation of processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param noop the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder noop(boolean noop) {
            doSetProperty("noop", noop);
            return this;
        }
        /**
         * If set, will ignore the results of the SQL query and use the existing
         * IN message as the OUT message for the continuation of processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param noop the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder noop(String noop) {
            doSetProperty("noop", noop);
            return this;
        }
        /**
         * Whether to use the message body as the SQL and then headers for
         * parameters. If this option is enabled then the SQL in the uri is not
         * used. Note that query parameters in the message body are represented
         * by a question mark instead of a # symbol.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useMessageBodyForSql the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder useMessageBodyForSql(
                boolean useMessageBodyForSql) {
            doSetProperty("useMessageBodyForSql", useMessageBodyForSql);
            return this;
        }
        /**
         * Whether to use the message body as the SQL and then headers for
         * parameters. If this option is enabled then the SQL in the uri is not
         * used. Note that query parameters in the message body are represented
         * by a question mark instead of a # symbol.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param useMessageBodyForSql the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointProducerBuilder useMessageBodyForSql(
                String useMessageBodyForSql) {
            doSetProperty("useMessageBodyForSql", useMessageBodyForSql);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the ElSQL component.
     */
    public interface AdvancedElsqlEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default ElsqlEndpointProducerBuilder basic() {
            return (ElsqlEndpointProducerBuilder) this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder alwaysPopulateStatement(
                boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder alwaysPopulateStatement(
                String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option is a:
         * &lt;code&gt;com.opengamma.elsql.ElSqlConfig&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param elSqlConfig the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder elSqlConfig(
                Object elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.opengamma.elsql.ElSqlConfig&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param elSqlConfig the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder elSqlConfig(
                String elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder parametersCount(
                int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder parametersCount(
                String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: #
         * Group: advanced
         * 
         * @param placeholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder placeholder(
                String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sql.SqlPrepareStatementStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder prepareStatementStrategy(
                Object prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sql.SqlPrepareStatementStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder prepareStatementStrategy(
                String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder templateOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("templateOptions", "template." + key, value);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder templateOptions(Map values) {
            doSetMultiValueProperties("templateOptions", "template.", values);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder usePlaceholder(
                boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointProducerBuilder usePlaceholder(
                String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    /**
     * Builder for endpoint for the ElSQL component.
     */
    public interface ElsqlEndpointBuilder
            extends
                ElsqlEndpointConsumerBuilder,
                ElsqlEndpointProducerBuilder {
        default AdvancedElsqlEndpointBuilder advanced() {
            return (AdvancedElsqlEndpointBuilder) this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder allowNamedParameters(
                boolean allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * Whether to allow using named parameters in the queries.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param allowNamedParameters the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder allowNamedParameters(
                String allowNamedParameters) {
            doSetProperty("allowNamedParameters", allowNamedParameters);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.elsql.ElSqlDatabaseVendor&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param databaseVendor the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder databaseVendor(
                ElSqlDatabaseVendor databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * To use a vendor specific com.opengamma.elsql.ElSqlConfig.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.elsql.ElSqlDatabaseVendor&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param databaseVendor the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder databaseVendor(String databaseVendor) {
            doSetProperty("databaseVendor", databaseVendor);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option is a: &lt;code&gt;javax.sql.DataSource&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder dataSource(Object dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Sets the DataSource to use to communicate with the database at
         * endpoint level.
         * 
         * The option will be converted to a
         * &lt;code&gt;javax.sql.DataSource&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataSource the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder dataSource(String dataSource) {
            doSetProperty("dataSource", dataSource);
            return this;
        }
        /**
         * Specify the full package and class name to use as conversion when
         * outputType=SelectOne.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputClass the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder outputClass(String outputClass) {
            doSetProperty("outputClass", outputClass);
            return this;
        }
        /**
         * Store the query result in a header instead of the message body. By
         * default, outputHeader == null and the query result is stored in the
         * message body, any existing content in the message body is discarded.
         * If outputHeader is set, the value is used as the name of the header
         * to store the query result and the original message body is preserved.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param outputHeader the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder outputHeader(String outputHeader) {
            doSetProperty("outputHeader", outputHeader);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sql.SqlOutputType&lt;/code&gt;
         * type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder outputType(SqlOutputType outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * Make the output of consumer or producer to SelectList as List of Map,
         * or SelectOne as single Java object in the following way: a) If the
         * query has only single column, then that JDBC Column object is
         * returned. (such as SELECT COUNT( ) FROM PROJECT will return a Long
         * object. b) If the query has more than one column, then it will return
         * a Map of that result. c) If the outputClass is set, then it will
         * convert the query result into an Java bean object by calling all the
         * setters that match the column names. It will assume your class has a
         * default constructor to create instance with. d) If the query resulted
         * in more than one rows, it throws an non-unique result exception.
         * StreamList streams the result of the query using an Iterator. This
         * can be used with the Splitter EIP in streaming mode to process the
         * ResultSet in streaming fashion.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sql.SqlOutputType&lt;/code&gt;
         * type.
         * 
         * Default: SelectList
         * Group: common
         * 
         * @param outputType the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder outputType(String outputType) {
            doSetProperty("outputType", outputType);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option is a: &lt;code&gt;char&lt;/code&gt; type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder separator(char separator) {
            doSetProperty("separator", separator);
            return this;
        }
        /**
         * The separator to use when parameter values is taken from message body
         * (if the body is a String type), to be inserted at # placeholders.
         * Notice if you use named parameters, then a Map type is used instead.
         * The default value is comma.
         * 
         * The option will be converted to a &lt;code&gt;char&lt;/code&gt; type.
         * 
         * Default: ,
         * Group: common
         * 
         * @param separator the value to set
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder separator(String separator) {
            doSetProperty("separator", separator);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the ElSQL component.
     */
    public interface AdvancedElsqlEndpointBuilder
            extends
                AdvancedElsqlEndpointConsumerBuilder,
                AdvancedElsqlEndpointProducerBuilder {
        default ElsqlEndpointBuilder basic() {
            return (ElsqlEndpointBuilder) this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder alwaysPopulateStatement(
                boolean alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * If enabled then the populateStatement method from
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy is always
         * invoked, also if there is no expected parameters to be prepared. When
         * this is false then the populateStatement is only invoked if there is
         * 1 or more expected parameters to be set; for example this avoids
         * reading the message body/headers for SQL queries with no parameters.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param alwaysPopulateStatement the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder alwaysPopulateStatement(
                String alwaysPopulateStatement) {
            doSetProperty("alwaysPopulateStatement", alwaysPopulateStatement);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option is a:
         * &lt;code&gt;com.opengamma.elsql.ElSqlConfig&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param elSqlConfig the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder elSqlConfig(Object elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * To use a specific configured ElSqlConfig. It may be better to use the
         * databaseVendor option instead.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.opengamma.elsql.ElSqlConfig&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param elSqlConfig the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder elSqlConfig(String elSqlConfig) {
            doSetProperty("elSqlConfig", elSqlConfig);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder parametersCount(int parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * If set greater than zero, then Camel will use this count value of
         * parameters to replace instead of querying via JDBC metadata API. This
         * is useful if the JDBC vendor could not return correct parameters
         * count, then user may override instead.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param parametersCount the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder parametersCount(
                String parametersCount) {
            doSetProperty("parametersCount", parametersCount);
            return this;
        }
        /**
         * Specifies a character that will be replaced to in SQL query. Notice,
         * that it is simple String.replaceAll() operation and no SQL parsing is
         * involved (quoted strings will also change).
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Default: #
         * Group: advanced
         * 
         * @param placeholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder placeholder(String placeholder) {
            doSetProperty("placeholder", placeholder);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.sql.SqlPrepareStatementStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder prepareStatementStrategy(
                Object prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Allows to plugin to use a custom
         * org.apache.camel.component.sql.SqlPrepareStatementStrategy to control
         * preparation of the query and prepared statement.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.sql.SqlPrepareStatementStrategy&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param prepareStatementStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder prepareStatementStrategy(
                String prepareStatementStrategy) {
            doSetProperty("prepareStatementStrategy", prepareStatementStrategy);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder templateOptions(
                String key,
                Object value) {
            doSetMultiValueProperty("templateOptions", "template." + key, value);
            return this;
        }
        /**
         * Configures the Spring JdbcTemplate with the key/values from the Map.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * templateOptions(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: advanced
         * 
         * @param values the values
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder templateOptions(Map values) {
            doSetMultiValueProperties("templateOptions", "template.", values);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder usePlaceholder(
                boolean usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
        /**
         * Sets whether to use placeholder and replace all placeholder
         * characters with sign in the SQL queries.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param usePlaceholder the value to set
         * @return the dsl builder
         */
        default AdvancedElsqlEndpointBuilder usePlaceholder(
                String usePlaceholder) {
            doSetProperty("usePlaceholder", usePlaceholder);
            return this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.elsql.ElSqlDatabaseVendor</code> enum.
     */
    enum ElSqlDatabaseVendor {
        Default,
        Postgres,
        HSql,
        MySql,
        Oracle,
        SqlServer2008,
        Veritca;
    }

    /**
     * Proxy enum for <code>org.apache.camel.component.sql.SqlOutputType</code>
     * enum.
     */
    enum SqlOutputType {
        SelectOne,
        SelectList,
        StreamList;
    }

    public interface ElsqlBuilders {
        /**
         * ElSQL (camel-elsql)
         * Use ElSql to define SQL queries. Extends the SQL Component.
         * 
         * Category: database,sql
         * Since: 2.16
         * Maven coordinates: org.apache.camel:camel-elsql
         * 
         * Syntax: <code>elsql:elsqlName:resourceUri</code>
         * 
         * Path parameter: elsqlName (required)
         * The name of the elsql to use (is NAMED in the elsql file)
         * 
         * Path parameter: resourceUri
         * The resource file which contains the elsql SQL statements to use. You
         * can specify multiple resources separated by comma. The resources are
         * loaded on the classpath by default, you can prefix with file: to load
         * from file system. Notice you can set this option on the component and
         * then you do not have to configure this on the endpoint.
         * 
         * @param path elsqlName:resourceUri
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder elsql(String path) {
            return ElsqlEndpointBuilderFactory.endpointBuilder("elsql", path);
        }
        /**
         * ElSQL (camel-elsql)
         * Use ElSql to define SQL queries. Extends the SQL Component.
         * 
         * Category: database,sql
         * Since: 2.16
         * Maven coordinates: org.apache.camel:camel-elsql
         * 
         * Syntax: <code>elsql:elsqlName:resourceUri</code>
         * 
         * Path parameter: elsqlName (required)
         * The name of the elsql to use (is NAMED in the elsql file)
         * 
         * Path parameter: resourceUri
         * The resource file which contains the elsql SQL statements to use. You
         * can specify multiple resources separated by comma. The resources are
         * loaded on the classpath by default, you can prefix with file: to load
         * from file system. Notice you can set this option on the component and
         * then you do not have to configure this on the endpoint.
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path elsqlName:resourceUri
         * @return the dsl builder
         */
        default ElsqlEndpointBuilder elsql(String componentName, String path) {
            return ElsqlEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static ElsqlEndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class ElsqlEndpointBuilderImpl extends AbstractEndpointBuilder implements ElsqlEndpointBuilder, AdvancedElsqlEndpointBuilder {
            public ElsqlEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new ElsqlEndpointBuilderImpl(path);
    }
}