/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Generated;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.PollingConsumerPollStrategy;

/**
 * Exchanges messages with an IBM i system using data queues, message queues, or
 * program call. IBM i is the replacement for AS/400 and iSeries servers.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface Jt400EndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the JT400 component.
     */
    public interface Jt400EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedJt400EndpointConsumerBuilder advanced() {
            return (AdvancedJt400EndpointConsumerBuilder) this;
        }
        /**
         * Sets the CCSID to use for the connection with the IBM i system.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ccsid the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder ccsid(int ccsid) {
            doSetProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the CCSID to use for the connection with the IBM i system.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ccsid the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder ccsid(String ccsid) {
            doSetProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$Format&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder format(Format format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$Format&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Sets whether IBM i prompting is enabled in the environment running
         * Camel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param guiAvailable the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder guiAvailable(boolean guiAvailable) {
            doSetProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Sets whether IBM i prompting is enabled in the environment running
         * Camel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param guiAvailable the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder guiAvailable(String guiAvailable) {
            doSetProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param keyed the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder keyed(boolean keyed) {
            doSetProperty("keyed", keyed);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param keyed the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder keyed(String keyed) {
            doSetProperty("keyed", keyed);
            return this;
        }
        /**
         * Search key for keyed data queues.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param searchKey the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder searchKey(String searchKey) {
            doSetProperty("searchKey", searchKey);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Action to be taken on messages when read from a message queue.
         * Messages can be marked as old (OLD), removed from the queue (REMOVE),
         * or neither (SAME).
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$MessageAction&lt;/code&gt; type.
         * 
         * Default: OLD
         * Group: consumer
         * 
         * @param messageAction the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder messageAction(
                MessageAction messageAction) {
            doSetProperty("messageAction", messageAction);
            return this;
        }
        /**
         * Action to be taken on messages when read from a message queue.
         * Messages can be marked as old (OLD), removed from the queue (REMOVE),
         * or neither (SAME).
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$MessageAction&lt;/code&gt; type.
         * 
         * Default: OLD
         * Group: consumer
         * 
         * @param messageAction the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder messageAction(String messageAction) {
            doSetProperty("messageAction", messageAction);
            return this;
        }
        /**
         * Timeout in millis the consumer will wait while trying to read a new
         * message of the data queue.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: consumer
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder readTimeout(int readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Timeout in millis the consumer will wait while trying to read a new
         * message of the data queue.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 30000
         * Group: consumer
         * 
         * @param readTimeout the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder readTimeout(String readTimeout) {
            doSetProperty("readTimeout", readTimeout);
            return this;
        }
        /**
         * Search type such as EQ for equal etc.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$SearchType&lt;/code&gt; type.
         * 
         * Default: EQ
         * Group: consumer
         * 
         * @param searchType the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder searchType(SearchType searchType) {
            doSetProperty("searchType", searchType);
            return this;
        }
        /**
         * Search type such as EQ for equal etc.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$SearchType&lt;/code&gt; type.
         * 
         * Default: EQ
         * Group: consumer
         * 
         * @param searchType the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder searchType(String searchType) {
            doSetProperty("searchType", searchType);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If true, the consumer endpoint will set the
         * Jt400Constants.MESSAGE_REPLYTO_KEY header of the camel message for
         * any IBM i inquiry messages received. If that message is then routed
         * to a producer endpoint, the action will not be processed as sending a
         * message to the queue, but rather a reply to the specific inquiry
         * message.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param sendingReply the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder sendingReply(boolean sendingReply) {
            doSetProperty("sendingReply", sendingReply);
            return this;
        }
        /**
         * If true, the consumer endpoint will set the
         * Jt400Constants.MESSAGE_REPLYTO_KEY header of the camel message for
         * any IBM i inquiry messages received. If that message is then routed
         * to a producer endpoint, the action will not be processed as sending a
         * message to the queue, but rather a reply to the specific inquiry
         * message.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: consumer
         * 
         * @param sendingReply the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder sendingReply(String sendingReply) {
            doSetProperty("sendingReply", sendingReply);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder runLoggingLevel(
                LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder startScheduler(
                String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Whether connections to IBM i are secured with SSL.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secured the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder secured(boolean secured) {
            doSetProperty("secured", secured);
            return this;
        }
        /**
         * Whether connections to IBM i are secured with SSL.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secured the value to set
         * @return the dsl builder
         */
        default Jt400EndpointConsumerBuilder secured(String secured) {
            doSetProperty("secured", secured);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the JT400 component.
     */
    public interface AdvancedJt400EndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default Jt400EndpointConsumerBuilder basic() {
            return (Jt400EndpointConsumerBuilder) this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJt400EndpointConsumerBuilder exceptionHandler(
                ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedJt400EndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJt400EndpointConsumerBuilder exchangePattern(
                ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedJt400EndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedJt400EndpointConsumerBuilder pollStrategy(
                PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedJt400EndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the JT400 component.
     */
    public interface Jt400EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedJt400EndpointProducerBuilder advanced() {
            return (AdvancedJt400EndpointProducerBuilder) this;
        }
        /**
         * Sets the CCSID to use for the connection with the IBM i system.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ccsid the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder ccsid(int ccsid) {
            doSetProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the CCSID to use for the connection with the IBM i system.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ccsid the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder ccsid(String ccsid) {
            doSetProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$Format&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder format(Format format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$Format&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Sets whether IBM i prompting is enabled in the environment running
         * Camel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param guiAvailable the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder guiAvailable(boolean guiAvailable) {
            doSetProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Sets whether IBM i prompting is enabled in the environment running
         * Camel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param guiAvailable the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder guiAvailable(String guiAvailable) {
            doSetProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param keyed the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder keyed(boolean keyed) {
            doSetProperty("keyed", keyed);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param keyed the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder keyed(String keyed) {
            doSetProperty("keyed", keyed);
            return this;
        }
        /**
         * Search key for keyed data queues.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param searchKey the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder searchKey(String searchKey) {
            doSetProperty("searchKey", searchKey);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Specifies which fields (program parameters) are output parameters.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer[]&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param outputFieldsIdxArray the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder outputFieldsIdxArray(
                Integer[] outputFieldsIdxArray) {
            doSetProperty("outputFieldsIdxArray", outputFieldsIdxArray);
            return this;
        }
        /**
         * Specifies which fields (program parameters) are output parameters.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer[]&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param outputFieldsIdxArray the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder outputFieldsIdxArray(
                String outputFieldsIdxArray) {
            doSetProperty("outputFieldsIdxArray", outputFieldsIdxArray);
            return this;
        }
        /**
         * Specifies the fields (program parameters) length as in the IBM i
         * program definition.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer[]&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param outputFieldsLengthArray the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder outputFieldsLengthArray(
                Integer[] outputFieldsLengthArray) {
            doSetProperty("outputFieldsLengthArray", outputFieldsLengthArray);
            return this;
        }
        /**
         * Specifies the fields (program parameters) length as in the IBM i
         * program definition.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer[]&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param outputFieldsLengthArray the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder outputFieldsLengthArray(
                String outputFieldsLengthArray) {
            doSetProperty("outputFieldsLengthArray", outputFieldsLengthArray);
            return this;
        }
        /**
         * Procedure name from a service program to call.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param procedureName the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder procedureName(String procedureName) {
            doSetProperty("procedureName", procedureName);
            return this;
        }
        /**
         * Whether connections to IBM i are secured with SSL.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secured the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder secured(boolean secured) {
            doSetProperty("secured", secured);
            return this;
        }
        /**
         * Whether connections to IBM i are secured with SSL.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secured the value to set
         * @return the dsl builder
         */
        default Jt400EndpointProducerBuilder secured(String secured) {
            doSetProperty("secured", secured);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the JT400 component.
     */
    public interface AdvancedJt400EndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default Jt400EndpointProducerBuilder basic() {
            return (Jt400EndpointProducerBuilder) this;
        }
    }

    /**
     * Builder for endpoint for the JT400 component.
     */
    public interface Jt400EndpointBuilder
            extends
                Jt400EndpointConsumerBuilder,
                Jt400EndpointProducerBuilder {
        default AdvancedJt400EndpointBuilder advanced() {
            return (AdvancedJt400EndpointBuilder) this;
        }
        /**
         * Sets the CCSID to use for the connection with the IBM i system.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ccsid the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder ccsid(int ccsid) {
            doSetProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the CCSID to use for the connection with the IBM i system.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param ccsid the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder ccsid(String ccsid) {
            doSetProperty("ccsid", ccsid);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$Format&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder format(Format format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Sets the data format for sending messages.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.jt400.Jt400Configuration$Format&lt;/code&gt; type.
         * 
         * Default: text
         * Group: common
         * 
         * @param format the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder format(String format) {
            doSetProperty("format", format);
            return this;
        }
        /**
         * Sets whether IBM i prompting is enabled in the environment running
         * Camel.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param guiAvailable the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder guiAvailable(boolean guiAvailable) {
            doSetProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Sets whether IBM i prompting is enabled in the environment running
         * Camel.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param guiAvailable the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder guiAvailable(String guiAvailable) {
            doSetProperty("guiAvailable", guiAvailable);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: common
         * 
         * @param keyed the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder keyed(boolean keyed) {
            doSetProperty("keyed", keyed);
            return this;
        }
        /**
         * Whether to use keyed or non-keyed data queues.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: common
         * 
         * @param keyed the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder keyed(String keyed) {
            doSetProperty("keyed", keyed);
            return this;
        }
        /**
         * Search key for keyed data queues.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param searchKey the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder searchKey(String searchKey) {
            doSetProperty("searchKey", searchKey);
            return this;
        }
        /**
         * Whether connections to IBM i are secured with SSL.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secured the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder secured(boolean secured) {
            doSetProperty("secured", secured);
            return this;
        }
        /**
         * Whether connections to IBM i are secured with SSL.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: security
         * 
         * @param secured the value to set
         * @return the dsl builder
         */
        default Jt400EndpointBuilder secured(String secured) {
            doSetProperty("secured", secured);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the JT400 component.
     */
    public interface AdvancedJt400EndpointBuilder
            extends
                AdvancedJt400EndpointConsumerBuilder,
                AdvancedJt400EndpointProducerBuilder {
        default Jt400EndpointBuilder basic() {
            return (Jt400EndpointBuilder) this;
        }
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.jt400.Jt400Configuration$Format</code>
     * enum.
     */
    enum Format {
        text,
        binary;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.jt400.Jt400Configuration$MessageAction</code> enum.
     */
    enum MessageAction {
        OLD,
        REMOVE,
        SAME;
    }

    /**
     * Proxy enum for
     * <code>org.apache.camel.component.jt400.Jt400Configuration$SearchType</code> enum.
     */
    enum SearchType {
        EQ,
        NE,
        LT,
        LE,
        GT,
        GE;
    }

    public interface Jt400Builders {
        /**
         * JT400 (camel-jt400)
         * Exchanges messages with an IBM i system using data queues, message
         * queues, or program call. IBM i is the replacement for AS/400 and
         * iSeries servers.
         * 
         * Category: messaging
         * Since: 1.5
         * Maven coordinates: org.apache.camel:camel-jt400
         * 
         * Syntax: <code>jt400:userID:password/systemName/objectPath.type</code>
         * 
         * Path parameter: userID (required)
         * Returns the ID of the IBM i user.
         * 
         * Path parameter: password (required)
         * Returns the password of the IBM i user.
         * 
         * Path parameter: systemName (required)
         * Returns the name of the IBM i system.
         * 
         * Path parameter: objectPath (required)
         * Returns the fully qualified integrated file system path name of the
         * target object of this endpoint.
         * 
         * Path parameter: type (required)
         * Whether to work with data queues or remote program call
         * There are 4 enums and the value can be one of: DTAQ, PGM, SRVPGM,
         * MSGQ
         * 
         * @param path userID:password/systemName/objectPath.type
         * @return the dsl builder
         */
        default Jt400EndpointBuilder jt400(String path) {
            return Jt400EndpointBuilderFactory.endpointBuilder("jt400", path);
        }
        /**
         * JT400 (camel-jt400)
         * Exchanges messages with an IBM i system using data queues, message
         * queues, or program call. IBM i is the replacement for AS/400 and
         * iSeries servers.
         * 
         * Category: messaging
         * Since: 1.5
         * Maven coordinates: org.apache.camel:camel-jt400
         * 
         * Syntax: <code>jt400:userID:password/systemName/objectPath.type</code>
         * 
         * Path parameter: userID (required)
         * Returns the ID of the IBM i user.
         * 
         * Path parameter: password (required)
         * Returns the password of the IBM i user.
         * 
         * Path parameter: systemName (required)
         * Returns the name of the IBM i system.
         * 
         * Path parameter: objectPath (required)
         * Returns the fully qualified integrated file system path name of the
         * target object of this endpoint.
         * 
         * Path parameter: type (required)
         * Whether to work with data queues or remote program call
         * There are 4 enums and the value can be one of: DTAQ, PGM, SRVPGM,
         * MSGQ
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path userID:password/systemName/objectPath.type
         * @return the dsl builder
         */
        default Jt400EndpointBuilder jt400(String componentName, String path) {
            return Jt400EndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }
    static Jt400EndpointBuilder endpointBuilder(
            String componentName,
            String path) {
        class Jt400EndpointBuilderImpl extends AbstractEndpointBuilder implements Jt400EndpointBuilder, AdvancedJt400EndpointBuilder {
            public Jt400EndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new Jt400EndpointBuilderImpl(path);
    }
}