/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.fhir.FhirComponent;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class FhirComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private FhirConfiguration getOrCreateConfiguration(FhirComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new FhirConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        FhirComponent target = (FhirComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                this.getOrCreateConfiguration(target).setAccessToken((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "client": {
                this.getOrCreateConfiguration(target).setClient((IGenericClient)FhirComponentConfigurer.property((CamelContext)camelContext, IGenericClient.class, (Object)value));
                return true;
            }
            case "clientfactory": 
            case "clientFactory": {
                this.getOrCreateConfiguration(target).setClientFactory((IRestfulClientFactory)FhirComponentConfigurer.property((CamelContext)camelContext, IRestfulClientFactory.class, (Object)value));
                return true;
            }
            case "compress": {
                this.getOrCreateConfiguration(target).setCompress((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((FhirConfiguration)FhirComponentConfigurer.property((CamelContext)camelContext, FhirConfiguration.class, (Object)value));
                return true;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                this.getOrCreateConfiguration(target).setConnectionTimeout((Integer)FhirComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "defermodelscanning": 
            case "deferModelScanning": {
                this.getOrCreateConfiguration(target).setDeferModelScanning((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "encoding": {
                this.getOrCreateConfiguration(target).setEncoding((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "fhircontext": 
            case "fhirContext": {
                this.getOrCreateConfiguration(target).setFhirContext((FhirContext)FhirComponentConfigurer.property((CamelContext)camelContext, FhirContext.class, (Object)value));
                return true;
            }
            case "fhirversion": 
            case "fhirVersion": {
                this.getOrCreateConfiguration(target).setFhirVersion((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "forceconformancecheck": 
            case "forceConformanceCheck": {
                this.getOrCreateConfiguration(target).setForceConformanceCheck((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "log": {
                this.getOrCreateConfiguration(target).setLog((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prettyprint": 
            case "prettyPrint": {
                this.getOrCreateConfiguration(target).setPrettyPrint((Boolean)FhirComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxypassword": 
            case "proxyPassword": {
                this.getOrCreateConfiguration(target).setProxyPassword((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)FhirComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyuser": 
            case "proxyUser": {
                this.getOrCreateConfiguration(target).setProxyUser((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                this.getOrCreateConfiguration(target).setServerUrl((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sessioncookie": 
            case "sessionCookie": {
                this.getOrCreateConfiguration(target).setSessionCookie((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sockettimeout": 
            case "socketTimeout": {
                this.getOrCreateConfiguration(target).setSocketTimeout((Integer)FhirComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "summary": {
                this.getOrCreateConfiguration(target).setSummary((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "validationmode": 
            case "validationMode": {
                this.getOrCreateConfiguration(target).setValidationMode((String)FhirComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                return String.class;
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "client": {
                return IGenericClient.class;
            }
            case "clientfactory": 
            case "clientFactory": {
                return IRestfulClientFactory.class;
            }
            case "compress": {
                return Boolean.TYPE;
            }
            case "configuration": {
                return FhirConfiguration.class;
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return Integer.class;
            }
            case "defermodelscanning": 
            case "deferModelScanning": {
                return Boolean.TYPE;
            }
            case "encoding": {
                return String.class;
            }
            case "fhircontext": 
            case "fhirContext": {
                return FhirContext.class;
            }
            case "fhirversion": 
            case "fhirVersion": {
                return String.class;
            }
            case "forceconformancecheck": 
            case "forceConformanceCheck": {
                return Boolean.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "log": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "prettyprint": 
            case "prettyPrint": {
                return Boolean.TYPE;
            }
            case "proxyhost": 
            case "proxyHost": {
                return String.class;
            }
            case "proxypassword": 
            case "proxyPassword": {
                return String.class;
            }
            case "proxyport": 
            case "proxyPort": {
                return Integer.class;
            }
            case "proxyuser": 
            case "proxyUser": {
                return String.class;
            }
            case "serverurl": 
            case "serverUrl": {
                return String.class;
            }
            case "sessioncookie": 
            case "sessionCookie": {
                return String.class;
            }
            case "sockettimeout": 
            case "socketTimeout": {
                return Integer.class;
            }
            case "summary": {
                return String.class;
            }
            case "username": {
                return String.class;
            }
            case "validationmode": 
            case "validationMode": {
                return String.class;
            }
        }
        return null;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        FhirComponent target = (FhirComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesstoken": 
            case "accessToken": {
                return this.getOrCreateConfiguration(target).getAccessToken();
            }
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "client": {
                return this.getOrCreateConfiguration(target).getClient();
            }
            case "clientfactory": 
            case "clientFactory": {
                return this.getOrCreateConfiguration(target).getClientFactory();
            }
            case "compress": {
                return this.getOrCreateConfiguration(target).isCompress();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "connectiontimeout": 
            case "connectionTimeout": {
                return this.getOrCreateConfiguration(target).getConnectionTimeout();
            }
            case "defermodelscanning": 
            case "deferModelScanning": {
                return this.getOrCreateConfiguration(target).isDeferModelScanning();
            }
            case "encoding": {
                return this.getOrCreateConfiguration(target).getEncoding();
            }
            case "fhircontext": 
            case "fhirContext": {
                return this.getOrCreateConfiguration(target).getFhirContext();
            }
            case "fhirversion": 
            case "fhirVersion": {
                return this.getOrCreateConfiguration(target).getFhirVersion();
            }
            case "forceconformancecheck": 
            case "forceConformanceCheck": {
                return this.getOrCreateConfiguration(target).isForceConformanceCheck();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "log": {
                return this.getOrCreateConfiguration(target).isLog();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "prettyprint": 
            case "prettyPrint": {
                return this.getOrCreateConfiguration(target).isPrettyPrint();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxypassword": 
            case "proxyPassword": {
                return this.getOrCreateConfiguration(target).getProxyPassword();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyuser": 
            case "proxyUser": {
                return this.getOrCreateConfiguration(target).getProxyUser();
            }
            case "serverurl": 
            case "serverUrl": {
                return this.getOrCreateConfiguration(target).getServerUrl();
            }
            case "sessioncookie": 
            case "sessionCookie": {
                return this.getOrCreateConfiguration(target).getSessionCookie();
            }
            case "sockettimeout": 
            case "socketTimeout": {
                return this.getOrCreateConfiguration(target).getSocketTimeout();
            }
            case "summary": {
                return this.getOrCreateConfiguration(target).getSummary();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
            case "validationmode": 
            case "validationMode": {
                return this.getOrCreateConfiguration(target).getValidationMode();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Encoding", String.class);
        map.put("FhirVersion", String.class);
        map.put("Log", Boolean.TYPE);
        map.put("PrettyPrint", Boolean.TYPE);
        map.put("ServerUrl", String.class);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("AutowiredEnabled", Boolean.TYPE);
        map.put("Client", IGenericClient.class);
        map.put("ClientFactory", IRestfulClientFactory.class);
        map.put("Compress", Boolean.TYPE);
        map.put("Configuration", FhirConfiguration.class);
        map.put("ConnectionTimeout", Integer.class);
        map.put("DeferModelScanning", Boolean.TYPE);
        map.put("FhirContext", FhirContext.class);
        map.put("ForceConformanceCheck", Boolean.TYPE);
        map.put("SessionCookie", String.class);
        map.put("SocketTimeout", Integer.class);
        map.put("Summary", String.class);
        map.put("ValidationMode", String.class);
        map.put("ProxyHost", String.class);
        map.put("ProxyPassword", String.class);
        map.put("ProxyPort", Integer.class);
        map.put("ProxyUser", String.class);
        map.put("AccessToken", String.class);
        map.put("Password", String.class);
        map.put("Username", String.class);
        ALL_OPTIONS = map;
    }
}

