/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.drive;

import com.google.api.client.http.FileContent;
import com.google.api.client.http.InputStreamContent;
import java.io.File;
import java.io.InputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;

@Converter(generateLoader=true)
public final class GoogleDriveFilesConverter {
    private GoogleDriveFilesConverter() {
    }

    @Converter
    public static com.google.api.services.drive.model.File genericFileToGoogleDriveFile(GenericFile<?> file, Exchange exchange) throws Exception {
        if (file.getFile() instanceof File) {
            File f = (File)file.getFile();
            com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
            fileMetadata.setName(f.getName());
            FileContent mediaContent = new FileContent(null, f);
            if (exchange != null) {
                exchange.getIn().setHeader("CamelGoogleDrive.content", (Object)fileMetadata);
                exchange.getIn().setHeader("CamelGoogleDrive.mediaContent", (Object)mediaContent);
            }
            return fileMetadata;
        }
        if (exchange != null) {
            file.getBinding().loadContent(exchange, file);
            InputStream is = (InputStream)exchange.getContext().getTypeConverter().convertTo(InputStream.class, exchange, file.getBody());
            com.google.api.services.drive.model.File fileMetadata = new com.google.api.services.drive.model.File();
            fileMetadata.setName(file.getFileName());
            InputStreamContent mediaContent = new InputStreamContent(null, is);
            exchange.getIn().setHeader("CamelGoogleDrive.content", (Object)fileMetadata);
            exchange.getIn().setHeader("CamelGoogleDrive.mediaContent", (Object)mediaContent);
            return fileMetadata;
        }
        return null;
    }
}

