/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanConstants;
import org.apache.camel.component.infinispan.InfinispanUtil;
import org.apache.camel.component.infinispan.remote.InfinispanRemoteOperation;
import org.apache.camel.util.ObjectHelper;
import org.infinispan.Cache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.query.dsl.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InfinispanOperation {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(InfinispanOperation.class);

    private InfinispanOperation() {
    }

    public static void process(Exchange exchange, InfinispanConfiguration configuration, BasicCache<Object, Object> cache) {
        Message in = exchange.getIn();
        Operation operation = InfinispanOperation.getOperation(in, configuration);
        operation.execute(configuration, exchange.getIn().getHeader("CamelInfinispanIgnoreReturnValues") != null ? cache : InfinispanUtil.ignoreReturnValuesCache(cache), in);
    }

    private static Operation getOperation(Message message, InfinispanConfiguration configuration) {
        String operation = (String)message.getHeader("CamelInfinispanOperation", String.class);
        if (operation == null) {
            operation = configuration.hasCommand() ? "CamelInfinispanOperation" + configuration.getCommand() : "CamelInfinispanOperationPut";
        }
        LOGGER.trace("Operation: [{}]", (Object)operation);
        return Operation.fromOperation(operation);
    }

    private static enum Operation {
        PUT{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                Object result;
                if (this.hasLifespan(message)) {
                    long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
                    if (this.hasMaxIdleTime(message)) {
                        long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                        result = cache.put(this.getKey(message), this.getValue(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    } else {
                        result = cache.put(this.getKey(message), this.getValue(message), lifespan, timeUnit);
                    }
                } else {
                    result = cache.put(this.getKey(message), this.getValue(message));
                }
                this.setResult(result, message);
            }
        }
        ,
        PUTASYNC{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                NotifyingFuture result;
                if (this.hasLifespan(message)) {
                    long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
                    if (this.hasMaxIdleTime(message)) {
                        long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                        result = cache.putAsync(this.getKey(message), this.getValue(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    } else {
                        result = cache.putAsync(this.getKey(message), this.getValue(message), lifespan, timeUnit);
                    }
                } else {
                    result = cache.putAsync(this.getKey(message), this.getValue(message));
                }
                this.setResult(result, message);
            }
        }
        ,
        PUTALL{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                if (this.hasLifespan(message)) {
                    long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
                    if (this.hasMaxIdleTime(message)) {
                        long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                        cache.putAll(this.getMap(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    } else {
                        cache.putAll(this.getMap(message), lifespan, timeUnit);
                    }
                } else {
                    cache.putAll(this.getMap(message));
                }
            }
        }
        ,
        PUTALLASYNC{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                NotifyingFuture result;
                if (this.hasLifespan(message)) {
                    long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
                    if (this.hasMaxIdleTime(message)) {
                        long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                        result = cache.putAllAsync(this.getMap(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    } else {
                        result = cache.putAllAsync(this.getMap(message), lifespan, timeUnit);
                    }
                } else {
                    result = cache.putAllAsync(this.getMap(message));
                }
                this.setResult(result, message);
            }
        }
        ,
        PUTIFABSENT{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                Object result;
                if (this.hasLifespan(message)) {
                    long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
                    if (this.hasMaxIdleTime(message)) {
                        long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                        result = cache.putIfAbsent(this.getKey(message), this.getValue(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    } else {
                        result = cache.putIfAbsent(this.getKey(message), this.getValue(message), lifespan, timeUnit);
                    }
                } else {
                    result = cache.putIfAbsent(this.getKey(message), this.getValue(message));
                }
                this.setResult(result, message);
            }
        }
        ,
        PUTIFABSENTASYNC{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                NotifyingFuture result;
                if (this.hasLifespan(message)) {
                    long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
                    if (this.hasMaxIdleTime(message)) {
                        long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                        result = cache.putIfAbsentAsync(this.getKey(message), this.getValue(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    } else {
                        result = cache.putIfAbsentAsync(this.getKey(message), this.getValue(message), lifespan, timeUnit);
                    }
                } else {
                    result = cache.putIfAbsentAsync(this.getKey(message), this.getValue(message));
                }
                this.setResult(result, message);
            }
        }
        ,
        GET{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                this.setResult(cache.get(this.getKey(message)), message);
            }
        }
        ,
        CONTAINSKEY{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                this.setResult(cache.containsKey(this.getKey(message)), message);
            }
        }
        ,
        CONTAINSVALUE{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                this.setResult(cache.containsValue(this.getValue(message)), message);
            }
        }
        ,
        REMOVE{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                Object result = ObjectHelper.isEmpty((Object)this.getValue(message)) ? cache.remove(this.getKey(message)) : Boolean.valueOf(cache.remove(this.getKey(message), this.getValue(message)));
                this.setResult(result, message);
            }
        }
        ,
        REMOVEASYNC{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                NotifyingFuture result = ObjectHelper.isEmpty((Object)this.getValue(message)) ? cache.removeAsync(this.getKey(message)) : cache.removeAsync(this.getKey(message), this.getValue(message));
                this.setResult(result, message);
            }
        }
        ,
        REPLACE{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                Object result;
                if (this.hasLifespan(message)) {
                    long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
                    if (this.hasMaxIdleTime(message)) {
                        long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                        result = ObjectHelper.isEmpty((Object)this.getOldValue(message)) ? cache.replace(this.getKey(message), this.getValue(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit) : Boolean.valueOf(cache.replace(this.getKey(message), this.getOldValue(message), this.getValue(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit));
                    } else {
                        result = ObjectHelper.isEmpty((Object)this.getOldValue(message)) ? cache.replace(this.getKey(message), this.getValue(message), lifespan, timeUnit) : Boolean.valueOf(cache.replace(this.getKey(message), this.getOldValue(message), this.getValue(message), lifespan, timeUnit));
                    }
                } else {
                    result = ObjectHelper.isEmpty((Object)this.getOldValue(message)) ? cache.replace(this.getKey(message), this.getValue(message)) : Boolean.valueOf(cache.replace(this.getKey(message), this.getOldValue(message), this.getValue(message)));
                }
                this.setResult(result, message);
            }
        }
        ,
        REPLACEASYNC{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                NotifyingFuture result;
                if (this.hasLifespan(message)) {
                    long lifespan = (Long)message.getHeader("CamelInfinispanLifespanTime", Long.TYPE);
                    TimeUnit timeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanTimeUnit", TimeUnit.class));
                    if (this.hasMaxIdleTime(message)) {
                        long maxIdle = (Long)message.getHeader("CamelInfinispanMaxIdleTime", Long.TYPE);
                        TimeUnit maxIdleTimeUnit = (TimeUnit)((Object)message.getHeader("CamelInfinispanMaxIdleTimeUnit", TimeUnit.class));
                        result = ObjectHelper.isEmpty((Object)this.getOldValue(message)) ? cache.replaceAsync(this.getKey(message), this.getValue(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit) : cache.replaceAsync(this.getKey(message), this.getOldValue(message), this.getValue(message), lifespan, timeUnit, maxIdle, maxIdleTimeUnit);
                    } else {
                        result = ObjectHelper.isEmpty((Object)this.getOldValue(message)) ? cache.replaceAsync(this.getKey(message), this.getValue(message), lifespan, timeUnit) : cache.replaceAsync(this.getKey(message), this.getOldValue(message), this.getValue(message), lifespan, timeUnit);
                    }
                } else {
                    result = ObjectHelper.isEmpty((Object)this.getOldValue(message)) ? cache.replaceAsync(this.getKey(message), this.getValue(message)) : cache.replaceAsync(this.getKey(message), this.getOldValue(message), this.getValue(message));
                }
                this.setResult(result, message);
            }
        }
        ,
        SIZE{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                this.setResult(cache.size(), message);
            }
        }
        ,
        CLEAR{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                cache.clear();
            }
        }
        ,
        CLEARASYNC{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                this.setResult(cache.clearAsync(), message);
            }
        }
        ,
        QUERY{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                Query query = this.getQuery(configuration, cache, message);
                if (query == null) {
                    return;
                }
                this.setResult(query.list(), message);
            }
        }
        ,
        STATS{

            @Override
            void execute(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
                LOGGER.warn("You'll need to enable statistics to obtain meaningful data from your cache");
                this.setResult(((Cache)cache).getAdvancedCache().getStats(), message);
            }
        };

        private static final Operation[] OPERATIONS;

        void setResult(Object result, Message message) {
            message.setHeader("CamelInfinispanOperationResult", result);
        }

        Object getKey(Message message) {
            return message.getHeader("CamelInfinispanKey");
        }

        Object getValue(Message message) {
            return message.getHeader("CamelInfinispanValue");
        }

        Object getOldValue(Message message) {
            return message.getHeader("CamelInfinispanOldValue");
        }

        Map<? extends Object, ? extends Object> getMap(Message message) {
            return (Map)message.getHeader("CamelInfinispanMap");
        }

        Query getQuery(InfinispanConfiguration configuration, BasicCache<Object, Object> cache, Message message) {
            if (InfinispanUtil.isRemote(cache)) {
                return InfinispanRemoteOperation.buildQuery(configuration, cache, message);
            }
            return null;
        }

        boolean hasLifespan(Message message) {
            return !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanLifespanTime") && !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanTimeUnit");
        }

        boolean hasMaxIdleTime(Message message) {
            return !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanMaxIdleTime") && !InfinispanUtil.isHeaderEmpty(message, "CamelInfinispanMaxIdleTimeUnit");
        }

        abstract void execute(InfinispanConfiguration var1, BasicCache<Object, Object> var2, Message var3);

        public static Operation fromOperation(String operation) {
            for (int i = OPERATIONS.length - 1; i >= 0; --i) {
                String name = OPERATIONS[i].name();
                int len = name.length();
                if (len != operation.length() - InfinispanConstants.OPERATION_LEN || !name.regionMatches(true, 0, operation, InfinispanConstants.OPERATION_LEN, len)) continue;
                return OPERATIONS[i];
            }
            throw new IllegalArgumentException("Unknown Operation for string: " + operation);
        }

        static {
            OPERATIONS = Operation.values();
        }
    }
}

