/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.infinispan.InfinispanConfiguration;
import org.apache.camel.component.infinispan.InfinispanEndpoint;
import org.apache.camel.component.infinispan.InfinispanManager;
import org.apache.camel.component.infinispan.InfinispanOperation;
import org.apache.camel.impl.DefaultProducer;

public class InfinispanProducer
extends DefaultProducer {
    private final InfinispanConfiguration configuration;
    private final InfinispanManager manager;

    public InfinispanProducer(InfinispanEndpoint endpoint, InfinispanConfiguration configuration) {
        super((Endpoint)endpoint);
        this.configuration = configuration;
        this.manager = new InfinispanManager(endpoint.getCamelContext(), configuration);
    }

    public void process(Exchange exchange) throws Exception {
        InfinispanOperation.process(exchange, this.configuration, this.manager.getCache(exchange));
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.manager.start();
    }

    protected void doStop() throws Exception {
        this.manager.stop();
        super.doStop();
    }
}

