/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty9;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.camel.component.jetty.CamelHttpClient;
import org.apache.camel.component.jetty.JettyHttpComponent;
import org.apache.camel.component.jetty.JettyHttpEndpoint;
import org.apache.camel.component.jetty9.CamelHttpClient9;
import org.apache.camel.component.jetty9.JettyHttpEndpoint9;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ForwardedRequestCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class JettyHttpComponent9
extends JettyHttpComponent {
    protected CamelHttpClient createCamelHttpClient(HttpClientTransport transport, SslContextFactory sslContextFactory) {
        return new CamelHttpClient9(transport, sslContextFactory);
    }

    protected JettyHttpEndpoint createEndpoint(URI endpointUri, URI httpUri) throws URISyntaxException {
        return new JettyHttpEndpoint9(this, endpointUri.toString(), httpUri);
    }

    protected Connector getSslSocketConnector(Server server, JettyHttpEndpoint endpoint) {
        Connector answer = null;
        if (answer == null) {
            answer = this.createConnector(server, endpoint);
        }
        return answer;
    }

    protected AbstractConnector createConnectorJettyInternal(Server server, JettyHttpEndpoint endpoint, SslContextFactory sslcf) {
        try {
            String hosto = endpoint.getHttpUri().getHost();
            int porto = endpoint.getPort();
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendServerVersion(endpoint.isSendServerVersion());
            httpConfig.setSendDateHeader(endpoint.isSendDateHeader());
            httpConfig.setSendDateHeader(endpoint.isSendDateHeader());
            if (this.requestBufferSize != null) {
                // empty if block
            }
            if (this.requestHeaderSize != null) {
                httpConfig.setRequestHeaderSize(this.requestHeaderSize.intValue());
            }
            if (this.responseBufferSize != null) {
                httpConfig.setOutputBufferSize(this.responseBufferSize.intValue());
            }
            if (this.responseHeaderSize != null) {
                httpConfig.setResponseHeaderSize(this.responseHeaderSize.intValue());
            }
            if (this.useXForwardedForHeader) {
                httpConfig.addCustomizer((HttpConfiguration.Customizer)new ForwardedRequestCustomizer());
            }
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            ServerConnector result = new ServerConnector(server);
            if (sslcf != null) {
                httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
                SslConnectionFactory scf = new SslConnectionFactory(sslcf, "HTTP/1.1");
                connectionFactories.add(scf);
                result.setDefaultProtocol(scf.getProtocol());
            }
            connectionFactories.add(httpFactory);
            result.setConnectionFactories(connectionFactories);
            result.setPort(porto);
            if (hosto != null) {
                result.setHost(hosto);
            }
            if (this.getSslSocketConnectorProperties() != null && "https".equals(endpoint.getProtocol())) {
                HashMap properties = new HashMap(this.getSslSocketConnectorProperties());
                IntrospectionSupport.setProperties((Object)sslcf, properties);
                if (properties.size() > 0) {
                    throw new IllegalArgumentException("There are " + properties.size() + " parameters that couldn't be set on the SocketConnector. Check the uri if the parameters are spelt correctly and that they are properties of the SelectChannelConnector. Unknown parameters=[" + properties + "]");
                }
            }
            return result;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
    }
}

