/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jira.JIRAComponent;
import org.apache.camel.component.jira.JIRAType;
import org.apache.camel.component.jira.consumer.NewCommentConsumer;
import org.apache.camel.component.jira.consumer.NewIssueConsumer;
import org.apache.camel.component.jira.producer.NewIssueProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="jira", title="JIRA", syntax="jira:type", label="api,reporting")
public class JIRAEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private JIRAType type;
    @UriParam
    @Metadata(required="true")
    private String serverUrl;
    @UriParam
    private String username;
    @UriParam
    private String password;
    @UriParam(label="consumer")
    private String jql;
    @UriParam(label="consumer", defaultValue="6000")
    private int delay = 6000;

    public JIRAEndpoint(String uri, JIRAComponent component) {
        super(uri, (Component)component);
    }

    public Producer createProducer() throws Exception {
        if (this.type == JIRAType.NEWISSUE) {
            return new NewIssueProducer(this);
        }
        throw new IllegalArgumentException("Producer does not support type: " + (Object)((Object)this.type));
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.type == JIRAType.NEWCOMMENT) {
            return new NewCommentConsumer(this, processor);
        }
        if (this.type == JIRAType.NEWISSUE) {
            return new NewIssueConsumer(this, processor);
        }
        throw new IllegalArgumentException("Consumer does not support type: " + (Object)((Object)this.type));
    }

    public boolean isSingleton() {
        return true;
    }

    public JIRAType getType() {
        return this.type;
    }

    public void setType(JIRAType type) {
        this.type = type;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getJql() {
        return this.jql;
    }

    public void setJql(String jql) {
        this.jql = jql;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }
}

