/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.JiraRestClient;
import com.atlassian.jira.rest.client.SearchRestClient;
import com.atlassian.jira.rest.client.domain.BasicIssue;
import com.atlassian.jira.rest.client.domain.SearchResult;
import com.atlassian.jira.rest.client.internal.jersey.JerseyJiraRestClientFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JIRAEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.camel.spi.Registry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJIRAConsumer
extends ScheduledPollConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(AbstractJIRAConsumer.class);
    private final JIRAEndpoint endpoint;
    private final JiraRestClient client;

    public AbstractJIRAConsumer(JIRAEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        JerseyJiraRestClientFactory factory;
        this.endpoint = endpoint;
        this.setDelay(endpoint.getDelay());
        Registry registry = endpoint.getCamelContext().getRegistry();
        Object target = registry.lookupByName("JerseyJiraRestClientFactory");
        if (target != null) {
            LOG.debug("JerseyJiraRestClientFactory found in registry " + target.getClass().getCanonicalName());
            factory = (JerseyJiraRestClientFactory)target;
        } else {
            factory = new JerseyJiraRestClientFactory();
        }
        URI jiraServerUri = URI.create(endpoint.getServerUrl());
        this.client = factory.createWithBasicHttpAuthentication(jiraServerUri, endpoint.getUsername(), endpoint.getPassword());
    }

    protected List<BasicIssue> getIssues() {
        return this.getIssues(this.endpoint.getJql(), 0, 0, 500);
    }

    protected List<BasicIssue> getIssues(String jql, int start, int maxResults, int maxPerQuery) {
        LOG.info("Indexing current JIRA issues...");
        ArrayList<BasicIssue> issues = new ArrayList<BasicIssue>();
        while (true) {
            SearchRestClient searchRestClient = this.client.getSearchClient();
            SearchResult searchResult = searchRestClient.searchJqlWithFullIssues(jql, maxPerQuery, start, null);
            for (BasicIssue issue : searchResult.getIssues()) {
                issues.add(issue);
            }
            if (start >= searchResult.getTotal() || maxResults > 0 && issues.size() >= maxResults) break;
            start += maxPerQuery;
        }
        return issues;
    }

    protected JiraRestClient client() {
        return this.client;
    }

    protected abstract int poll() throws Exception;
}

