/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.consumer;

import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.Issue;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.component.jira.consumer.AbstractJiraConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewCommentsConsumer
extends AbstractJiraConsumer {
    private static final transient Logger LOG = LoggerFactory.getLogger(NewCommentsConsumer.class);
    private Long lastCommentId = -1L;

    public NewCommentsConsumer(JiraEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected int poll() throws Exception {
        int max;
        List<Comment> newComments = this.getComments();
        for (int i = max = newComments.size() - 1; i > -1; --i) {
            Comment newComment = newComments.get(i);
            Exchange e = this.createExchange(true);
            e.getIn().setBody((Object)newComment);
            this.getProcessor().process(e);
        }
        return newComments.size();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getComments();
    }

    private List<Comment> getComments() {
        LOG.debug("Start: Jira NewCommentsConsumer: retrieving issue comments. Last comment id: {}", (Object)this.lastCommentId);
        ArrayList<Comment> newComments = new ArrayList<Comment>();
        List<Issue> issues = this.getIssues();
        for (Issue issue : issues) {
            Issue fullIssue = (Issue)this.client().getIssueClient().getIssue(issue.getKey()).claim();
            for (Comment comment : fullIssue.getComments()) {
                if (comment.getId() <= this.lastCommentId) continue;
                newComments.add(comment);
            }
        }
        for (Comment c : newComments) {
            if (c.getId() <= this.lastCommentId) continue;
            this.lastCommentId = c.getId();
        }
        LOG.debug("End: Jira NewCommentsConsumer: retrieving issue comments. {} new comments since last run.", (Object)newComments.size());
        return newComments;
    }
}

