/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.oauth;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClientFactory;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.Properties;
import org.apache.camel.component.jira.oauth.OAuthHttpClientDecorator;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthAsynchronousHttpClientFactory {
    private static final String JIRA_REST_CLIENT_VERSION = MavenUtils.getVersion("com.atlassian.jira", "jira-rest-java-client-api");

    public DisposableHttpClient createClient(URI serverUri, AuthenticationHandler authenticationHandler) {
        HttpClientOptions options = new HttpClientOptions();
        final DefaultHttpClientFactory defaultHttpClientFactory = new DefaultHttpClientFactory((EventPublisher)new NoOpEventPublisher(), (ApplicationProperties)new RestClientApplicationProperties(serverUri), new ThreadLocalContextManager(){

            public Object getThreadLocalContext() {
                return null;
            }

            public void setThreadLocalContext(Object context) {
            }

            public void clearThreadLocalContext() {
            }
        });
        final HttpClient httpClient = defaultHttpClientFactory.create(options);
        return new OAuthHttpClientDecorator(httpClient, authenticationHandler){

            public void destroy() throws Exception {
                defaultHttpClientFactory.dispose(httpClient);
            }
        };
    }

    private static final class MavenUtils {
        private static final Logger LOG = LoggerFactory.getLogger(MavenUtils.class);
        private static final String UNKNOWN_VERSION = "unknown";

        private MavenUtils() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static String getVersion(String groupId, String artifactId) {
            Properties props = new Properties();
            String pomProps = String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId);
            try (InputStream resourceAsStream = ObjectHelper.loadResourceAsStream((String)pomProps, (ClassLoader)OAuthAsynchronousHttpClientFactory.class.getClassLoader());){
                props.load(resourceAsStream);
                String string = props.getProperty("version", UNKNOWN_VERSION);
                return string;
            }
            catch (Exception e) {
                LOG.debug("Could not find version for Jira Rest Java Client maven artifact {}:{}. Error: {}", new Object[]{groupId, artifactId, e.getMessage()});
                return UNKNOWN_VERSION;
            }
        }
    }

    private static final class RestClientApplicationProperties
    implements ApplicationProperties {
        private final String baseUrl;

        private RestClientApplicationProperties(URI jiraURI) {
            this.baseUrl = jiraURI.getPath();
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        public String getBaseUrl(UrlMode urlMode) {
            return this.baseUrl;
        }

        public String getDisplayName() {
            return "Atlassian JIRA Rest Java Client";
        }

        public String getPlatformId() {
            return "jira";
        }

        public String getVersion() {
            return JIRA_REST_CLIENT_VERSION;
        }

        public Date getBuildDate() {
            throw new UnsupportedOperationException();
        }

        public String getBuildNumber() {
            return String.valueOf(0);
        }

        public File getHomeDirectory() {
            return new File(".");
        }

        public String getPropertyValue(String s) {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    private static class NoOpEventPublisher
    implements EventPublisher {
        private NoOpEventPublisher() {
        }

        public void publish(Object o) {
        }

        public void register(Object o) {
        }

        public void unregister(Object o) {
        }

        public void unregisterAll() {
        }
    }
}

