/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jira.producer;

import com.atlassian.jira.rest.client.api.IssueRestClient;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import java.util.ArrayList;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.jira.JiraEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class AddIssueProducer
extends DefaultProducer {
    public AddIssueProducer(JiraEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) {
        JiraRestClient client = ((JiraEndpoint)this.getEndpoint()).getClient();
        String projectKey = (String)exchange.getIn().getHeader("ProjectKey", String.class);
        Long issueTypeId = (Long)exchange.getIn().getHeader("IssueTypeId", Long.class);
        String issueTypeName = (String)exchange.getIn().getHeader("IssueTypeName", String.class);
        String summary = (String)exchange.getIn().getHeader("IssueSummary", String.class);
        String assigneeName = (String)exchange.getIn().getHeader("IssueAssignee", String.class);
        String priorityName = (String)exchange.getIn().getHeader("IssuePriorityName", String.class);
        Long priorityId = (Long)exchange.getIn().getHeader("IssuePriorityId", Long.class);
        String components = (String)exchange.getIn().getHeader("IssueComponents", String.class);
        String watchers = (String)exchange.getIn().getHeader("IssueWatchersAdd", String.class);
        if (issueTypeId == null && issueTypeName != null) {
            Iterable issueTypes = (Iterable)client.getMetadataClient().getIssueTypes().claim();
            for (IssueType type : issueTypes) {
                if (!issueTypeName.equals(type.getName())) continue;
                issueTypeId = type.getId();
                break;
            }
        }
        if (priorityId == null && priorityName != null) {
            Iterable priorities = (Iterable)client.getMetadataClient().getPriorities().claim();
            for (Priority pri : priorities) {
                if (!priorityName.equals(pri.getName())) continue;
                priorityId = pri.getId();
                break;
            }
        }
        if (projectKey == null) {
            throw new IllegalArgumentException("A valid project key is required.");
        }
        if (issueTypeId == null) {
            throw new IllegalArgumentException("A valid issue type id is required, actual: id(" + null + "), name(" + issueTypeName + ")");
        }
        if (summary == null) {
            throw new IllegalArgumentException("A summary field is required.");
        }
        IssueInputBuilder builder = new IssueInputBuilder(projectKey, issueTypeId);
        builder.setDescription((String)exchange.getIn().getBody(String.class));
        builder.setSummary(summary);
        if (ObjectHelper.isNotEmpty((Object)components)) {
            String[] compArr = components.split(",");
            ArrayList<String> comps = new ArrayList<String>(compArr.length);
            for (String s : compArr) {
                String c = s.trim();
                if (c.length() <= 0) continue;
                comps.add(c);
            }
            builder.setComponentsNames(comps);
        }
        if (priorityId != null) {
            builder.setPriorityId(priorityId);
        }
        if (assigneeName != null) {
            builder.setAssigneeName(assigneeName);
        }
        IssueRestClient issueClient = client.getIssueClient();
        BasicIssue issueCreated = (BasicIssue)issueClient.createIssue(builder.build()).claim();
        Issue issue = (Issue)issueClient.getIssue(issueCreated.getKey()).claim();
        if (ObjectHelper.isNotEmpty((Object)watchers)) {
            String[] watArr;
            for (String s : watArr = watchers.split(",")) {
                String watcher = s.trim();
                if (watcher.length() <= 0) continue;
                issueClient.addWatcher(issue.getWatchers().getSelf(), watcher);
            }
        }
        if (exchange.getPattern().isOutCapable()) {
            exchange.getMessage().copyFrom(exchange.getIn());
            exchange.getMessage().setBody((Object)issue);
        } else {
            exchange.getIn().setBody((Object)issue);
        }
    }
}

