/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa;

import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.LockModeType;
import java.util.Hashtable;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.PollingConsumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.jpa.DefaultTransactionStrategy;
import org.apache.camel.component.jpa.DeleteHandler;
import org.apache.camel.component.jpa.JpaComponent;
import org.apache.camel.component.jpa.JpaConstants;
import org.apache.camel.component.jpa.JpaConsumer;
import org.apache.camel.component.jpa.JpaPollingConsumer;
import org.apache.camel.component.jpa.JpaProducer;
import org.apache.camel.component.jpa.TransactionStrategy;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.ScheduledPollEndpoint;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.PropertiesHelper;
import org.springframework.orm.jpa.LocalEntityManagerFactoryBean;
import org.springframework.orm.jpa.SharedEntityManagerCreator;

@UriEndpoint(firstVersion="1.0.0", scheme="jpa", title="JPA", syntax="jpa:entityType", category={Category.DATABASE}, headersClass=JpaConstants.class)
public class JpaEndpoint
extends ScheduledPollEndpoint {
    private EntityManagerFactory entityManagerFactory;
    private TransactionStrategy transactionStrategy;
    private Expression producerExpression;
    @UriPath(description="Entity class name")
    @Metadata(required=true)
    private Class<?> entityType;
    @UriParam(defaultValue="camel")
    @Metadata(required=true)
    private String persistenceUnit = "camel";
    @UriParam(defaultValue="true")
    private boolean joinTransaction = true;
    @UriParam(label="advanced")
    private boolean sharedEntityManager;
    @UriParam(defaultValue="-1")
    private int maximumResults = -1;
    @UriParam(label="producer", defaultValue="-1")
    private int firstResult = -1;
    @UriParam(label="consumer", defaultValue="true")
    private boolean consumeDelete = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean consumeLockEntity = true;
    @UriParam(label="consumer")
    private int maxMessagesPerPoll;
    @UriParam
    private String query;
    @UriParam
    private String namedQuery;
    @UriParam
    private String nativeQuery;
    @UriParam(label="consumer", defaultValue="PESSIMISTIC_WRITE")
    private LockModeType lockModeType = LockModeType.PESSIMISTIC_WRITE;
    @UriParam(label="consumer,advanced", multiValue=true, prefix="parameters.")
    private Map<String, Object> parameters;
    @UriParam
    private Class<?> resultClass;
    @UriParam(label="consumer")
    private boolean transacted;
    @UriParam(label="consumer")
    private boolean skipLockedEntity;
    @UriParam(label="consumer")
    private DeleteHandler<Object> deleteHandler;
    @UriParam(label="consumer")
    private DeleteHandler<Object> preDeleteHandler;
    @UriParam(label="producer", defaultValue="true")
    private boolean flushOnSend = true;
    @UriParam(label="producer")
    private boolean usePersist;
    @UriParam(label="producer,advanced")
    private boolean usePassedInEntityManager;
    @UriParam(label="producer")
    private boolean remove;
    @UriParam(label="producer")
    private Boolean useExecuteUpdate;
    @UriParam(label="producer")
    private boolean findEntity;
    @UriParam(label="producer", defaultValue="false")
    private boolean singleResult;
    @UriParam(label="producer")
    private String outputTarget;
    @UriParam(label="advanced", prefix="emf.", multiValue=true)
    private Map<String, Object> entityManagerProperties;

    public JpaEndpoint() {
    }

    public JpaEndpoint(String uri, JpaComponent component) {
        super(uri, (Component)component);
    }

    public JpaComponent getComponent() {
        return (JpaComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        this.validate();
        JpaProducer producer = new JpaProducer(this, this.getProducerExpression());
        producer.setQuery(this.getQuery());
        producer.setNamedQuery(this.getNamedQuery());
        producer.setNativeQuery(this.getNativeQuery());
        producer.setParameters(this.getParameters());
        producer.setResultClass(this.getResultClass());
        producer.setFindEntity(this.isFindEntity());
        producer.setUseExecuteUpdate(this.getUseExecuteUpdate());
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        this.validate();
        JpaConsumer consumer = new JpaConsumer(this, processor);
        consumer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        consumer.setQuery(this.getQuery());
        consumer.setNamedQuery(this.getNamedQuery());
        consumer.setNativeQuery(this.getNativeQuery());
        consumer.setLockModeType(this.getLockModeType());
        consumer.setParameters(this.getParameters());
        consumer.setResultClass(this.getResultClass());
        consumer.setTransacted(this.isTransacted());
        consumer.setSkipLockedEntity(this.isSkipLockedEntity());
        consumer.setDeleteHandler(this.getDeleteHandler());
        consumer.setPreDeleteHandler(this.getPreDeleteHandler());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public PollingConsumer createPollingConsumer() throws Exception {
        JpaPollingConsumer consumer = new JpaPollingConsumer(this);
        consumer.setQuery(this.getQuery());
        consumer.setNamedQuery(this.getNamedQuery());
        consumer.setNativeQuery(this.getNativeQuery());
        consumer.setLockModeType(this.getLockModeType());
        consumer.setParameters(this.getParameters());
        consumer.setResultClass(this.getResultClass());
        return consumer;
    }

    public void configureProperties(Map<String, Object> options) {
        Map emProperties = PropertiesHelper.extractProperties(options, (String)"emf.");
        if (!emProperties.isEmpty()) {
            this.setEntityManagerProperties(emProperties);
        }
        super.configureProperties(options);
    }

    protected String createEndpointUri() {
        return "jpa" + (String)(this.entityType != null ? "://" + this.entityType.getName() : "");
    }

    public Expression getProducerExpression() {
        if (this.producerExpression == null) {
            this.producerExpression = this.createProducerExpression();
        }
        return this.producerExpression;
    }

    public void setProducerExpression(Expression producerExpression) {
        this.producerExpression = producerExpression;
    }

    public int getMaximumResults() {
        return this.maximumResults;
    }

    public void setMaximumResults(int maximumResults) {
        this.maximumResults = maximumResults;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public void setEntityType(Class<?> entityType) {
        this.entityType = entityType;
    }

    public EntityManagerFactory getEntityManagerFactory() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = this.createEntityManagerFactory();
        }
        return this.entityManagerFactory;
    }

    public void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public TransactionStrategy getTransactionStrategy() {
        if (this.transactionStrategy == null) {
            this.transactionStrategy = this.createTransactionStrategy();
        }
        return this.transactionStrategy;
    }

    public void setTransactionStrategy(TransactionStrategy transactionStrategy) {
        this.transactionStrategy = transactionStrategy;
    }

    public Map<String, Object> getEntityManagerProperties() {
        if (this.entityManagerProperties == null) {
            this.entityManagerProperties = CastUtils.cast((Hashtable)System.getProperties());
        }
        return this.entityManagerProperties;
    }

    public void setEntityManagerProperties(Map<String, Object> entityManagerProperties) {
        this.entityManagerProperties = entityManagerProperties;
    }

    public String getPersistenceUnit() {
        return this.persistenceUnit;
    }

    public void setPersistenceUnit(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    public boolean isConsumeDelete() {
        return this.consumeDelete;
    }

    public void setConsumeDelete(boolean consumeDelete) {
        this.consumeDelete = consumeDelete;
    }

    public boolean isConsumeLockEntity() {
        return this.consumeLockEntity;
    }

    public void setConsumeLockEntity(boolean consumeLockEntity) {
        this.consumeLockEntity = consumeLockEntity;
    }

    public boolean isFlushOnSend() {
        return this.flushOnSend;
    }

    public void setFlushOnSend(boolean flushOnSend) {
        this.flushOnSend = flushOnSend;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public boolean isUsePersist() {
        return this.usePersist;
    }

    public void setUsePersist(boolean usePersist) {
        this.usePersist = usePersist;
    }

    public boolean isRemove() {
        return this.remove;
    }

    public void setRemove(boolean isRemove) {
        this.remove = isRemove;
    }

    public boolean isJoinTransaction() {
        return this.joinTransaction;
    }

    public void setJoinTransaction(boolean joinTransaction) {
        this.joinTransaction = joinTransaction;
    }

    public boolean isUsePassedInEntityManager() {
        return this.usePassedInEntityManager;
    }

    public void setUsePassedInEntityManager(boolean usePassedIn) {
        this.usePassedInEntityManager = usePassedIn;
    }

    public boolean isSharedEntityManager() {
        return this.sharedEntityManager;
    }

    public void setSharedEntityManager(boolean sharedEntityManager) {
        this.sharedEntityManager = sharedEntityManager;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getNamedQuery() {
        return this.namedQuery;
    }

    public void setNamedQuery(String namedQuery) {
        this.namedQuery = namedQuery;
    }

    public String getNativeQuery() {
        return this.nativeQuery;
    }

    public void setNativeQuery(String nativeQuery) {
        this.nativeQuery = nativeQuery;
    }

    public LockModeType getLockModeType() {
        return this.lockModeType;
    }

    public void setLockModeType(LockModeType lockModeType) {
        this.lockModeType = lockModeType;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Class<?> getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(Class<?> resultClass) {
        this.resultClass = resultClass;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isSkipLockedEntity() {
        return this.skipLockedEntity;
    }

    public void setSkipLockedEntity(boolean skipLockedEntity) {
        this.skipLockedEntity = skipLockedEntity;
    }

    public DeleteHandler<Object> getDeleteHandler() {
        return this.deleteHandler;
    }

    public void setDeleteHandler(DeleteHandler<Object> deleteHandler) {
        this.deleteHandler = deleteHandler;
    }

    public DeleteHandler<Object> getPreDeleteHandler() {
        return this.preDeleteHandler;
    }

    public void setPreDeleteHandler(DeleteHandler<Object> preDeleteHandler) {
        this.preDeleteHandler = preDeleteHandler;
    }

    public Boolean getUseExecuteUpdate() {
        return this.useExecuteUpdate;
    }

    public void setUseExecuteUpdate(Boolean useExecuteUpdate) {
        this.useExecuteUpdate = useExecuteUpdate;
    }

    public boolean isFindEntity() {
        return this.findEntity;
    }

    public void setFindEntity(boolean findEntity) {
        this.findEntity = findEntity;
    }

    public boolean isSingleResult() {
        return this.singleResult;
    }

    public void setSingleResult(boolean singleResult) {
        this.singleResult = singleResult;
    }

    public String getOutputTarget() {
        return this.outputTarget;
    }

    public void setOutputTarget(String outputTarget) {
        this.outputTarget = outputTarget;
    }

    protected void validate() {
        ObjectHelper.notNull((Object)this.getEntityManagerFactory(), (String)"entityManagerFactory");
    }

    protected EntityManagerFactory createEntityManagerFactory() {
        LocalEntityManagerFactoryBean emfBean = new LocalEntityManagerFactoryBean();
        emfBean.setPersistenceUnitName(this.persistenceUnit);
        emfBean.setJpaPropertyMap(this.getEntityManagerProperties());
        emfBean.afterPropertiesSet();
        return emfBean.getObject();
    }

    @Deprecated
    protected EntityManager createEntityManager() {
        if (this.sharedEntityManager) {
            return SharedEntityManagerCreator.createSharedEntityManager((EntityManagerFactory)this.getEntityManagerFactory());
        }
        return this.getEntityManagerFactory().createEntityManager();
    }

    protected DefaultTransactionStrategy createTransactionStrategy() {
        return new DefaultTransactionStrategy(this.getCamelContext(), this.getEntityManagerFactory());
    }

    protected Expression createProducerExpression() {
        return new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                Object answer;
                try {
                    answer = JpaEndpoint.this.getEntityType() == null ? exchange.getIn().getMandatoryBody() : exchange.getIn().getMandatoryBody(JpaEndpoint.this.getEntityType());
                }
                catch (InvalidPayloadException e) {
                    throw new InvalidPayloadRuntimeException(exchange, JpaEndpoint.this.getEntityType(), e.getCause());
                }
                return answer;
            }
        };
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (this.entityManagerFactory == null && this.getComponent() != null) {
            this.entityManagerFactory = this.getComponent().getEntityManagerFactory();
        }
        if (this.transactionStrategy == null && this.getComponent() != null) {
            this.transactionStrategy = this.getComponent().getTransactionStrategy();
        }
    }
}

