/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka;

import org.apache.camel.Exchange;
import org.apache.camel.support.SynchronizationAdapter;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.KafkaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KafkaTransactionSynchronization
extends SynchronizationAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(KafkaTransactionSynchronization.class);
    private final String transactionId;
    private final Producer kafkaProducer;

    public KafkaTransactionSynchronization(String transactionId, Producer kafkaProducer) {
        this.transactionId = transactionId;
        this.kafkaProducer = kafkaProducer;
    }

    public void onDone(Exchange exchange) {
        try {
            if (exchange.getException() != null || exchange.isRollbackOnly()) {
                if (exchange.getException() instanceof KafkaException) {
                    LOG.warn("Catch {} and will close kafka producer with transaction {} ", (Object)exchange.getException(), (Object)this.transactionId);
                    this.kafkaProducer.close();
                } else {
                    LOG.warn("Abort kafka transaction {} with exchange {}", (Object)this.transactionId, (Object)exchange.getExchangeId());
                    this.kafkaProducer.abortTransaction();
                }
            } else {
                LOG.debug("Commit kafka transaction {} with exchange {}", (Object)this.transactionId, (Object)exchange.getExchangeId());
                this.kafkaProducer.commitTransaction();
            }
        }
        catch (KafkaException e) {
            exchange.setException((Throwable)e);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            LOG.warn("Abort kafka transaction {} with exchange {} due to {} ", new Object[]{this.transactionId, exchange.getExchangeId(), e.getMessage(), e});
            this.kafkaProducer.abortTransaction();
        }
        finally {
            exchange.getUnitOfWork().endTransactedBy((Object)this.transactionId);
        }
    }
}

