/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.producer.support;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaProducer;
import org.apache.kafka.common.header.Header;

public class PropagatedHeadersProvider {
    private final KafkaProducer kafkaProducer;
    private final Exchange parentExchange;
    private final Message parentMessage;
    private final List<Header> propagatedHeaders;

    public PropagatedHeadersProvider(KafkaProducer kafkaProducer, KafkaConfiguration configuration, Exchange parentExchange, Message parentMessage) {
        this.kafkaProducer = kafkaProducer;
        this.parentExchange = parentExchange;
        this.parentMessage = parentMessage;
        this.propagatedHeaders = configuration.isBatchWithIndividualHeaders() ? null : this.getDefaultHeaders();
    }

    public final List<Header> getDefaultHeaders() {
        return this.kafkaProducer.getPropagatedHeaders(this.parentExchange, this.parentMessage);
    }

    public List<Header> getHeaders(Exchange childExchange, Message childMessage) {
        if (this.propagatedHeaders != null) {
            return this.propagatedHeaders;
        }
        return this.kafkaProducer.getPropagatedHeaders(childExchange, childMessage);
    }
}

