/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import java.util.concurrent.ExecutorService;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.nats.NatsComponent;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsConsumer;
import org.apache.camel.component.nats.NatsProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="nats", title="Nats", syntax="nats:servers", label="messaging", consumerClass=NatsConsumer.class)
public class NatsEndpoint
extends DefaultEndpoint {
    @UriParam
    private NatsConfiguration configuration;

    public NatsEndpoint(String uri, NatsComponent component, NatsConfiguration config) {
        super(uri, (Component)component);
        this.configuration = config;
    }

    public Producer createProducer() throws Exception {
        return new NatsProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new NatsConsumer(this, processor);
    }

    public ExecutorService createExecutor() {
        return this.getCamelContext().getExecutorServiceManager().newFixedThreadPool((Object)this, "NatsTopic[" + this.configuration.getTopic() + "]", this.configuration.getPoolSize());
    }

    public boolean isSingleton() {
        return true;
    }

    public NatsConfiguration getNatsConfiguration() {
        return this.configuration;
    }
}

