/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.nats;

import io.nats.client.Connection;
import io.nats.client.ConnectionFactory;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.nats.NatsConfiguration;
import org.apache.camel.component.nats.NatsEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatsProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NatsProducer.class);
    private Connection connection;

    public NatsProducer(NatsEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public NatsEndpoint getEndpoint() {
        return (NatsEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        NatsConfiguration config = this.getEndpoint().getNatsConfiguration();
        String body = (String)exchange.getIn().getMandatoryBody(String.class);
        LOG.debug("Publishing to topic: {}", (Object)config.getTopic());
        if (ObjectHelper.isNotEmpty((Object)config.getReplySubject())) {
            String replySubject = config.getReplySubject();
            this.connection.publish(config.getTopic(), replySubject, body.getBytes());
        } else {
            this.connection.publish(config.getTopic(), body.getBytes());
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Starting Nats Producer");
        LOG.debug("Getting Nats Connection");
        this.connection = this.getConnection();
    }

    protected void doStop() throws Exception {
        super.doStop();
        LOG.debug("Stopping Nats Producer");
        LOG.debug("Closing Nats Connection");
        if (this.connection != null && !this.connection.isClosed()) {
            if (this.getEndpoint().getNatsConfiguration().isFlushConnection()) {
                LOG.debug("Flushing Nats Connection");
                this.connection.flush(this.getEndpoint().getNatsConfiguration().getFlushTimeout());
            }
            this.connection.close();
        }
    }

    private Connection getConnection() throws TimeoutException, IOException, GeneralSecurityException {
        Properties prop = this.getEndpoint().getNatsConfiguration().createProperties();
        ConnectionFactory factory = new ConnectionFactory(prop);
        if (this.getEndpoint().getNatsConfiguration().getSslContextParameters() != null && this.getEndpoint().getNatsConfiguration().isSecure()) {
            SSLContext sslCtx = this.getEndpoint().getNatsConfiguration().getSslContextParameters().createSSLContext(this.getEndpoint().getCamelContext());
            factory.setSSLContext(sslCtx);
            if (this.getEndpoint().getNatsConfiguration().isTlsDebug()) {
                factory.setTlsDebug(this.getEndpoint().getNatsConfiguration().isTlsDebug());
            }
        }
        this.connection = factory.createConnection();
        return this.connection;
    }
}

