/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.handlers;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.netty.NettyCamelState;
import org.apache.camel.component.netty.NettyHelper;
import org.apache.camel.component.netty.NettyPayloadHelper;
import org.apache.camel.component.netty.NettyProducer;
import org.apache.camel.util.ExchangeHelper;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientChannelHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger LOG = LoggerFactory.getLogger(NettyProducer.class);
    private final NettyProducer producer;
    private volatile boolean messageReceived;
    private volatile boolean exceptionHandled;

    public ClientChannelHandler(NettyProducer producer) {
        this.producer = producer;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent channelStateEvent) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel open: {}", (Object)ctx.getChannel());
        }
        this.producer.getAllChannels().add((Object)channelStateEvent.getChannel());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent exceptionEvent) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Exception caught at Channel: " + ctx.getChannel(), exceptionEvent.getCause());
        }
        if (this.exceptionHandled) {
            return;
        }
        this.exceptionHandled = true;
        Throwable cause = exceptionEvent.getCause();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing channel as an exception was thrown from Netty", cause);
        }
        Exchange exchange = this.getExchange(ctx);
        AsyncCallback callback = this.getAsyncCallback(ctx);
        if (exchange != null && callback != null) {
            exchange.setException(cause);
            NettyHelper.close(exceptionEvent.getChannel());
            callback.done(false);
        }
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Channel closed: {}", (Object)ctx.getChannel());
        }
        Exchange exchange = this.getExchange(ctx);
        AsyncCallback callback = this.getAsyncCallback(ctx);
        this.producer.removeState(ctx.getChannel());
        this.producer.getAllChannels().remove((Object)ctx.getChannel());
        if (this.producer.getConfiguration().isSync() && !this.messageReceived && !this.exceptionHandled) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Channel closed but no message received from address: {}", (Object)this.producer.getConfiguration().getAddress());
            }
            exchange.setException((Throwable)new CamelExchangeException("No response received from remote server: " + this.producer.getConfiguration().getAddress(), exchange));
            callback.done(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws Exception {
        Message message;
        Exchange exchange;
        ChannelHandler handler;
        this.messageReceived = true;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Message received: {}", (Object)messageEvent);
        }
        if (this.producer.getConfiguration().getRequestTimeout() > 0L && (handler = ctx.getPipeline().get("timeout")) != null) {
            LOG.trace("Removing timeout channel as we received message");
            ctx.getPipeline().remove(handler);
        }
        if ((exchange = this.getExchange(ctx)) == null) {
            return;
        }
        AsyncCallback callback = this.getAsyncCallback(ctx);
        try {
            message = this.getResponseMessage(exchange, messageEvent);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
            callback.done(false);
            return;
        }
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            exchange.setOut(message);
        } else {
            exchange.setIn(message);
        }
        try {
            Boolean close = ExchangeHelper.isOutCapable((Exchange)exchange) ? (Boolean)exchange.getOut().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class) : (Boolean)exchange.getIn().getHeader("CamelNettyCloseChannelWhenComplete", Boolean.class);
            if (close == null) {
                close = (Boolean)exchange.getProperty("CamelNettyCloseChannelWhenComplete", Boolean.class);
            }
            boolean disconnect = this.producer.getConfiguration().isDisconnect();
            if (close != null) {
                disconnect = close;
            }
            if (disconnect) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Closing channel when complete at address: {}", (Object)this.producer.getConfiguration().getAddress());
                }
                NettyHelper.close(ctx.getChannel());
            }
        }
        finally {
            callback.done(false);
        }
    }

    protected Message getResponseMessage(Exchange exchange, MessageEvent messageEvent) throws Exception {
        Object body = messageEvent.getMessage();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel: {} received body: {}", new Object[]{messageEvent.getChannel(), body});
        }
        if (this.producer.getConfiguration().isTextline()) {
            body = this.producer.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, body);
        }
        if (ExchangeHelper.isOutCapable((Exchange)exchange)) {
            NettyPayloadHelper.setOut(exchange, body);
            return exchange.getOut();
        }
        NettyPayloadHelper.setIn(exchange, body);
        return exchange.getIn();
    }

    private Exchange getExchange(ChannelHandlerContext ctx) {
        NettyCamelState state = this.producer.getState(ctx.getChannel());
        return state != null ? state.getExchange() : null;
    }

    private AsyncCallback getAsyncCallback(ChannelHandlerContext ctx) {
        NettyCamelState state = this.producer.getState(ctx.getChannel());
        return state != null ? state.getCallback() : null;
    }
}

